///////////////////////////////////////////////////////////
//  vd_adr3Msg_sequenceCtrl.cpp
//  Implementation of the Class vd_adr3Msg_sequenceCtrl
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_sequenceCtrl.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SEQUENCECTRL
#include "trcGenProj/Header/vd_adr3Msg_sequenceCtrl.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Source/IDSequenceCtrl.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_sequenceCtrl::vd_adr3Msg_sequenceCtrl(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_sequenceCtrl")
{
  ETG_TRACE_USR4(("vd_adr3Msg_sequenceCtrl::vd_adr3Msg_sequenceCtrl constructor. "));
  (tVoid)pAdr3Main;

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_sequenceCtrl::~vd_adr3Msg_sequenceCtrl()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_sequenceCtrl::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_sequenceCtrl::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_sequenceCtrl::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SequenceCtrl);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_sequenceCtrl::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_sequenceCtrl::MessageNotification entered. "));

  // Obtaining the sequenceCtrl Message from PostOffice handler by sequenceCtrl
  const MSG_SequenceCtrl*     pMsg = pPO->POMessages->QueryMessage<MSG_SequenceCtrl>(MsgId);

  ETG_TRACE_USR4(("Audio sequenceCtrl Observer received autoParameterUpdate: 0x%4x.", pMsg->enAutoParameterUpdate));


  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SEQUENCE_CTRL;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
  oMsgOut.u16MsgLen  = 1;
  pu8Payload[0]     = pMsg->enAutoParameterUpdate;
  ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

  oMsgOut.u8ThreadMessageType = SEQUENCECONTROL;
    //not implemented by the ADR. Not required. Messages are immediately updated, when device is muted.
  //vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

