///////////////////////////////////////////////////////////
//  vd_adr3Msg_notification.cpp
//  Implementation of the Class vd_adr3Msg_notification
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_notification.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
#include "trcGenProj/Header/vd_adr3Msg_notification.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/power/IDNotification.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_notification::vd_adr3Msg_notification(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_notification")
{
  ETG_TRACE_USR4(("vd_adr3Msg_notification::vd_adr3Msg_notification constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_notification::~vd_adr3Msg_notification()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_notification::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_notification::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_notification::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Notification);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_notification::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_notification::MessageNotification entered. "));
  // Obtaining the vd_adr3Msg_notification Message from PostOffice handler
  const ID_Notification*     pMsg = pPO->POMessages->QueryMessage<ID_Notification>(MsgId);

  ETG_TRACE_USR4(("ID_Notification Observer received ControlType: 0x%4x.", pMsg->ControlType));
  ETG_TRACE_USR4(("ID_Notification Observer received FunctionID: 0x%4x.", pMsg->FunctionID));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_NOTIFICATION;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
  oMsgOut.u16MsgLen  = 3;
  pu8Payload[0]     = pMsg->ControlType;//   0x01; //NOTIFICATION_CONTROL_SETFUNCTION
  pu8Payload[1]     = (tU8) (((pMsg->FunctionID) & 0xFF00)>>8);
  pu8Payload[2]     = (tU8) ((pMsg->FunctionID) & 0x00FF);

  oMsgOut.u8ThreadMessageType = NOTIFICATION;
  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}
