///////////////////////////////////////////////////////////
//  vd_adr3Msg_mute.cpp
//  Implementation of the Class vd_adr3Msg_mute
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_mute.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_MUTE
#include "trcGenProj/Header/vd_adr3Msg_mute.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "../../InternalComponentCommunication/Messages/mute/IDNotifyMute.h"
#include "../../util/Macro.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_SonarInfo.h"
#include "Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#endif

/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_mute::vd_adr3Msg_mute(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_mute")
{
  ETG_TRACE_USR4(("vd_adr3Msg_mute::vd_adr3Msg_mute constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   m_SoundRequestAndDirection = No_Sound_Request;
   m_ConnectionState = AMP_NOT_CONNECTED;
#endif
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_mute::~vd_adr3Msg_mute()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
 pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_mute::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_mute::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_mute::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetMute);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SonarInfo);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
#endif
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_mute::MessageNotification(PO_MessageConfig::enID MsgId)
{
  switch(MsgId)
  {
  case (PO_MessageConfig::ID_SetMute):
    {
      trMsgOut oMsgOut;
      tU8 *pu8Payload = oMsgOut.au8MsgData;
      ETG_TRACE_USR4(("vd_adr3Msg_mute::MessageNotification entered. "));
      // Obtaining the Mute Message from PostOffice handler by mute
      const ID_SetMute*     pMsg = pPO->POMessages->QueryMessage<ID_SetMute>(MsgId);

      ETG_TRACE_USR4(("Audio mute Observer received Stream: 0x%4x.", pMsg->enStream));
      ETG_TRACE_USR4(("Audio mute Observer received Source: 0x%4x.", pMsg->enMuteAction));

      //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  //oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u8InstId  = static_cast<tU8>(pMsg->u16Sink);
      oMsgOut.u16FktId   = VD_ADR3_FKT_ID_MUTE;
      oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
      oMsgOut.u16MsgLen  = 6;
      pu8Payload[0]     = pMsg->enStream;
      pu8Payload[1]     = pMsg->enMuteAction;
      AUD_SET_U16(&pu8Payload[2], pMsg->u16RampLin);
      AUD_SET_U16(&pu8Payload[4], pMsg->u16RampdB);
      ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

      switch(pMsg->enStream)
      {
      case EN_AUDIO_SOURCE_STREAM_MAIN:
    {
          if(oMsgOut.u8InstId==2)
        oMsgOut.u8ThreadMessageType = MUTE_EXC_SINK2;
            else if(oMsgOut.u8InstId==17)
        oMsgOut.u8ThreadMessageType = MUTE_EXC_SINK17;
            else
        oMsgOut.u8ThreadMessageType = MUTE_EXC;

        vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
    }
        break;
      case EN_AUDIO_SOURCE_STREAM_MIX1:
      {
        oMsgOut.u8ThreadMessageType = MUTE_MIX1;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
        if(m_ConnectionState == AMP_CONNECTED)
        {
          if(pMsg->enMuteAction == EN_AUDIO_MUTE_MUTEACTION_On)
            vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
          else if((pMsg->enMuteAction == EN_AUDIO_MUTE_MUTEACTION_Off)&&(m_SoundRequestAndDirection == No_Sound_Request))
          {
            vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
          }
          else
          {
            ETG_TRACE_USR4(("!!! Sonar sound is running, Hence, Not demuting the Mix1 Stream"));
          }
        }
        else
          vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
#else
        vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
#endif
      }
        break;
      case EN_AUDIO_SOURCE_STREAM_MIX2:
      {
        oMsgOut.u8ThreadMessageType = MUTE_MIX2;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
        if(m_ConnectionState == AMP_CONNECTED)
        {
          if(pMsg->enMuteAction == EN_AUDIO_MUTE_MUTEACTION_On)
            vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
          else if((pMsg->enMuteAction == EN_AUDIO_MUTE_MUTEACTION_Off)&&(m_SoundRequestAndDirection == No_Sound_Request))
          {
            vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
          }
          else
          {
            ETG_TRACE_USR4(("!!! Sonar sound is running, Hence, Not demuting the Mix2 Stream"));
          }
        }
        else
          vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
#else
        vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
#endif
            }
        break;
      case EN_AUDIO_SOURCE_STREAM_MIX3:
        oMsgOut.u8ThreadMessageType = MUTE_MIX3;
        vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
        break;
      default:
        ETG_TRACE_USR4(("!!! MessageNotification for undefined stream   : 0x%4x.", pMsg->enStream));
        break;
      }


#if ( defined( LSIM) )
      if (pMsg->enMuteAction == EN_AUDIO_MUTE_MUTEACTION_Off)
      {
        ID_NotifyMute oNotifyMute_Running(static_cast<tenStream>(pMsg->enStream),static_cast<tenMuteResult>(EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING));
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyMute_Running);

        ID_NotifyMute oNotifyMute(static_cast<tenStream>(pMsg->enStream),static_cast<tenMuteResult>(EN_AUDIO_MUTE_MUTERESULT_DEMUTE));
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyMute);
      }
      else
      {
        ID_NotifyMute oNotifyMute(static_cast<tenStream>(pMsg->enStream),static_cast<tenMuteResult>(EN_AUDIO_MUTE_MUTERESULT_MUTE));
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyMute);
      }
#endif
    }
    break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
  case PO_MessageConfig::ID_SonarInfo:
  {
    const ID_SonarInfo* pSonarInfo;
    pSonarInfo = pPO->POMessages->QueryMessage<ID_SonarInfo>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSonarInfo);
    m_SoundRequestAndDirection = (te8SoundRequestAndDirection)pSonarInfo->m_u8SoundRequestAndDirection;

    ETG_TRACE_USR4(("ID_SonarInfo message received with m_SoundRequestAndDirection = %d",m_SoundRequestAndDirection));
  }
  break;

      case PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus:
      {
        //get the connection state of the BOSEAMplife
        const ID_BOSE_Amplifier_ConnectionStatus* pMsgBoseAmp_ConnectionStatus = pPO->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
        m_ConnectionState = (AmpConnectionState)pMsgBoseAmp_ConnectionStatus->connectionstate;
        ETG_TRACE_USR3(("Observer received BOSE Amplifier cOnnection State = %x",m_ConnectionState));
      break;
      }
#endif
  default:
    break;
  }
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_mute::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubStream;
  tU8 ubMuteState;
  tU8 ubResource;

  ubStream    = poAdrResponse->au8MsgData[0];
  ubMuteState = poAdrResponse->au8MsgData[1];
  ubResource  = poAdrResponse->u8InstId;

  ETG_TRACE_USR4(("ADDED_ADR3 vSendADRResponse received Sink %d ", ubResource));
  ETG_TRACE_USR4(("vSendADRResponse received ubStream   : 0x%4x.", ubStream));
  ETG_TRACE_USR4(("vSendADRResponse received ubMuteState: 0x%4x.", ubMuteState));

  if(ubMuteState == EN_AUDIO_MUTE_MUTERESULT_DEMUTE)
  {
    tU8 u8Data[10] = {
        TRC::enModule_fc_audiomanager,
        TRC::enFile_vd_adr3Msg_mute,
        TRC::enFkt_vSendADRResponse,
        ubStream,ubMuteState,0,0,0,0,0};
    tU32 u32Line = __LINE__;
    u8Data[5] = (tU8)(((u32Line+6) & 0xFF000000)>>24);
    u8Data[6] = (tU8)(((u32Line+6) & 0x00FF0000)>>16);
    u8Data[7] = (tU8)(((u32Line+6) & 0x0000FF00)>>8);
    u8Data[8] = (tU8)((u32Line+6) & 0x000000FF);
    et_vTraceBinary(TR_CLASS_AUDIO_SRC_CHANGE_MEAS, TR_LEVEL_ERRORS, ET_EN_T8LIST, 10, u8Data, ET_EN_DONE);
  }

  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifyMute notifyMute(static_cast<tenStream>(ubStream),static_cast<tenMuteResult>(ubMuteState),static_cast<tenSinks>(ubResource));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyMute);


}
