///////////////////////////////////////////////////////////
//  vd_adr3Msg_inputVolumeOffset.cpp
//  Implementation of the Class vd_adr3Msg_inputVolumeOffset
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_inputVolumeOffset.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_INPUTVOLUMEOFFSET
#include "trcGenProj/Header/vd_adr3Msg_inputVolumeOffset.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetInputVolumeOffset.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_inputVolumeOffset::vd_adr3Msg_inputVolumeOffset(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_inputVolumeOffset")
{
  ETG_TRACE_USR4(("vd_adr3Msg_inputVolumeOffset::vd_adr3Msg_inputVolumeOffset constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_inputVolumeOffset::~vd_adr3Msg_inputVolumeOffset()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_inputVolumeOffset::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_inputVolumeOffset::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_inputVolumeOffset::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetInputVolumeOffset);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_inputVolumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_inputVolumeOffset::MessageNotification entered. "));
  // Obtaining the AudioinputVolumeOffset Message from PostOffice handler by Volume
  const MSG_SetInputVolumeOffset*     pMsg = pPO->POMessages->QueryMessage<MSG_SetInputVolumeOffset>(MsgId);

  ETG_TRACE_USR4(("inputVolumeOffset Observer received m_enStream: 0x%4x.",   pMsg->values.m_enStream));
  ETG_TRACE_USR4(("inputVolumeOffset Observer received s16Offset: 0x%4x.",    pMsg->values.s16Offset));
  ETG_TRACE_USR4(("inputVolumeOffset Observer received u16RampLin: 0x%4x.",   pMsg->values.u16RampLin));
  ETG_TRACE_USR4(("inputVolumeOffset Observer received u16RampdB: 0x%4x.",    pMsg->values.u16RampdB));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_INPUT_VOLUME_OFFSET;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 7;
  pu8Payload[0]     = (pMsg->values.m_enStream);
  pu8Payload[1]       = (tU8) (((pMsg->values.s16Offset) & 0xFF00)>>8);
  pu8Payload[2]       = (tU8) ((pMsg->values.s16Offset) & 0x00FF);
  pu8Payload[3]       = (tU8) (((pMsg->values.u16RampLin) & 0xFF00)>>8);
  pu8Payload[4]       = (tU8) ((pMsg->values.u16RampLin) & 0x00FF);
  pu8Payload[5]       = (tU8) (((pMsg->values.u16RampdB) & 0xFF00)>>8);
  pu8Payload[6]       = (tU8) ((pMsg->values.u16RampdB) & 0x00FF);

  //oMsgOut.u8ThreadMessageType = ; message type not used

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

