///////////////////////////////////////////////////////////
//  vd_adr3Msg_diagSpeaker.cpp
//  Implementation of the Class vd_adr3Msg_diagSpeaker
//  Created on:      06-March-2014
//  Original author: pau4kor
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_diagSpeaker.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_DIAGRESULT
#include "trcGenProj/Header/vd_adr3Msg_diagSpeaker.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDStartDiagTest.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDNotifyDiagResult.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDGetDiagStatus.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDNotifyDiagStatus.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDDiagTurnONStatus.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_diagSpeaker::vd_adr3Msg_diagSpeaker(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_diagSpeaker")
{
  ETG_TRACE_USR4(("vd_adr3Msg_diagResult::vd_adr3Msg_diagSpeaker constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_diagSpeaker::~vd_adr3Msg_diagSpeaker()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
 pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_diagSpeaker::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_StartDiagTest);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_GetDiagStatus);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagTurnONStatus);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_diagSpeaker::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker::MessageNotification entered. "));
  // Obtaining the Diag Message from PostOffice handler
  switch(MsgId)
  {
  case(PO_MessageConfig::ID_StartDiagTest):
  {
    const ID_StartDiagTest*     pMsg = pPO->POMessages->QueryMessage<ID_StartDiagTest>(MsgId);

    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received ModeDC: 0x%4x.", pMsg->enSpeakerModeDC));
    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received ModeAC: 0x%4x.", pMsg->enSpeakerModeAC));
    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received Stream ModePERM: 0x%4x.", pMsg->enSpeakerModePERM));

    //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
    oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
    oMsgOut.u16FktId   = VD_ADR3_FKT_ID_DIAG_SPEAKER;
    oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
    oMsgOut.u16MsgLen  = 3;
    pu8Payload[0]     = pMsg->enSpeakerModeDC;
    pu8Payload[1]    = pMsg->enSpeakerModeAC;
    pu8Payload[2]    = pMsg->enSpeakerModePERM;

    oMsgOut.u8ThreadMessageType = DIAG_SET_SPEAKER;
    vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
    break;
  }
  case(PO_MessageConfig::ID_GetDiagStatus):
  {

    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received for DiagStatus"));

    //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
    oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
    oMsgOut.u16FktId   = VD_ADR3_FKT_ID_DIAG_SPEAKER;
    oMsgOut.enOpType   = VD_ADR3_OPTYPE_GET;
    oMsgOut.u16MsgLen  = 0;

    oMsgOut.u8ThreadMessageType = DIAG_GET_SPEAKER;
    vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
    break;
  }
  case (PO_MessageConfig::ID_DiagTurnONStatus):
    {
      const ID_DiagTurnONStatus* pMsg = pPO->POMessages->QueryMessage<ID_DiagTurnONStatus>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received for Diagnosis Turn ON Status, pMsg->enDiagTurnONStatus:%d",pMsg->enDiagTurnONStatus));
      //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
      oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
      oMsgOut.u16FktId   = VD_ADR3_FKT_ID_DIAG_TURN_ON;
      oMsgOut.enOpType   = VD_ADR3_OPTYPE_SET;
      oMsgOut.u16MsgLen  = 1;
      pu8Payload[0]    = pMsg->enDiagTurnONStatus;
      oMsgOut.u8ThreadMessageType = DIAG_SET_TURNONSTATUS;
      vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
      break;
    }
  default:
    ETG_TRACE_USR4(("vd_adr3Msg_diagSpeaker:: Observer received for unknown message id"));
    break;
  }
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_diagSpeaker::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubDiagStatus;

  ubDiagStatus = poAdrResponse->au8MsgData[0];

  ETG_TRACE_USR4(("vSendADRResponse received ubDiagStatus: 0x%4x.", ubDiagStatus));

  //Delivering the ID_NotifyDiagStatus  Message back to Service Function
  ID_NotifyDiagStatus notifyDiagStatus(static_cast<tenDiagnosisStatus>(ubDiagStatus));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyDiagStatus);

}


