///////////////////////////////////////////////////////////
//  vd_adr3Msg_chimeParameters.cpp
//  Implementation of the Class vd_adr3Msg_chimeParameters
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_chimeParameters.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_CHIMEPARAMETERS
#include "trcGenProj/Header/vd_adr3Msg_chimeParameters.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDChimeParameters.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDNotifyChimeParameters.h"
#include "../../InternalComponentCommunication/DataTypes/MessageDataTypes/ChimeData.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3NotifyBeep.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_chimeParameters::vd_adr3Msg_chimeParameters(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_chimeParameters")
{
  (tVoid)pAdr3Main;
  ETG_TRACE_USR4(("vd_adr3Msg_chimeParameters::vd_adr3Msg_chimeParameters constructor. "));

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_chimeParameters::~vd_adr3Msg_chimeParameters()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_chimeParameters::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_chimeParameters::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_chimeParameters::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ChimeParameters);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_chimeParameters::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_chimeParameters::MessageNotification entered. "));
  // Obtaining the ChimeParameters Message from PostOffice handler by Beep
  const MSG_ChimeParameters*     pMsg = pPO->POMessages->QueryMessage<MSG_ChimeParameters>(MsgId);


  ETG_TRACE_USR4(("SignalToneParam Observer received m_Pulses: 0x%4x.", pMsg->values.Pulses));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_AttackTime: 0x%4x.", pMsg->values.AttackTime));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_AttackTimeLog: 0x%4x.", pMsg->values.AttackTimeLog));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_AttackTimeLin: 0x%4x.", pMsg->values.AttackTimeLin));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_ReleaseTime: 0x%4x.", pMsg->values.ReleaseTime));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_ReleaseTimeLog: 0x%4x.", pMsg->values.ReleaseTimeLog));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_ReleaseTimeLin: 0x%4x.", pMsg->values.ReleaseTimeLin));
  ETG_TRACE_USR4(("SignalToneParam Observer received m_SignalToneAction: 0x%4x.", pMsg->values.SignalToneAction));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_CHIME_PARAM;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 16;
  pu8Payload[0]       = 0x01; //this might also be e.g. fixed Beep_Error ID
  pu8Payload[1]       = (tU8) (((pMsg->values.Pulses) & 0xFF00)>>8);
  pu8Payload[2]       = (tU8) ((pMsg->values.Pulses) & 0x00FF);
  pu8Payload[3]       = (tU8) (((pMsg->values.AttackTime) & 0xFF00)>>8);
  pu8Payload[4]       = (tU8) ((pMsg->values.AttackTime) & 0x00FF);
  pu8Payload[5]       = (tU8) (((pMsg->values.AttackTimeLog) & 0xFF00)>>8);
  pu8Payload[6]       = (tU8) ((pMsg->values.AttackTimeLog) & 0x00FF);
  pu8Payload[7]       = (tU8) (((pMsg->values.AttackTimeLin) & 0xFF00)>>8);
  pu8Payload[8]       = (tU8) ((pMsg->values.AttackTimeLin) & 0x00FF);
  pu8Payload[9]       = (tU8) (((pMsg->values.ReleaseTime) & 0xFF00)>>8);
  pu8Payload[10]       = (tU8) ((pMsg->values.ReleaseTime) & 0x00FF);
  pu8Payload[11]       = (tU8) (((pMsg->values.ReleaseTimeLog) & 0xFF00)>>8);
  pu8Payload[12]       = (tU8) ((pMsg->values.ReleaseTimeLog) & 0x00FF);
  pu8Payload[13]       = (tU8) (((pMsg->values.ReleaseTimeLin) & 0xFF00)>>8);
  pu8Payload[14]       = (tU8) ((pMsg->values.ReleaseTimeLin) & 0x00FF);
  pu8Payload[15]      = (tU8) (pMsg->values.SignalToneAction);


   oMsgOut.u8ThreadMessageType = SIGNALCHIMEPARAMETERS;
   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_chimeParameters::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubBeepState;

  ubBeepState    = poAdrResponse->au8MsgData[1];
  ETG_TRACE_USR4(("vSendADRResponse received ubBeepState   : 0x%4x.", ubBeepState));


  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifyChimeParameters notifyChimeParameters(static_cast<tenBeepState>(ubBeepState));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyChimeParameters);
}

/********************************************************************************
 * vSendErrorResponse()
 *******************************************************************************/
void vd_adr3Msg_chimeParameters::vSendErrorResponse()
{
  ETG_TRACE_USR4(("Error Response received for Signal Chime Parameters"));

  tU8 ubBeepState = 0xFF; //Error response (EN_AUDIO_BEEP_FAILURE)

  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifyChimeParameters notifyChimeParameters(static_cast<tenBeepState>(ubBeepState));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyChimeParameters);
}
