///////////////////////////////////////////////////////////
//  vd_adr3Msg_arkamysParameter.cpp
//  Implementation of the Class vd_adr3Msg_arkamysParameter
//  Created on:      28-July-2014
//  Original author: wie1hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_arkamysParameter.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_TUNING_DATA_SERVICE //TR_CLASS_VD_ADR3_MAIN
#include "trcGenProj/Header/vd_adr3Msg_arkamysParameter.cpp.trc.h"
#endif

#include "../../Sound/ArkamysTuningHandler.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"
#include "../../InternalComponentCommunication/Messages/Sound/ID_Arkamys.h"
#include "../../InternalComponentCommunication/Messages/Sound/ID_ArkamysMode.h"
//#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/
vd_adr3Msg_arkamysParameter::vd_adr3Msg_arkamysParameter(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_arkamysParameter")
{
   ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter::vd_adr3Msg_arkamysParameter constructor. "));
   (tVoid)pAdr3Main;
   pPO = InternalCommunicationAdapter::getInstance();
   vAddObserver();
}

/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_arkamysParameter::~vd_adr3Msg_arkamysParameter()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_arkamysParameter::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ArkamysParameter);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Arkamys);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_arkamysParameter::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
//  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter::MessageNotification entered. "));
  // Obtaining the Message from PostOffice handler
  switch(MsgId)
  {
  case(PO_MessageConfig::ID_ArkamysParameter):
  {
//    const ID_ArkamysParameter*     pMsg = pPO->POMessages->QueryMessage<ID_ArkamysParameter>(MsgId);
//    ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter: Received Msg ID_ArkamysParameter"));
//    ArkamysTuningHandler* pArkamysTuningHandler = ArkamysTuningHandler::getInstance();
//    pArkamysTuningHandler -> AdrMessageRx(pMsg);
    break;
  }
  case(PO_MessageConfig::ID_Arkamys):
  {
    ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter:: ID_Arkamys"));
    const ID_Arkamys*     pMsg = pPO->POMessages->QueryMessage<ID_Arkamys>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

        oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
        oMsgOut.u16FktId  = VD_ADR3_FKT_ID_ARKAMYS_PARAMETER;
        oMsgOut.enOpType  = pMsg->arkamysStaticMessage.command;
        oMsgOut.u16MsgLen = (tU16)pMsg->arkamysStaticMessage.size;
        oMsgOut.u8ThreadMessageType = ARKAMYS_PARAMETER;
        OSAL_pvMemoryCopy(oMsgOut.au8MsgData, &pMsg->arkamysStaticMessage.data, pMsg->arkamysStaticMessage.size);

        ETG_TRACE_USR4(("TID = %i", OSAL_ThreadWhoAmI()));
        ETG_TRACE_USR4(("Data to vSendAdr3Msg: opType=%i Len=%i Data=%02x"
              , oMsgOut.enOpType
              , oMsgOut.u16MsgLen
              , ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(oMsgOut.au8MsgData)));
        vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
    break;
  }
  default:
    ETG_TRACE_USR4(("vd_adr3Msg_arkamysParameter:: Observer received for unknown message id"));
    break;
  }
}

/********************************************************************************
 * vSendADRResponse() - for arkamys mode
 *******************************************************************************/
void vd_adr3Msg_arkamysParameter::vSendADRResponse(trMsgOut *poAdrResponse)
{

  tU16 msgLen = poAdrResponse->u16MsgLen;
  ETG_TRACE_USR4(("vSendADRResponse received u16MsgLen: 0x%4x.", msgLen));
  tenArkamysMode enArkamysMode = (tenArkamysMode)poAdrResponse->au8MsgData[0];
  ETG_TRACE_USR4(("vSendADRResponse received enArkamysMode: 0x%4x.", enArkamysMode));

  ID_ArkamysMode oArkamysMode(enArkamysMode);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oArkamysMode);

}


