///////////////////////////////////////////////////////////
//  vd_adr3Msg_If.h
//  Implementation of the Class vd_adr3Msg_If
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////
#ifndef VD_ADR3MSG_IF_H
#define VD_ADR3MSG_IF_H
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "system_types.h"
#include "vd_adr3_If.h"
#include "vd_adr3_thread.h"
#include "vd_adr3Message_Data.h"
#include "../../fc_audiomanager_trace_input.h"



#define AUD_ASSERT_RETURN(expr)                 \
    if (!(expr)) {                          \
      NORMAL_M_ASSERT_ALWAYS();           \
      return;                             \
    }
class vd_adr3_If;
class vd_adr3_main;
class vd_adr3_thread;
class vd_adr3Message_Data;
class sinkmgr_main;

#define test (tU16)AUD_ADR_MAX_PAYLOAD

class trMsgOut
{
public:
  trMsgOut();
  ~trMsgOut();

  tU8 u8InstId;
  tU16 u16FktId;
  tU8 enOpType;
  tU16 u16MsgLen;
  tU8* au8MsgData;
  tU8 u8ThreadMessageType; //used for message buffer handling
};


//ADR3 client ID
#ifdef LSIM
  #define AUD_CLIENT_ID (tU16)0x0815
#else
  #define AUD_CLIENT_ID (tU16)0x0010
#endif
//ADR3 function block ID
#define AUD_FBLOCK_ID (tU16)0x0091

//ADR3 Funktion IDs
#define VD_ADR3_FKT_ID               (tU16)0x0000
#define VD_ADR3_FKT_ID_NOTIFICATION       (tU16)0x0001
#define VD_ADR3_FKT_ID_NOTIFICATION_CHECK     (tU16)0x0002
#define VD_ADR3_FKT_ID_STARTUP           (tU16)0x0F01
#define VD_ADR3_FKT_ID_PING           (tU16)0x0F02
#define VD_ADR3_FKT_ID_AMPLIFIERDEVICE          (tU16)0x0F09
#define VD_ADR3_FKT_ID_POWER_STATE         (tU16)0x0F11
#define VD_ADR3_FKT_ID_MAINTENANCE_MODE     (tU16)0x0F12
#define VD_ADR3_FKT_ID_SOURCE           (tU16)0x0F13
#define VD_ADR3_FKT_ID_SEQUENCE_CTRL       (tU16)0x0F14
#define VD_ADR3_FKT_ID_AUDIO_ROUTE         (tU16)0x0F15
#define VD_ADR3_FKT_ID_VOLUME           (tU16)0x0F20
#define VD_ADR3_FKT_ID_VOLUME_OFFSET       (tU16)0x0F21
#define VD_ADR3_FKT_ID_INPUT_VOLUME_OFFSET     (tU16)0x0F22
#define VD_ADR3_FKT_ID_CLIPPING                 (tU16)0x0F23
#define VD_ADR3_FKT_ID_SETTINGS         (tU16)0x0F30
#define VD_ADR3_FKT_ID_SET_FILTER         (tU16)0x0F35
#define VD_ADR3_FKT_ID_EQU_SETTINGS       (tU16)0x0F36
#define VD_ADR3_FKT_ID_SDVC_STATE         (tU16)0x0F38
#define VD_ADR3_FKT_ID_MUTE           (tU16)0x0F60
#define VD_ADR3_FKT_ID_MUTE_CHANNEL       (tU16)0x0F61
#define VD_ADR3_FKT_ID_SIGNAL_TONE         (tU16)0x0F80
#define VD_ADR3_FKT_ID_SIGNAL_TONE_PARAM    (tU16)0x0F81
#define VD_ADR3_FKT_ID_CHIME_PARAM        (tU16)0x0F82
#define VD_ADR3_FKT_ID_SOUND_MODE         (tU16)0x0F84
#define VD_ADR3_FKT_ID_DIAG_START               (tU16)0x0F90
#define VD_ADR3_FKT_ID_DIAG_RESULT              (tU16)0x0F91
#define VD_ADR3_FKT_ID_DIAG_SPEAKER             (tU16)0x0F92
#define VD_ADR3_FKT_ID_DIAG_TURN_ON             (tU16)0x0F94
#define VD_ADR3_FKT_ID_SOUND_CONFIG_SET     (tU16)0x0FA0
#define VD_ADR3_FKT_ID_SOUND_CONFIG_RESTORE   (tU16)0x0FA1
#define VD_ADR3_FKT_ID_SOUND_CONFIG_SAVE     (tU16)0x0FA2
#define VD_ADR3_FKT_ID_SOUND_CONFIG_DELETE     (tU16)0x0FA3
#define VD_ADR3_FKT_ID_SOUND_CONFIG_ITEM     (tU16)0x0FA4
#define VD_ADR3_FKT_ID_SOUND_CONFIG_VERSION    (tU16)0x0FA5
#define VD_ADR3_FKT_ID_CAR_SETTING        (tU16)0x0FB0
#define VD_ADR3_FKT_ID_ARKAMYS_PARAMETER        (tU16)0x0FE0
#define VD_ADR3_FKT_ID_ENGINE_SOUND_PARAMETER   (tU16)0x0FE1
#define VD_ADR3_FKT_ID_ENGINE_SOUND_VERSION     (tU16)0x0FE2
#define VD_ADR3_FKT_ID_ENGINE_SOUND_ONOFF       (tU16)0x0FE3
#define VD_ADR3_FKT_ID_ENGINE_SOUND_VOLUME      (tU16)0x0FE4
#define VD_ADR3_FKT_ID_ARKAMYS_MODE             (tU16)0x0FE5
#define VD_ADR3_FKT_ID_ARKAMYS_FMENHANCER_MODE  (tU16)0x0FE6
#define VD_ADR3_FKT_ID_ARKAMYS_RESET            (tU16)0x0FE7
#define VD_ADR3_FKT_ID_ARKAMYS_LEVEL_LOSS       (tU16)0x0FE8
#define VD_ADR3_FKT_ID_ARKAMYS_LEVEL_DEVIATION  (tU16)0x0FE9
#define VD_ADR3_FKT_ID_ESE_LIB_VERSION          (tU16)0x0FEA
#define VD_ADR3_FKT_ID_ARKAMYS_CONFIG_DATA      (tU16)0x0FEB
#define VD_ADR3_FKT_ID_ANC_ONOFF        (tU16)0x0FED
#define VD_ADR3_FKT_ID_ANC_VOLUME        (tU16)0x0FEE
#define VD_ADR3_FKT_ID_FACTORY_CONTAINER        (tU16)0x0FFF1
#define VD_ADR3_FKT_ID_AMPLIFIER_MODE           (tU16)0x0FFF5

//ADR3 instance IDs
#define VD_ADR3_INST_ID_LS_1     (tU8)0x01
#define VD_ADR3_INST_ID_LS_2     (tU8)0x02
#define VD_ADR3_INST_ID_RSA_1     (tU8)0x11
#define VD_ADR3_INST_ID_RSA_2     (tU8)0x12
#define VD_ADR3_INST_ID_DIG_OUT_1   (tU8)0x21
#define VD_ADR3_INST_ID_DIG_OUT_2  (tU8)0x22
#define VD_ADR3_INST_ID_ANA_OUT_1   (tU8)0x31

//ADR3 Operator types
#define VD_ADR3_OPTYPE_SET      (tU8)0x00
#define VD_ADR3_OPTYPE_GET      (tU8)0x01
#define VD_ADR3_OPTYPE_SETGET    (tU8)0x02
#define VD_ADR3_OPTYPE_INCREMENT  (tU8)0x03
#define VD_ADR3_OPTYPE_DECREMENT  (tU8)0x04
#define VD_ADR3_OPTYPE_STATUS    (tU8)0x0C
#define VD_ADR3_OPTYPE_ERROR    (tU8)0x0F

//ADR3 Mute Channel Mask
#define VD_ADR3_MUTECHANNEL_MASK_LF (tU8)0x01
#define VD_ADR3_MUTECHANNEL_MASK_RF (tU8)0x02
#define VD_ADR3_MUTECHANNEL_MASK_LR (tU8)0x04
#define VD_ADR3_MUTECHANNEL_MASK_RR (tU8)0x08
#define VD_ADR3_MUTECHANNEL_MASK_CE (tU8)0x10

// #define SOUND_CONFIG_ITEM_TYPE_SOURCE            ((tU8)0x01)
#define SOUND_CONFIG_ITEM_TYPE_SPEAKER           ((tU8)0x02)
#define SOUND_CONFIG_ITEM_TYPE_SOUNDSYSTEM       ((tU8)0x03)
#define SOUND_CONFIG_ITEM_TYPE_REGION            ((tU8)0x04)
#define SOUND_CONFIG_ITEM_TYPE_VEHICLE           ((tU8)0x05)
// #define SOUND_CONFIG_ITEM_TYPE_STREAM            ((tU8)0x06)
// #define SOUND_CONFIG_ITEM_TYPE_SINK              ((tU8)0x07)
// #define SOUND_CONFIG_ITEM_TYPE_PREMIX_EQ_MODE    ((tU8)0x08)

// Values for SOUND_ITEM_TYPE_SPEAKER
#define SOUND_CONFIG_ITEM_VALUE_4SPEAKER         ((tU8)0x01)
#define SOUND_CONFIG_ITEM_VALUE_2SPEAKER_FRONT   ((tU8)0x02)
#define SOUND_CONFIG_ITEM_VALUE_2SPEAKER_REAR    ((tU8)0x03)

// Values for SOUND_ITEM_TYPE_REGION
#define SOUND_CONFIG_ITEM_VALUE_EUROPE           ((tU8)0x01)
#define SOUND_CONFIG_ITEM_VALUE_NAR              ((tU8)0x02)
#define SOUND_CONFIG_ITEM_VALUE_ROW              ((tU8)0x03)
#define SOUND_CONFIG_ITEM_VALUE_ASIA             ((tU8)0x04)

// Values for SOUND_ITEM_TYPE_SOUNDSYSTEM
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1     ((tU8)0x01)  //internal amplifier
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2     ((tU8)0x02)  //internal amplifier with SUB
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3     ((tU8)0x03)  //analog amplifier1 [e.g. FOSGATE with special sound]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4     ((tU8)0x04)  //analog amplifier 1 [e.g. BOSE with special sound]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM5     ((tU8)0x05)  //analog amplifier3 [no special sound handling]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM6     ((tU8)0x06)  //MOST amplifier [ audio settings done by amplifier]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM7     ((tU8)0x07)  //BAP amplifier [ audio settings done by amplifier]
#define SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM8     ((tU8)0x08)  //BOSE amplifier [special sound and level, audio settings done by amplifier]

// Values for SOUND_ITEM_TYPE_VEHICLE
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE1         ((tU8)0x01)  // e.g. VW Polo
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE2         ((tU8)0x02)  // e.g. VW Golf
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE3         ((tU8)0x03)  // e.g. VW Golf Plus
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE4         ((tU8)0x04)  // e.g. VW Golf Variant
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE5         ((tU8)0x05)  // e.g. VW Passat
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE6         ((tU8)0x06)  // e.g. VW Passat Variant
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE7         ((tU8)0x07)  // e.g. Audi A3
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE8         ((tU8)0x08)  // e.g. Audi A4
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE9         ((tU8)0x09)  // e.g. Audi A6
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE10        ((tU8)0x0A)  // e.g. Audi A8
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE11        ((tU8)0x0B)  // e.g. Audi Q5
#define SOUND_CONFIG_ITEM_VALUE_VEHICLE12        ((tU8)0x0C)  // e.g. Audi Q7

// Value general used as undefined
#define SOUND_CONFIG_ITEM_VALUE_UNDEF            ((tU8)0xFF)
#define ARS_AUD_APP_SOUNDITEM_VEHICLE_1         1
#define ARS_AUD_APP_SOUNDITEM_VEHICLE_2         2

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#define INTERNALAMP_2SPEAKER 0
#define PREMIUM_AMP1 1
#define EXTERNALAMP_BOSEWOMCAN 2
#define PREMIUM_AMP2 3
#define EXTERNALAMP_BOSE2CH_MCAN 4
#define EXTERNAL_ANC 5
#define EXTERNALAMP_BOSE_5_1CH_MCAN 6
#define EXTERNAL_DAIMLER_1 7
#define HEAD_UNIT_ALONE 8
#define INTERNALAMP_4SPEAKER 9
#define EXTERNAL_DAIMLER_2 0x0A
#define BOSE_PERSONAL_SPACE 0x0B
#define EXTERNAL_ANC_FRONT_ONLY 0x0C
#endif

class vd_adr3Msg_If:public fc_audiomanager_tclTraceInput
{

public:
  vd_adr3Msg_If();
  virtual ~vd_adr3Msg_If();

  vd_adr3_If *m_vd_adr3_If;

  static void vInit(void);
  static void vDeInit(void);
  static void vSendAdr3Msg(trMsgOut * poMsgOut);
  static void vSendMsg(tU8 u8InstId, tU16 u16FktId, tU8 enOpType, tU32 u16MsgLen, const tU8 *pu8MsgData, tU8 u8ThreadMessageType);
  // InBox for TTfis as well as for ADR messages
  virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
  static void vCheckForNewRequestedMessages(void);
  static void vDataCon(void);
  static void vReloadADRData(void);
  static void vResendVolume();

private:
  static vd_adr3Msg_If       * poADR3Msg;

};
#endif // VD_ADR3MSG_IF_H
