///////////////////////////////////////////////////////////
//  vd_adr3Message_Data.cpp
//  Implementation of the Class vd_adr3Message_Data
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////
#include "vd_adr3Message_Data.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#include "../../fc_audiomanager_main.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_IF
#include "trcGenProj/Header/vd_adr3Message_Data.cpp.trc.h"
#endif


/********************************************************************************
 * constructor
 *******************************************************************************/
vd_adr3Message_Data::vd_adr3Message_Data():
hSem(OSAL_C_INVALID_HANDLE)
,_pu8ValueData(OSAL_NULL)
,_u32ValueSize(0)
,_bTransferred(TRUE)
,_u32MessageID(0)
,_bCheckValueChangeAllowed(TRUE)
{
  ETG_TRACE_USR4(("vd_adr3Message_Data() constructor."));
  memset(pcu8SemName,0,cu32SemNameLen);
  sprintf(pcu8SemName,"vd_adr3Message_Data_%p",this);//create unique name


}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Message_Data::~vd_adr3Message_Data()
{
  bSetValue(OSAL_NULL,0);
  deleteSemaphore();
}

/********************************************************************************
 * bCheckValueChange()
 *******************************************************************************/
tBool vd_adr3Message_Data::bCheckValueChange(tU8* data, tU32 len)const
{
  tBool bRet = FALSE;
   AUD_POINTER_CHECK_CALL (_pu8ValueData);

  // comparison allowed?
  if(_bCheckValueChangeAllowed == FALSE)
  {
    ETG_TRACE_USR4(("bCheckValueChange() no comparison with last value allowed "));
  }
  //check for no change
  else if( (_u32ValueSize == len) && (len > 0) && (0==memcmp(_pu8ValueData,data,len)))
  {
    ETG_TRACE_USR4(("bCheckValueChange(): value not changed"));
    bRet = TRUE;
  }
  else
     ETG_TRACE_USR4(("bCheckValueChange(): value changed"));

  return bRet;
}

/********************************************************************************
 * vSetCheckValueChange()
 *******************************************************************************/
void vd_adr3Message_Data::vSetCheckValueChange(tBool bEnable)
{
  _bCheckValueChangeAllowed = bEnable;
}

/********************************************************************************
 * bSetValue()
 *******************************************************************************/
tBool vd_adr3Message_Data::bSetValue(tU8* data, tU32 len)
{
  //protect data access until end of function ( = life time of 'protect')
  semaphore_protection protect(getSemaphore());
  tBool bRet = FALSE;

  ETG_TRACE_USR4(("bSetValue() _u32ValueSize = %u, len = %u", (tU8) _u32ValueSize, (tU8) len));

  //clear old value
  if(_pu8ValueData != OSAL_NULL) delete[] _pu8ValueData;
  _pu8ValueData    = OSAL_NULL;
  _u32ValueSize = 0;

  //_u32MessageID == 0 only allowed as initial value
  if(_u32MessageID == 0xFFFFFFFF){_u32MessageID = 0;}

  //allocate memory
  if( (data != OSAL_NULL) && (len > 0) )
  {
    _pu8ValueData = new tU8[len];
  }

  //write data
  if( (_pu8ValueData != OSAL_NULL && data != OSAL_NULL) && (len > 0) )
  {
    (void)OSAL_pvMemoryCopy(_pu8ValueData,data,len);
    _u32ValueSize = len;
    _u32MessageID++;
    _bTransferred = FALSE;
    bRet = TRUE;
  }


  if(bRet == FALSE)
  {
    //NORMAL_M_ASSERT_ALWAYS();
    ETG_TRACE_USR4(("bSetValue():  bRet == FALSE"));
  }

  return bRet;
}

/********************************************************************************
 * u32ReadValue()
 *******************************************************************************/
tU32 vd_adr3Message_Data::u32ReadValue(tU8* dest, tU32 destLenMax, tU32& r_u32MessageID)
{
  tU32 u32Ret;
  ETG_TRACE_USR4(("u32ReadValue() entered"));
  semaphore_protection protect(getSemaphore());

  if(!_bTransferred)
  {
    u32Ret = 0;
    if(dest && destLenMax && _pu8ValueData && _u32ValueSize && (destLenMax>=_u32ValueSize ) )
    {
      (void)OSAL_pvMemoryCopy(dest,_pu8ValueData,_u32ValueSize);
      u32Ret = _u32ValueSize;
      r_u32MessageID = _u32MessageID;
    }
  }
  else
  {
    u32Ret = 0;
    r_u32MessageID = 0;

  }
  return u32Ret;
}

/********************************************************************************
 * vConfirmTransfer()
 *******************************************************************************/
void vd_adr3Message_Data::vConfirmTransfer(tU32 u32MessageID)
{
  semaphore_protection protect(getSemaphore());
  if(u32MessageID == _u32MessageID)
  {
    _bTransferred = TRUE;
    ETG_TRACE_USR4(("vConfirmTransfer() u32MessageID = %u matches, _bTransferred = TRUE"
          ,(tU8) u32MessageID))
  }
  else
    ETG_TRACE_USR3(("vConfirmTransfer() u32MessageID = %u NOT MATCHING _u32MessageID = %u, _bTransferred = %u (unchanged)"
          ,(tU8) u32MessageID, (tU8)_u32MessageID,(tU8) _bTransferred))
}

/********************************************************************************
 * vResetTransferredFlag()
 *******************************************************************************/
void vd_adr3Message_Data::vResetTransferredFlag()
{
  semaphore_protection protect(getSemaphore());

  //initialize certain messages after reset or low power
  if( (_pu8ValueData != OSAL_NULL) && (_u32ValueSize > 0) )
  {
    ETG_TRACE_USR4(("vResetTransferredFlag() data available -> set transferred to FALSE"));
    _bTransferred = FALSE;
  }
}


/********************************************************************************
 * bIsTransferred()
 *******************************************************************************/
tBool vd_adr3Message_Data::bIsTransferred()const
{
  return _bTransferred;
}



/********************************************************************************
 * getSemaphore()
 *******************************************************************************/
//return semaphore handle for data protection
OSAL_tSemHandle vd_adr3Message_Data::getSemaphore()
{
  //handle is invalid only the first time
  if(hSem == (OSAL_tSemHandle)OSAL_C_INVALID_HANDLE)
  {
    tS32 s32RetVal = OSAL_s32SemaphoreCreate(pcu8SemName,&hSem,1);
    if(s32RetVal == OSAL_ERROR)
    {//create fails, may be it already exists
      s32RetVal = OSAL_s32SemaphoreOpen(pcu8SemName, &hSem);
    }
    ETG_TRACE_USR1(("getSemaphore() created semaphore with handle %u for name %s", hSem, pcu8SemName))

    NORMAL_M_ASSERT(s32RetVal == OSAL_OK); //semaphore not created
  }

  if(hSem == (OSAL_tSemHandle)OSAL_C_INVALID_HANDLE)
    ETG_TRACE_FATAL(("getSemaphore() returning invalid handle for name %s", pcu8SemName))

  return hSem;
}

/********************************************************************************
 * deleteSemaphore()
 *******************************************************************************/
void vd_adr3Message_Data::deleteSemaphore()
{
  ETG_TRACE_USR1(("deleteSemaphore() entered for name %s", pcu8SemName))

  OSAL_s32SemaphoreClose(getSemaphore());

  //try to create semaphore, initial value is 1
  (void) OSAL_s32SemaphoreDelete(pcu8SemName);
  hSem = OSAL_C_INVALID_HANDLE;
}





















