#if 0
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "aud_sinkmgr_trace.h"
#//include "aud_sinkmgr_trace_input.h"
#include "../fc_audiomanager_trace_input.h"
//#include "aud_sinkmgr_trace_macros.h"
#include "../fc_audiomanager_trace_macros.h"
#include "vd_adr3Msg_If.h" //#define AUD_GET_U16(...

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_TRACE
#include "trcGenProj/Header/aud_sinkmgr_trace.cpp.trc.h"
#endif

// -- trace identifier ------- define this value for every class new

// -- trace identifier ------- define this value for every file new

// -- trace identifier ------- end

//OSAL_tIODescriptor aud_sinkmgr_tclTraceChannel::_fdTrace = OSAL_ERROR;
//aud_sinkmgr_tclTraceInput* aud_sinkmgr_tclTraceChannel::_paReceiver[TRC::TRC_MAX_CLASS_NAMES];

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTrace
 * FUNCTION    : constructor
 * CREATED     : 2007-09-10
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : initialization to no action
 * SYNTAX      :
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       : -
 *******************************************************FunctionHeaderEnd******/
aud_sinkmgr_tclTraceChannel::aud_sinkmgr_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("aud_sinkmgr_tclTraceChannel entered."));

#if 0
   _eChannel = NO_CHAN_SELECTED;
   // check if channel was opened already by another instance
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();
   }
   _fdTrace = OSAL_ERROR;
   for (tInt i = 0; i < (tInt)TRC::TRC_MAX_CLASS_NAMES; i++)
   {
      _paReceiver[i] =0;
   }
#endif
}

aud_sinkmgr_tclTraceChannel::~aud_sinkmgr_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("~aud_sinkmgr_tclTraceChannel entered."));
#if 0
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();//lint !e1551 prio3 reviewed: the macro TRACE_FLOW_DEF in this function cannot throw an exception
   }
   _fdTrace = OSAL_ERROR;
#endif
}
/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vTrace_Rx
 * CREATED     : 2007-09-10
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : handles received messages from TTFIS
 * SYNTAX      : tVoid vdclk_Trace_vRx( tU8* pu8Data )
 * ARGUMENTS   : -
 *               pu8Data
 * RETURN VALUE: -
 *               none
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
//tVoid  aud_sinkmgr_tclTraceChannel::vTrace_Rx (tPCUChar pcu8Data)
tVoid aud_sinkmgr_tclTraceChannel::vTraceRx(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("vTrace_Rx entered."));
  // pu8Data[0] == length of TTFis message
  // pu8Data[1] == trace class
  // pu8Data[2] == command SetAdrData
  // pu8Data[3] == the 1. parameter
  // pu8Data[4] == the 2. parameter
  ETG_TRACE_USR4(("vTrace_Rx()\n length of TTFis message=%u,\n pcu8Data=0x%02x",pcu8Data[0],ETG_LIST_LEN(pcu8Data[0]), ETG_LIST_PTR_T8(pcu8Data)));

  ETG_TRACE_USR4(("_paReceiver[(pcu8Data[1]-TR_CLASS_AUD_SINKMGR_OFFSET)] = 0x%x", _paReceiver[(pcu8Data[1]-TR_CLASS_AUD_SINKMGR_OFFSET)]));

   if(pcu8Data == NULL) return;


   if ( pcu8Data[0] > 2 )
   {
      // the router forwards the message to that call backs as defined by tclApp
     //if(_paReceiver[(pcu8Data[1]-TR_CLASS_AUD_SINKMGR_OFFSET)])
        if(_paReceiver[(pcu8Data[1])])
      {
        //_paReceiver[(pcu8Data[1]-TR_CLASS_AUD_SINKMGR_OFFSET)]->vTraceRx(&pcu8Data[0]);
         _paReceiver[(pcu8Data[1])]->vTraceRx(&pcu8Data[0]);
      } else
      {
       ETG_TRACE_USR4(("vRegisterTraceService Trace Channel this service is not initialized."));
         //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel this service is not initialized", pcu8Data[1]);
      }
   } else
   {
      ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service number unknown."));
      //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel service number unknown", pcu8Data[1]);
   }
   return;
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vRegisterTraceService
 * CREATED     : 2008-03-15
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : adds the given trace input interface into the function array
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
//tVoid aud_sinkmgr_tclTraceChannel::vRegisterTraceService(tU32 uInputNum, aud_sinkmgr_tclTraceInput* pclInput) const
tVoid aud_sinkmgr_tclTraceChannel::vRegisterTraceService(tU32 uInputNum, fc_audiomanager_tclTraceInput* pclInput) const
{
   ETG_TRACE_USR4(("vRegisterTraceService entered."));
   if(uInputNum < sizeof(_paReceiver)/sizeof(_paReceiver[0]))
   {
      _paReceiver[uInputNum] = pclInput;
    ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service registered for :%u",uInputNum));
   }
}


/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vRegisterTraceCallBack
 * CREATED     : 2008-03-15
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : register the call back function at the OSAL trace interface
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid aud_sinkmgr_tclTraceChannel::vRegisterTraceCallBack(TR_tenTraceChan eChan)
{
   ETG_TRACE_USR4(("vRegisterTraceCallBack entered."));
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;
   _eChannel = eChan;
   oTraceChannel.enTraceChannel = _eChannel;
   oTraceChannel.pCallback = (
       OSAL_tpfCallback)vTrace_Rx;
   _fdTrace = OSAL_IOOpen( OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE );

   if(_fdTrace != OSAL_ERROR) {
      s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (tS32)&oTraceChannel );
   }
   if( OSAL_OK != s32Error )
   {
      ETG_TRACE_ERR(("vRegisterTraceCallBack ErrCouldntRegisterTraceChannel."));
   }
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vUnregisterTraceCallBack
 * CREATED     : 2008-03-15
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : unregister the call back at trace interface
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid aud_sinkmgr_tclTraceChannel::vUnregisterTraceCallBack(tVoid) const
{
   ETG_TRACE_USR4(("vUnregisterTraceCallBack entered."));
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;

   oTraceChannel.enTraceChannel = _eChannel;
   oTraceChannel.pCallback = (OSAL_tpfCallback)vTrace_Rx;

   if(_fdTrace != OSAL_ERROR)
   {
      s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (tS32)&oTraceChannel );
   }
   if( OSAL_OK != s32Error )
   {
      ETG_TRACE_ERR(("vUnregisterTraceCallBack ErrCouldntUnregisterTraceChannel."));
   }
   OSAL_s32IOClose( _fdTrace );
}
#endif
