/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_timer.h
 *
 * AUTHOR:      Klotz
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _AUD_SINKMGR_TIMER_H_
#define _AUD_SINKMGR_TIMER_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
/*#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "aud_sinkmgr_pwramp.h"
#include "../fc_audiomanager_trace_input.h"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"
#include "../mute/stream/StreamMute_IF.h"*/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/
enum
{
  AUD_SINKMANAGER_TIMER_ID_DEMUTE,
  AUD_SINKMANAGER_TIMER_ID_BOOSTER_OFF,
  AUD_SINKMANAGER_TIMER_ID_ADR3_STANDBY,
  AUD_SINKMANAGER_TIMER_ID_WAIT_TO_SWITCH_ON_EXT_BOOSTER
};


#define AUD_SINKMANAGER_TIMER_DEMUTE_NO_EXT_BOOSTER_INTERVAL         100
#define AUD_SINKMANAGER_TIMER_DEMUTE_WITH_BOSE_BOOSTER_INTERVAL      2400
#define AUD_SINKMANAGER_TIMER_DEMUTE_WITH_ANC_BOOSTER_INTERVAL       1420
#define AUD_SINKMANAGER_TIMER_BOOSTER_OFF_INTERVAL                    10
#define AUD_SINKMANAGER_TIMER_ADR3_STANDBY_INTERVAL                  500
#define AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_NO_EXT_BOOSTER        600
#define AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_WITH_EXT_BOOSTER      100
#define AUD_SINKMANAGER_TIMER_FROM_ON_IP_TO_ON_WITH_EXT_BOOSTER_LOWVOLTAGE_RECOVERY      5000
#define AUD_SINKMANAGER_TIMER_WORKING_AUTHORIZE_ON_INTERVAL        200

/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/

class aud_sinkmgr_timer
{
public:

  static aud_sinkmgr_timer*   m_poAud_sinkmgr_timer;


  aud_sinkmgr_timer();
  virtual ~aud_sinkmgr_timer(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  static tVoid vInit(tVoid);
  static tVoid vStartTimer(tU16 uwTimerID, tU16 uwTime);
  static tVoid vStopTimer(tU16 uwTimerID);

  static tVoid vDemuteTimerCallback(tVoid* pArg);
  static tVoid vBoosterOffTimerCallback(tVoid* pArg);
  static tVoid vADR3StandbyTimerCallback(tVoid* pArg);
  static tVoid vWaitToSwitchOnExtBoosterTimerCallback(tVoid* pArg);
  static tBool bGetBoosterOnTimerRunning(tVoid);
  static tBool bGetDemuteTimerRunning(tVoid);


private:


};

#endif //_AUD_SINKMGR_TIMER_H_

