/*******************************************************************************
 *
 * FILE:          aud_sinkmgr_main.cpp
 *
 * SW-COMPONENT:  aud_sinkmgr application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

//Include public FI interface of this service.
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#include <midw_fi_if.h>

#include "../fc_audiomanager_trace_input.h"
#include "aud_sinkmgr_main.h"
#include "aud_sinkmgr_timer.h"
#include "aud_extampconn_timer.h"
#include "../mute/stream/StreamMute.h"
//#include "../mute/stream/StreamMute_IF.h"

#include "../fc_audiomanager_trace.h"
#include "../fc_audiomanager_service_Audio_Function.h"
#include "../fc_audiomanager_trace_macros.h"
#include "vd_adr3/vd_adr3Msg_If.h"
#include "vd_adr3/vd_adr3_main.h"
#include "vd_adr3/vd_adr3_Config_Types.h"
#include "vd_adr3/vd_adr3_Config.h"

#include "aud_sinkmgr_pwramp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_sinkmgr_main.cpp.trc.h"
#endif

#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagTurnONStatus.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#include "vd_amp_Msg/MCANBose/vd_amp_MCANBose_MasterAmplifier_Defines.h"
//#include "vd_amp_if/vd_amp_If.h"

class  vd_adr3_config;


/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/
// Static self reference to be used in function callbacks.
fc_audiomanager_tclService_Audio_Function* aud_sinkmgr_main::m_AudioService = NULL;
vd_adr3_main*           aud_sinkmgr_main::m_poVDAdr3Main              = NULL;
aud_sinkmgr_main*       aud_sinkmgr_main::m_poSinkMainInstance         = NULL;
plugin_loader *  aud_sinkmgr_main::m_po_pluginloader = NULL;
vd_amp_if_tx_rx * aud_sinkmgr_main::m_po_pluginreceiver = NULL;
tU8 aud_sinkmgr_main::m_BoseAmplifierConnectionStatus = AMP_NOT_CONNECTED;

tenApplicationStates ubApplicationState;

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: fc_audioroutemgr_tclApp::fc_audioroutemgr_tclApp()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
aud_sinkmgr_main::aud_sinkmgr_main(fc_audiomanager_tclApp* poMainAppl,fc_audiomanager_tclService_Audio_Function* poAudService)
   : IF_MessageObserver<PO_MessageConfig::enID>("aud_sinkmgr_main")
   , m_poSinkMgrPwramp(NULL)
{
  ETG_TRACE_USR4(("aud_sinkmgr_main() entered."));
  if (NULL == m_poSinkMainInstance)
     m_poSinkMainInstance = this;
  else
     ETG_TRACE_ERR(("aud_sinkmgr_main() Warning - Creating secondary instance."))

  m_AudioService = poAudService;
  m_BoseAmplifierConnectionStatus = AMP_NOT_CONNECTED;

  m_poStreamMute = StreamMute::getInstance();
    m_poSinkMgrPwramp = aud_sinkmgr_pwramp::pCreateInstance(poMainAppl, m_poStreamMute);

  m_poSinkMgrTimer = new aud_sinkmgr_timer();

  m_poExtAmpConnTimer = new aud_extampconn_timer();

  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();

}
plugin_loader* aud_sinkmgr_main::GetPluginLoaderInstance()
{
  ETG_TRACE_USR4(("aud_sinkmgr_main::GetPluginLoaderInstance called"));
  if (m_po_pluginloader != NULL)
    return m_po_pluginloader;
  ETG_TRACE_USR4(("Amplifier Plugin is not Loaded"));
  return NULL;
}
/*******************************************************************************
 *
 * FUNCTION: aud_sinkmgr_main::~aud_sinkmgr_main()
 *
 * DESCRIPTION: Destructor.
 *
 *              Invalidate static self reference.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
aud_sinkmgr_main::~aud_sinkmgr_main()
{
  ETG_TRACE_USR4(("~aud_sinkmgr_main() entered."));
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  aud_sinkmgr_main::m_poStreamMute      = NULL;

  if (this == m_poSinkMainInstance)
     m_poSinkMainInstance = NULL;

  if (m_poSinkMgrPwramp != NULL)
  {
    OSAL_DELETE m_poSinkMgrPwramp;
    m_poSinkMgrPwramp = NULL;
  }

    if (m_poSinkMgrTimer != NULL)
  {
    OSAL_DELETE m_poSinkMgrTimer;
    m_poSinkMgrTimer = NULL;
  }

  if (m_poExtAmpConnTimer != NULL)
  {
    OSAL_DELETE m_poExtAmpConnTimer;
    m_poExtAmpConnTimer = NULL;
  }

  pPO = NULL;

}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid aud_sinkmgr_main::vInit()const
{
  ETG_TRACE_USR4(("aud_sinkmgr vInit() entered."));

#ifndef VARIANT_S_FTR_DISABLE_ADR3
  m_poVDAdr3Main = OSAL_NEW vd_adr3_main();
  if (NULL == m_poVDAdr3Main)
  {
    FATAL_M_ASSERT_ALWAYS();
  }

  m_poVDAdr3Main->vInit();
#else
  ETG_TRACE_FATAL(("aud_sinkmgr_main::vInit(): communication with ADR3 disabled on LSIM!"));
#endif


  ETG_TRACE_USR4(("vd_amp_if loading the plugin"));
  m_po_pluginloader = OSAL_NEW plugin_loader();
  m_po_pluginreceiver = OSAL_NEW vd_amp_if_tx_rx(m_po_pluginloader, m_poVDAdr3Main);

    ETG_TRACE_USR4(("Loaded the plugins."));

  if (m_poSinkMgrPwramp)
     m_poSinkMgrPwramp->vInit();

  aud_sinkmgr_timer::vInit();
  aud_extampconn_timer::vInit();

}
/********************************************************************************
 * vLoadPlugins().
 *******************************************************************************/
tBool aud_sinkmgr_main::bLoadPlugins()
{
  ETG_TRACE_USR4(("Entered enLoadAllPlugins"));
  if(m_po_pluginloader != NULL)
  {
    if (plugin_loader::enDefault == m_po_pluginloader->enLoadAllPlugins())
       // initialize for on-board amplifier
       vd_adr3_config::vSetConfigItem(SOUND_CONFIG_ITEM_VALUE_UNDEF, SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1);

      m_po_pluginloader->bInitializePlugins(m_po_pluginreceiver);
    AUD_POINTER_CHECK_CALL(pPO);
    AUD_POINTER_CHECK_CALL(m_poExtAmpConnTimer);
    if (m_poExtAmpConnTimer->bIsupdateRcvdfrmAmplifier() == false)
      m_poExtAmpConnTimer->vChecknSendExtAmpDiagTurnStatus();
    return TRUE;
  }
  return FALSE;
}

/********************************************************************************
 * vOnApplicationClose().
 *******************************************************************************/
tVoid aud_sinkmgr_main::vOnApplicationClose()
{

  ETG_TRACE_USR4(("vOnApplicationClose() entered."));
  vd_adr3_main::vDeInit();
  if (m_poSinkMainInstance && m_poSinkMainInstance->m_poSinkMgrPwramp)
     m_poSinkMainInstance->m_poSinkMgrPwramp->vOnApplicationClose();

// Unloading plugins
  m_po_pluginloader->vUnLoadAllPlugins();
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void aud_sinkmgr_main::vAddObserver()
{

  ETG_TRACE_USR4(("aud_sinkmgr_main::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("aud_sinkmgr_main::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ApplicationStatus);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void aud_sinkmgr_main::MessageNotification(PO_MessageConfig::enID MsgId)
{

  ETG_TRACE_USR4(("aud_sinkmgr_main::MessageNotification entered. "));
  // Obtaining the Mute Message from PostOffice handler by mute
  switch(MsgId)
  {
  case PO_MessageConfig::ID_ApplicationStatus:
    {
      const ID_ApplicationStatus*     pMsg = pPO->POMessages->QueryMessage<ID_ApplicationStatus>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("Application status: 0x%4x.", pMsg->value.m_State));

      ubApplicationState     = (pMsg->value.m_State);

      if (m_poSinkMgrPwramp)  // RN-AIVI and PSA-RCC only
      {
    //     m_poSinkMgrPwramp->vCheckAccStatus();
         m_poSinkMgrPwramp->vCheckPwrAmp();
      }
      break;
    }

      case PO_MessageConfig::ID_DiagDefSet:
      {
        const ID_DiagDefSet* pMsgDefSet = pPO->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
        ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgDefSet);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poExtAmpConnTimer);
        if((pMsgDefSet->enDiagDefSetType == EN_DEFSET_CODING) && (pMsgDefSet->enDiagDefSetPhase == EN_DEFSET_SET))
        {
          m_poExtAmpConnTimer->vInitExtAmpParams();
          bLoadPlugins();
        }
        break;
      }
    case PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus:
      {
        ETG_TRACE_USR4(("aud_sinkmgr_main::MessageNotification, ID_BOSE_Amplifier_ConnectionStatus"));

        const ID_BOSE_Amplifier_ConnectionStatus* pMsgDefSet = pPO->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
        ETG_TRACE_USR4(("ID_BOSE_Amplifier_ConnectionStatus, connectionstate = %d",pMsgDefSet->connectionstate));

        m_BoseAmplifierConnectionStatus = pMsgDefSet->connectionstate;
        this->vUpdateProperty();
        break;
      }
    default :
      break;
  }
}


/********************************************************************************
 * vTraceRx(tPCUChar pcu8Data)
 *******************************************************************************/
tVoid aud_sinkmgr_main::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  tU8 u8InstId;
  tU16 u16FktId;
  tU8 u8OpType;
  tU32 u16MsgLen;
  tU8 *pu8MsgData;
  tU8 u8ThreadMessageType;

  //tU8 u8GpioFlag;


  ETG_TRACE_USR4(("vTraceRx() entered: size=%i, pcu8Data=%x.", size, ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));

  if(pcu8Data == NULL) return;
  // pu8Data[0] == tenTrcTrcClassName
  // pu8Data[1] == tenTrcFuncInput  SetAdrData
  // pu8Data[2] == the 1. parameter
  // pu8Data[3] == the 2. parameter
  // rest is defined here

  if (size > 2)
  {
    switch ( pcu8Data[1] ) // tenTrcFuncInput
    {
    case TRC::SendAdrData:
      ETG_TRACE_USR4(("Received SetAdrData"));

      u8InstId  = pcu8Data[2];
      u16FktId   = AUD_GET_U16(&pcu8Data[3]);
      u8OpType   = pcu8Data[5];
      u16MsgLen   = size - 6;
      pu8MsgData  = const_cast<tU8*>(&pcu8Data[6]);
      u8ThreadMessageType = TTFIS_INPUT_MESSAGE;
      ETG_TRACE_USR4(("vTraceRx() u8InstId = 0x%x",(tU16)u8InstId));
      ETG_TRACE_USR4(("vTraceRx() u16FktId = 0x%x",(tU16)u16FktId));
      ETG_TRACE_USR4(("vTraceRx() u8OpType = 0x%x",(tU16)u8OpType));
      ETG_TRACE_USR4(("vTraceRx() u16MsgLen= 0x%x",(tU16)u16MsgLen));
      ETG_TRACE_USR4(("pu8MsgData=0x%02x",ETG_LIST_LEN(u16MsgLen), ETG_LIST_PTR_T8(pu8MsgData)));
      ETG_TRACE_USR4(("vTraceRx() u8ThreadMessageType= 0x%x",(tU16)u8ThreadMessageType));

      vd_adr3Msg_If::vSendMsg(u8InstId, u16FktId, u8OpType, u16MsgLen, pu8MsgData, u8ThreadMessageType);

      break;

    /*case TRC::SendGpioData:
      ETG_TRACE_USR4(("Received SendGpioData"));
      u8GpioFlag  = pcu8Data[2];
      ETG_TRACE_USR4(("vTraceRx() u8GpioFlag = 0x%x",(tU16)u8GpioFlag));
      aud_sinkmgr_Gpio_If::vSetPwrExternalAmplifier( static_cast<tBool>(u8GpioFlag));
      break;*/

    case TRC::PrintSoundConfigFile:
    {
      ETG_TRACE_USR4(("PrintSoundConfigFile for file %d", ETG_ENUM(ADR_ConfigFile, pcu8Data[2])))

      vd_adr3_config::vPrintSoundConfigFile (pcu8Data[2], NULL);
      break;
    }

    default:
      ETG_TRACE_USR4(("default"));
      break;
    }
  }
}

/********************************************************************************
 * poGetPowerAmp( )
 *******************************************************************************/
/* static */ aud_sinkmgr_pwramp* aud_sinkmgr_main::poGetPowerAmp()
{
   if (m_poSinkMainInstance)
      return m_poSinkMainInstance->m_poSinkMgrPwramp;
   else
      return NULL;
}

/********************************************************************************
 * ubGetApplicationState( )
 *******************************************************************************/
tenApplicationStates aud_sinkmgr_main::ubGetApplicationState(tVoid)
{
  ETG_TRACE_USR4(("ubGetApplicationState ubApplicationState = %u", ubApplicationState));
  return ubApplicationState;
}

/********************************************************************************
 * vUpdateProperty( )
 *******************************************************************************/
void aud_sinkmgr_main::vUpdateProperty()
{
  if(m_AudioService->updateClients(MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS) != AIL_EN_N_NO_ERROR){
    ETG_TRACE_ERR(("ERROR: eUpdateClients():-> Updating the clients for AudioDeviceStatus failed"));
  }
  else {
    ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients for AudioDeviceStatus OK"));
  }
}

/*******************************************************************************
 * FUNCTION: PropertyStatus::bSendAdr3Status(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)
 *******************************************************************************/
tBool aud_sinkmgr_main::bSendAdr3Status(amt_tclServiceData& roOutMsg, amt_tclServiceData* /*poInMsg*/)
{

  midw_mascffi_tclMsgAudioDeviceStatusStatus oAdrDeviceStatus;
  tBool bRetVal = false;

#ifndef VARIANT_S_FTR_DISABLE_ADR3

  if((m_AudioService != NULL) && ((m_AudioService->bIsBoseAmpConnected()) || (m_AudioService->IsPremium2Connected())))
  {
    ETG_TRACE_USR4(("bSendAdr3Status() : External Amplifier is Configured."));
    if((vd_adr3_If::bGetAdr3StateRunning()== TRUE) && (m_BoseAmplifierConnectionStatus == AMP_CONNECTED))
    {
      oAdrDeviceStatus.AudioDeviceAvailability.enType = (midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_AVAILABLE);
    }
    else
    {
      oAdrDeviceStatus.AudioDeviceAvailability.enType = (midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_NOTAVAILABLE);
    }
  }
  else
  {
    ETG_TRACE_USR4(("bSendAdr3Status() : Bose Amplifier is not Configured."));
    if(vd_adr3_If::bGetAdr3StateRunning()== TRUE)
    {
      oAdrDeviceStatus.AudioDeviceAvailability.enType = (midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_AVAILABLE);
    }
    else
    {
      oAdrDeviceStatus.AudioDeviceAvailability.enType = (midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_NOTAVAILABLE);
    }
  }
#else
  /* in case of LSIM let's assume, that we always have an audio device -> alsa */
  oAdrDeviceStatus.AudioDeviceAvailability.enType = (midw_fi_tcl_e8_AudioDevice_Availability::FI_EN_AUDIODEVICE_AVAILABLE);
#endif

  ETG_TRACE_USR4(("bSendAdr3Status()  oAdrDeviceStatus.AudioDeviceAvailability.enType = %u", oAdrDeviceStatus.AudioDeviceAvailability.enType));

  fi_tclVisitorMessage oCCaMsg(oAdrDeviceStatus);

  oAdrDeviceStatus.vDestroy();
  bRetVal = oCCaMsg.bHandOver(&roOutMsg);
  return bRetVal;
}

