///////////////////////////////////////////////////////////
//  aud_sinkmgr_Gpio_If.cpp
//  Implementation of the Class aud_sinkmgr_Gpio_If
//  Created on:      08-Feb-2013 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links generic osal_if.h

#include "aud_sinkmgr_Gpio_If.h"
#include "vd_adr3_thread.h"
#include "fc_audiomanager_main.h"
#include "aud_sinkmgr_main.h"

#include "../fc_audiomanager_trace.h"
#include "../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_sinkmgr_Gpio_If.cpp.trc.h"
#endif

#include "../util/Macro.h"
#include "aud_sinkmgr_pwramp.h"

/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/

// singleton instance
aud_sinkmgr_Gpio_If*   aud_sinkmgr_Gpio_If::m_poaud_sinkmgr_Gpio_If   = NULL;

tU32 ulPinExtAmp = 1069;

/******************************************************************************/
/* constructor                                                                */
/******************************************************************************/
aud_sinkmgr_Gpio_If::aud_sinkmgr_Gpio_If(aud_sinkmgr_pwramp* poSinkMgrPwramp)
   : m_poSinkMgrPwramp(poSinkMgrPwramp)
{
  ETG_TRACE_USR1(("aud_sinkmgr_Gpio_If constructor"));

  m_poaud_sinkmgr_Gpio_If = this;
}
/******************************************************************************/
/* destructor                                                                 */
/******************************************************************************/
aud_sinkmgr_Gpio_If::~aud_sinkmgr_Gpio_If()
{
  ETG_TRACE_USR2(("aud_sinkmgr_Gpio_If destructor"));
  m_poSinkMgrPwramp = NULL;
}

/******************************************************************************/
/*  vStart                                                                    */
/******************************************************************************/
tVoid aud_sinkmgr_Gpio_If::vStart(aud_sinkmgr_pwramp* poSinkMgrPwramp)
{
  ETG_TRACE_USR2(("aud_sinkmgr_Gpio_If::vStart()"));

  if (OSAL_NULL == m_poaud_sinkmgr_Gpio_If)
  {
    m_poaud_sinkmgr_Gpio_If = new aud_sinkmgr_Gpio_If(poSinkMgrPwramp);
    if (OSAL_NULL == m_poaud_sinkmgr_Gpio_If)
    {
      ETG_TRACE_ERR(("Failed to create m_ahGPIOAm_poaud_sinkmgr_Gpio_IfmpDevice."));
      FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
      ETG_TRACE_USR4((" m_poaud_sinkmgr_Gpio_If object address: 0x%x", m_poaud_sinkmgr_Gpio_If));
    }
  }
}

/******************************************************************************/
//  bSetTelModeGPIO(tBool bState)
/******************************************************************************/
tBool aud_sinkmgr_Gpio_If::bSetTelModeGPIO(tBool bState)
{
  tS32 _s32OutPutErrorCode =  0;

  ETG_TRACE_USR2(("vSetTelModeGPIO() bState = %u ",bState));

  tBool blRet=FALSE;
  OSAL_tIODescriptor hDev;
  hDev = OSAL_IOOpen(OSAL_C_STRING_DEVICE_GPIO, OSAL_EN_READWRITE);
  if (hDev ==OSAL_ERROR)
  {
    ETG_TRACE_USR2(("***********Could not open GPIO*********** hDev=%d",hDev));
    OSAL_s32IOClose(hDev);
    return blRet;
  }

  OSAL_tGPIODevID devID;
  devID  = (OSAL_tGPIODevID)OSAL_EN_TEL_MODE_AMP;
  //aud_bExtAmpStatus = bState;

  if(bState)
  {
    OSAL_trGPIOData Data = {devID, TRUE};
    ETG_TRACE_USR2(("***********Set TELModeGPIO to GND *********** "));
    _s32OutPutErrorCode=OSAL_s32IOControl(hDev, OSAL_C_32_IOCTRL_GPIO_SET_ACTIVE_STATE, (intptr_t) &Data);
  }

  else
  {
      OSAL_trGPIOData Data = {devID, FALSE};
      ETG_TRACE_USR2(("***********Set TELModeGPIO to OPEN *********** "));
     _s32OutPutErrorCode=OSAL_s32IOControl(hDev, OSAL_C_32_IOCTRL_GPIO_SET_INACTIVE_STATE , (intptr_t) &Data);
  }

  if(OSAL_OK  ==_s32OutPutErrorCode)
  {
    ETG_TRACE_USR2(("GPIO pin opened/closed "));
    blRet=TRUE;
  }

  else if( OSAL_ERROR == _s32OutPutErrorCode)
  {
    ETG_TRACE_USR2(("***********ERRROR in setting as Output *********** "));
    blRet=FALSE;
  }
  OSAL_s32IOClose(hDev);
  return blRet;
}
