/*******************************************************************************
 *
 * FILE:          aud_extampconn_timer.cpp
 *
 * AUTHOR:      pmh7kor
 *
 * COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "aud_extampconn_timer.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC

#include "etrace_if.h"
#include "../fc_audiomanager_main.h"
#include "../fc_audiomanager_trace_macros.h"
#include "../vd_adr3/vd_adr3Msg_If.h"
#include "aud_sinkmgr_main.h"
#include "InternalComponentCommunication/Messages/SoundConfig/IDSetSoundSystemConfig.h"
#include "InternalComponentCommunication/Messages/Diag/ID_DiagActiveSink.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagRemoteControl.h"
#include "InternalComponentCommunication/Messages/Diag/IDDiagTurnONStatus.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUD_SINKMGR_APPLICATION
#include "trcGenProj/Header/aud_extampconn_timer.cpp.trc.h"
#endif
/******************************************************************************/
/* DEFINES                                                                    */
/******************************************************************************/


/******************************************************************************/
/* GLOBAL VARIABLES                                                           */
/******************************************************************************/
// Static self reference to be used in function callbacks.

tBool aud_extampconn_timer::m_bExtAmpTimerRunning = FALSE;

OSAL_tTimerHandle m_hExtAmpConnTimer;


enum
{
  POWER_UP = 0x00,
  NONPOWER_UP = 0x01
};
/******************************************************************************/
/* METHODS                                                                    */
/******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: aud_extampconn_timer::aud_extampconn_timer()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initializes data members
 *******************************************************************************/
aud_extampconn_timer::aud_extampconn_timer():IF_MessageObserver<PO_MessageConfig::enID>("aud_extampconn_timer")
{
  ETG_TRACE_USR4(("aud_extampconn_timer() entered."));
  m_hExtAmpConnTimer = OSAL_C_INVALID_HANDLE;
  m_u8soundConfig = 0x0;
  m_powerstate = POWER_UP;
  m_u8DiagRemoteControlPhase = 0x0;
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::IDSetSoundSystemConfig);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagRemoteControl);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagActiveSink);
}
/*******************************************************************************
 * FUNCTION: aud_extampconn_timer::vInitExtAmpParams()
 *
 * DESCRIPTION: Initializes Member variables.
 *******************************************************************************/

tVoid aud_extampconn_timer::vInitExtAmpParams()
{
  ETG_TRACE_USR4(("aud_extampconn_timer() ::vInitExtAmpParams() called."))
  m_hExtAmpConnTimer = OSAL_C_INVALID_HANDLE;
  m_u8soundConfig = 0x0;
  m_powerstate = POWER_UP;
  m_u8DiagRemoteControlPhase = 0x0;
  m_bExtAmpTimerRunning = FALSE;
}
/*******************************************************************************
 * FUNCTION: aud_extampconn_timer::~aud_extampconn_timer()
 *
 * DESCRIPTION: Destructor.
 *******************************************************************************/
aud_extampconn_timer::~aud_extampconn_timer()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  ETG_TRACE_USR4(("~aud_extampconn_timer() entered."));

  vStopTimer(AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK); // to stop timer on shut down if running and clear timer status
  if( m_hExtAmpConnTimer != OSAL_C_INVALID_HANDLE)
  {
    tS32 s32OsalError = OSAL_s32TimerDelete( m_hExtAmpConnTimer);

    NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

    m_hExtAmpConnTimer = OSAL_C_INVALID_HANDLE;
  }
  pPO = NULL;
}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid aud_extampconn_timer::vInit(tVoid)
{
  tS32 s32OsalError = OSAL_ERROR;
  ETG_TRACE_USR4(("aud_extampconn_timer::vInit() entered."));
    /* create ADR supervision timer */
  s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vExtAmpConnTimerCallback, 0, &m_hExtAmpConnTimer );

  if (s32OsalError == OSAL_OK)
    ETG_TRACE_USR4(("aud_extampconn_timer::vInit() Timer created successfully."));

}




/********************************************************************************
 * vStartTimer().
 *******************************************************************************/
tVoid aud_extampconn_timer::vStartTimer(tU16 uwTimerID, tU16 uwTimeMs)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" aud_extampconn_timer::vStartTimer uwTimerID = 0x%x, uwTimeMs = %u ", uwTimerID, uwTimeMs));
  if(uwTimerID == AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK)
    s32RetVal = OSAL_s32TimerSetTime( m_hExtAmpConnTimer, (tU32) uwTimeMs, 0 );

  if (s32RetVal == OSAL_OK)
  {
    ETG_TRACE_USR4((" aud_extampconn_timer::Timer started successfully,s32RetVal = 0x%x", s32RetVal));
    m_bExtAmpTimerRunning = TRUE;
  }
  else
    ETG_TRACE_ERR(("aud_extampconn_timer:: Error in Starting Timer"));
}
/********************************************************************************
 * vStopTimer().
 *******************************************************************************/
tVoid aud_extampconn_timer::vStopTimer(tU16 uwTimerID)
{
  tS32 s32RetVal = OSAL_ERROR;
  ETG_TRACE_USR4((" aud_extampconn_timer::vStopTimer uwTimerID = 0x%x ", uwTimerID));
  if (uwTimerID == AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK)
  {
    s32RetVal = OSAL_s32TimerSetTime(m_hExtAmpConnTimer, 0, 0);
    if(s32RetVal == OSAL_OK)
    {
      ETG_TRACE_USR4(("aud_extampconn_timer::Timer Stopped Successfully, s32RetVal = 0x%x", s32RetVal));
      m_bExtAmpTimerRunning = FALSE;
    }

  }
  else
    ETG_TRACE_ERR(("aud_extampconn_timer::Invalid Timer ID to Stop"));
}



/********************************************************************************
 * vExtAmpConnTimerCallback( )
 *******************************************************************************/
tVoid aud_extampconn_timer::vExtAmpConnTimerCallback(tVoid* pArg){
  (tVoid)pArg;    /* unused parameter */
  m_bExtAmpTimerRunning = FALSE;
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_EXTAMPLIFIER_CONNECTION);
}

/********************************************************************************
 * MessageNotification( )
 *******************************************************************************/
tVoid aud_extampconn_timer::MessageNotification(PO_MessageConfig::enID MsgId)
{

  ETG_TRACE_USR4(("aud_extampconn_timer::MessageNotification entered. "));
  switch(MsgId)
  {
  case PO_MessageConfig::IDSetSoundSystemConfig:
    {
      if(m_u8DiagRemoteControlPhase != EN_REMOTECONTROL_SET)
      {
        // Obtaining the sound system configuration received from External Amplifier
        const IDSetSoundSystemConfig* pMsg = pPO->POMessages->QueryMessage<IDSetSoundSystemConfig>(MsgId);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
        m_u8soundConfig = pMsg->u8SoundConfig;
        vChecknSendExtAmpDiagTurnStatus();
      }
      break;
    }
    case PO_MessageConfig::ID_DiagRemoteControl:
      {
        const ID_DiagRemoteControl* pMsgRemoteControl =  pPO->POMessages->QueryMessage<ID_DiagRemoteControl>(MsgId);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgRemoteControl);
        ETG_TRACE_USR4(("RemoteControl phase received = %x",pMsgRemoteControl->enDiagRemoteControlPhase));
        m_u8DiagRemoteControlPhase = pMsgRemoteControl->enDiagRemoteControlPhase;
         if (m_u8DiagRemoteControlPhase == EN_REMOTECONTROL_UNFREEZE)
         {
           IDSetSoundSystemConfig oSoundSys(m_u8soundConfig);
           InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundSys);
         }
        break;
      }
    case PO_MessageConfig::ID_DiagActiveSink:
      {
         const ID_DiagActiveSink* pMsgActiveSink =  pPO->POMessages->QueryMessage<ID_DiagActiveSink>(MsgId);
         AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsgActiveSink);
         ETG_TRACE_USR4(("ID_DiagActiveSink received with Active Sink = %x",pMsgActiveSink->enDiagActiveSinkPhase));
         if((m_u8DiagRemoteControlPhase == EN_REMOTECONTROL_SET) && (pMsgActiveSink->enDiagActiveSinkPhase == EN_ACTIVESINK_SET))
         {
             IDSetSoundSystemConfig oSoundSys(SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1);
          InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundSys);
         }
         break;
      }
    default:
      break;
}
}

/*******************************************************************************
*
* FUNCTION: aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus()
*
* DESCRIPTION: To check sound system configuration update and send the Diagnosis Turn ON status.
*
*
*******************************************************************************/

tVoid aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus()
{
  ETG_TRACE_USR4(("aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus() called"));
  switch (m_powerstate)
  {
  case POWER_UP:
    ETG_TRACE_USR4(("aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus(),POWERUP"));
    if (m_u8soundConfig != 0x0)
      vSendDiagTurnOnStatus();
    else
    {
      vStartTimer(AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK, AUD_SINKMANAGER_TIMER_EXTAMPCONNECTION_INTERVAL); //starting Timer since sound system configuration is not received
      m_powerstate = NONPOWER_UP;
    }
    break;
  case NONPOWER_UP:
    ETG_TRACE_USR4(("aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus(),NONPOWERUP"));
    if (m_u8soundConfig != 0x0)
    {
      if (m_bExtAmpTimerRunning == TRUE)
      {
        vStopTimer(AUD_SINKMANAGER_TIMER_ID_EXTAMPCONNECTION_CHECK); //Stopping Timer Since sound config update is received from External amplifier
        vSendDiagTurnOnStatus();
      }
      else
        ETG_TRACE_USR4(("aud_extampconn_timer::vChecknSendExtAmpDiagTurnStatus(),Timer Already Expired & DiagTurnON_YES is already sent to ADR "));
    }
    break;
  default:
    break;
  }

}

/*******************************************************************************
*
* FUNCTION: aud_extampconn_timer::bIsupdateRcvdfrmAmplifier()
*
* DESCRIPTION: Function to check if the update for soundsystem configuration is received or not.
*
*
*******************************************************************************/
bool aud_extampconn_timer::bIsupdateRcvdfrmAmplifier()
{
  ETG_TRACE_USR4(("aud_extampconn_timer::bIsupdateRcvdfrmAmplifier() called"));
  if (m_u8soundConfig != 0x0)
    return true;
  return false;
}


/*******************************************************************************
*
* FUNCTION: aud_extampconn_timer::bIsExtAmplifierConnected()
*
* DESCRIPTION: Function to check if amplififer is connected or not.
*
*
*******************************************************************************/
tBool aud_extampconn_timer::bIsExtAmplifierConnected()
{
  tBool bExtAmpConnected = FALSE;
  ETG_TRACE_USR4(("aud_extampconn_timer::bIsExtAmplifierConnected called "));
  if (m_u8soundConfig != 0x0)
  {
    if ((m_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1) && (m_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2))
    {
      ETG_TRACE_USR4(("bIsExtAmplifierConnected, External Amplifier is connected since m_u8soundConfig %d", m_u8soundConfig));
      bExtAmpConnected = TRUE;
    }
    else
      ETG_TRACE_USR4(("bIsExtAmplifierConnected, Internal Amplifier is connected since m_u8soundConfig:%d ", m_u8soundConfig));
  }
  else
    ETG_TRACE_USR4(("bIsExtAmplifierConnected,No update from Amplifier since m_u8soundConfig:%d", m_u8soundConfig));
  return bExtAmpConnected;

}


/*******************************************************************************
*
* FUNCTION: aud_extampconn_timer::vSendDiagTurnOnStatus()
*
* DESCRIPTION: Function to send diagnosis Turn On status based on the Amplififer connection
*
*
*******************************************************************************/
tVoid aud_extampconn_timer::vSendDiagTurnOnStatus()
{
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX)
  plugin_loader* oPluginLoader;
  oPluginLoader = aud_sinkmgr_main::GetPluginLoaderInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(oPluginLoader);
  if (oPluginLoader->bIsPluginDirLoaded() && (bIsExtAmplifierConnected() == TRUE))
  {
    ETG_TRACE_USR4(("vSendDiagTurnOnStatus:: External Amplifier Connected, Sending Diagnosis Speaker test Turn OFF"));
    ID_DiagTurnONStatus oDiagTurnONStatus(EN_AUDIO_DIAG_TURN_ON_NO); // sending Diagnosis Turn OFF message if external amplifier is connected
    pPO->POMessages->DeliverMsg(&oDiagTurnONStatus);
  }
  else
  {
    ETG_TRACE_USR4((" vSendDiagTurnOnStatus::External Amplifier not Connected, Sending Diagnosis Speaker test Turn ON"));
    ID_DiagTurnONStatus oDiagTurnONStatus(EN_AUDIO_DIAG_TURN_ON_YES); // sending Diagnosis Turn ON message if external amplifier is not connected
    pPO->POMessages->DeliverMsg(&oDiagTurnONStatus);
  }
#endif

#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV)
  ETG_TRACE_USR4(("vSendDiagTurnOnStatus EN_AUDIO_DIAG_TURN_ON_YES"));
  ID_DiagTurnONStatus oDiagTurnONStatus(EN_AUDIO_DIAG_TURN_ON_YES); // sending Diagnosis Turn ON message for Inf4CV
  pPO->POMessages->DeliverMsg(&oDiagTurnONStatus);
#else
  ETG_TRACE_USR4(("vSendDiagTurnOnStatus:: Sending Diagnosis Speaker test Turn OFF/ON is not required"));
  ID_DiagTurnONStatus DiagTurnONStatus(EN_AUDIO_DIAG_TURN_ON_NO); // sending Diagnosis Turn OFF message for suzuki
  pPO->POMessages->DeliverMsg(&DiagTurnONStatus);
#endif
}

