/************************************************************************FA*
 *File         :  VolOffset_Manager.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/18/2012     Anu Sebastian
 ************************************************************************/

#ifndef VOLOFFSET_MANAGER_H_
#define VOLOFFSET_MANAGER_H_

#include "../InternalComponentCommunication/DataTypes/TypeDefines/VolOffset_AuxInLevel.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/VolOffset_CueType.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"


#define ADR_DB_RESOLUTION      4   //(1/4 DB)
#define CHANNEL_MUTE (-120*ADR_DB_RESOLUTION)   //-120 dB

//#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
//#include <midw_fi_if.h>

class AuxInVolOff;

class VolOffset_Manager: public IF_MessageObserver<PO_MessageConfig::enID>
{
private:
   AuxInVolOff* poAuxInVolumeOffset;
  tenAuxInLevel enAuxInLevel;
  tenCueType enCueType;
  tenStream  enStream;
  tS16 VolOffset_Total;
  tU8 AuxVal;
  tU16 CCASource;
  midw_fi_tcl_e8_AudSource::tenType enSource;
  tS32 InputGainOffset;
  tS16 m_s16SubWoofer;
  tS16 m_s16CenterGain;
  tS8 CenterMin_Value;
  tS8 SubWooferMin_Value;
  tS8 CenterMax_Value;
  tS8 SubWooferMax_Value;
  tU8 CenterGainPerStepValue;
  tU8 SubWooferGainPerStepValue;
  tU8 m_u8RearMute;
  bool ChildSleep;
  //fc_audiomanager_tclApp *m_poAudio_main;

  void vLimitCenterGain(void);
  void vLimitSubWooferGain(void);
public:
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  VolOffset_Manager(void);
  virtual ~VolOffset_Manager();
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void SetVolOffsetValue(tS16 VolOffset_Total_Set);
  void vOnLoadSettings();
  void vCalcTotalVolumeOffset();
  void vAddInputGainOffSet(tS16 & VolOffset);
  void vLoadVolumeOffsetDataFromDP();
  void vCalcSubWoofer(fi_tclVisitorMessage& roMessage);
  void vCalcCenterGain(fi_tclVisitorMessage& roMessage);
  tVoid NotifyRearMute(tU8 tRearMuteType);
  bool vIsMixSource(midw_fi_tcl_e8_AudSource::tenType Source);
};


#endif /* VOLOFFSET_MANAGER_H_ */
