/************************************************************************FA*
 *File         :  CueVolumeOffset.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  12/18/2012     Anu Sebastian
 ************************************************************************/
#include "CueVolumeOffset.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/CueVolumeOffset.cpp.trc.h"
#endif

tS16 CueVolOff::CueOffsetVal = 0;
CueVolOff::CueVolOff()
{
  CueOffsetVal = 0;
}

tS16 CueVolOff::GetVolOffset(tU16 CCASource,tenCueType enCueType)
{
  if(  (CCASource ==(tU8)(midw_fi_tcl_e8_AudSource::FI_EN_CPRA))
       ||(CCASource == (tU8)(midw_fi_tcl_e8_AudSource::FI_EN_CDDA))
       ||(CCASource == (tU8)(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2))
     )
  {
    switch(enCueType)
    {
      case EN_AUDIO_VOLOFFSET_CUETYPE_START:
        CueOffsetVal = VOLOFFSET_CUETYPE_START * VOLOFFSET_RESOLUTION;
        break;
      case EN_AUDIO_VOLOFFSET_CUETYPE_STOP:
        CueOffsetVal = VOLOFFSET_CUETYPE_STOP * VOLOFFSET_RESOLUTION;
        break;
      default:
        CueOffsetVal = 0;
        break;
    }

  }
  else
  {
    CueOffsetVal = 0;
  }

  ETG_TRACE_USR4(("Cue volOffsetValue set to %x",CueOffsetVal));

  return CueOffsetVal;
}


