//
// VolumeManager/VolumeManager.h
//
//  Created on: Jun 16, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_E479F164_58CD_4abe_B302_7FC3505D3DF1__INCLUDED_)
#define EA_E479F164_58CD_4abe_B302_7FC3505D3DF1__INCLUDED_
//#ifndef VOLUMEMANAGER_H_
//#define VOLUMEMANAGER_H_


#include "Utilities/Uncopyable.h"

#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"

class amt_tclServiceData;
class AmpVolumeData;
class fc_audiomanager_tclService_Audio_Function;
class Fading_IF;


namespace VolumeManager
{

   // --------------------------------------------------------------------------

   class Engine;
   class CCAListener;
   class StreamSet;
   class PropertyStore;
   class Configuration;

   // --------------------------------------------------------------------------

   class VolumeManager  : private Uncopyable
   {

   public:
      /* constructor */ VolumeManager(fc_audiomanager_tclService_Audio_Function& parent);
      /* destructor */ ~VolumeManager();

      // support delegating CCA message processing
      tVoid vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData& roMessage);
//      tVoid vOnMethodAbort(tU16 u16FunctionId, amt_tclServiceData* poMessage);
      tBool bGetStatusMessage(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
      tBool bProcessSet(amt_tclServiceData& roMessage, tBool& bPropertyChanged, tU16& u16Error);

      void vOnLoadSettings();

      // launch PO message with volume settings for amplifier / ADR3
      static void vLaunchAmplifierCommand(const AmpVolumeData& AmpData);

      // TTFis support
      void vHandleTTFisCommand (tU32 size, const tU8* pcu8Data);
    tS16 s16getDBValue(tU8 u8UserStep, tenStream enStream); // to get the DB value corresponding to volume step from volume curve

   private:
      // member variables
      fc_audiomanager_tclService_Audio_Function& _parent;
      Configuration* _pConfiguration;
      PropertyStore* _pProperties;
      Engine* _pEngine;
      CCAListener* _pCCAListener;

   };

}   // namespace VolumeManager

//#endif  // VOLUMEMANAGER_H_
#endif // !defined(EA_E479F164_58CD_4abe_B302_7FC3505D3DF1__INCLUDED_)

