/*
 * Array.hpp
 *
 *  Created on: Sep 25, 2014
 *      Author: kma4hi
 */

#if !defined(EA_2232223A_B5A5_4f6a_AB21_A40DDF5EDEC6__INCLUDED_)
#define EA_2232223A_B5A5_4f6a_AB21_A40DDF5EDEC6__INCLUDED_
//#ifndef ARRAY_HPP_
//#define ARRAY_HPP_

namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   template<typename T>
   inline void swapMember (T& lhs, T& rhs)
   {
      T tmp = lhs;
      lhs = rhs;
      rhs = tmp;
   };

   // =============================================================================

   template<class T>   class Array
   {
      private:
         // member variables
         T *_elems;
         unsigned _rawSize;
         unsigned _size;

      public:
         inline /* constructor */ Array (unsigned s);
         /* destructor */ ~Array ();

         unsigned size () const;
         void setSize (unsigned s);  // allow restricting to sub-set

         T& operator[] (unsigned index);
         void operator= (T rhs);
         void swap (Array<T>& rhs);
   };

   // -----------------------------------------------------------------------------

   template<class T>  /* constructor */  Array<T>:: Array (unsigned s)
   {
      _rawSize = s;
      _elems = new T[_rawSize];

      _size = _rawSize;
//            for (unsigned i = 0; i < _size; i++)
//               _elems[i] = 0;
   }

   // -----------------------------------------------------------------------------

   template<class T>  /* destructor */ Array<T>:: ~Array ()
   {
      delete[] _elems;
   }

   // -----------------------------------------------------------------------------

   template<class T>  unsigned Array<T>:: size () const
   {
      return _size;
   }

   // -----------------------------------------------------------------------------

   template<class T>  void Array<T>:: setSize (unsigned s)
   {
      // allow restricting to sub-set
      if (s <= _rawSize)
         _size = s;
      else
         _size = _rawSize;
   }

   // -----------------------------------------------------------------------------

   template<class T>  T& Array<T>:: operator[] (unsigned index)
   {
      // undefined if index >= _rawSize
      return _elems[index];
   }

   // -----------------------------------------------------------------------------

   template<class T>  void Array<T>:: operator= (T rhs)
   {
       for (int i = 0; i < _size; i++)
          _elems[i] = rhs;
   }

   // -----------------------------------------------------------------------------

   template<class T>  void Array<T>:: swap (Array<T>& rhs)
   {
      swapMember<unsigned>(_rawSize, rhs._rawSize);
      swapMember<unsigned>(_size, rhs._size);
      swapMember<T*>(_elems, rhs._elems);
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager

//#endif /* ARRAY_HPP_ */
#endif // !defined(EA_2232223A_B5A5_4f6a_AB21_A40DDF5EDEC6__INCLUDED_)

