//
// VolumeManager/Engine/Configuration/StreamSet.h
//
// Collection of objects controlling audio streams
//
//  Created on: Jun 26, 2014
//      Author: Martin Koch, Fa. ESE.de
//

#if !defined(EA_85A51F0D_8677_4199_8593_E268E1B71452__INCLUDED_)
#define EA_85A51F0D_8677_4199_8593_E268E1B71452__INCLUDED_
//#ifndef AUDIOSTREAMSET_H_
//#define AUDIOSTREAMSET_H_


class Fading_IF;
class VolumeData;
#include "Volume/Utilities/Uncopyable.h"


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Stream;
   class Configuration;
   struct StreamSetConfig;
   class SourceList;
   class dBCalculator;
   class IFunction;

   // -----------------------------------------------------------------------------

   class StreamSet  : private Uncopyable
   {
      private:
         const StreamSetConfig* _pConfig;
         Fading_IF*              _pFading;
         Array<IFunction*>       _functions;
         size_t                  _streamCount;
         Stream*                 _pStreams;
         tenStream               _activeStreamID;

      public:
         /* constructor */ StreamSet (const StreamSetConfig& setConfig, const Configuration& config, Fading_IF* pFading);
         /* default constructor */ StreamSet ();
         virtual /* destructor */ ~StreamSet();

         void swap (StreamSet& rhs);

         // selectors for matching stream
         Stream* pGetStream (tenStream enStream) const;
         Stream* pGetActiveStream ();

         tenStream           enGetActiveStreamID () const;
         tenResource         enGetResource () const;
         tenVolumeMode       enGetVolumeMode ();
         tenInternalSource   enGetCurrentSource () const;
         tenInternalSource   enGetRecentEntertainmentSource () const;
         Ramp                queryRamp (tenActions enAction, tenFadingReason enReason, tenStream enStream) const;

         void vSetActiveStream (tenStream enStreamID);
         const dBCalculator* pGetCalculator() const;

         void vAddFunction (IFunction* function);
         void vApplyVolumeFilters (tenFadingReason enReason, VolumeData& volumeData);
         void vApplyAmplifierFilters (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);
   };


   // -----------------------------------------------------------------------------

}  // namespace VolumeManager



//#endif /* AUDIOSTREAMSET_H_ */
#endif // !defined(EA_85A51F0D_8677_4199_8593_E268E1B71452__INCLUDED_)

