//
// VolumeManager/Engine/Functions/TAVolumeFunction.h
//
//  Created on: Sep 23, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_4401816A_BCDF_42dc_AC84_8DF2A835109A__INCLUDED_)
#define EA_4401816A_BCDF_42dc_AC84_8DF2A835109A__INCLUDED_
//#ifndef TAVOLUMEFUNCTION_H_
//#define TAVOLUMEFUNCTION_H_



namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   //                   class   T A - V o l u m e   F i l t e r
   //
   //  When switching to Traffic Announcement, compare volume against
   //  current Entertainment volume and use the higher value for TA
   //

   class TAVolumeFilter  :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      public:
         /* constructor */ TAVolumeFilter (PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~TAVolumeFilter ();


         // IFunction implementation
         virtual tenFunctionType enGetType ();
         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);

         // PostOffice message observer implementation
         virtual void MessageNotification (PO_MessageConfig::enID MsgId);

      protected:
         bool _useTASetup;
         bool _mustExceedEntertainmentVolume;
         bool _setMinTAVolume;
    };

   // -----------------------------------------------------------------------------

}


//#endif /* TAVOLUMEFUNCTION_H_ */
#endif // !defined(EA_4401816A_BCDF_42dc_AC84_8DF2A835109A__INCLUDED_)
