//
//  VolumeManager/Engine/Functions/TAVolumeFilter.cpp
//
//  Created on: Sep 23, 2014
//      Author: Martin Koch, Fa. ESE
//




// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "InternalComponentCommunication/MessageConfig.h"
#include "./IFunction.h"
#include "./FunctionBase.h"
#include "./TAVolumeFilter.h"
// - - - - - - - - - - - - -
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/TAVolumeFilter.cpp.trc.h"

//#include "fc_audiomanager_service_Audio_Function.h"
#include "Volume/PropertyStore.h"
#include "Volume/Engine/StreamSet.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_TA_DAN
#define MIN_TA_STARTUP_VOLUME 10
#else
#define MIN_TA_STARTUP_VOLUME 5
#endif
#define MIN_TA_VOLUME_LIMT 5
namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   //                   class   T A - V o l u m e   F i l t e r
   //
   //  When switching to Traffic Announcement, compare volume against
   //  current Entertainment volume and use the higher value for TA
   //


   /* constructor */ TAVolumeFilter:: TAVolumeFilter (PropertyStore& properties, const Configuration& config
            , const FunctionConfig& functionCfg, StreamSet& streamSet)
      : FunctionBase(properties, config, functionCfg, streamSet)
      , IF_MessageObserver<PO_MessageConfig::enID>("TAVolumeFilter")
      , _useTASetup(true)                    // t.b.d.  extract from functionCfg.pParams
      , _mustExceedEntertainmentVolume(true) // t.b.d.  extract from functionCfg.pParams
      , _setMinTAVolume(true)
   {
        PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
        pPO->AddObserver(this, PO_MessageConfig::ID_ApplicationStatus);
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ TAVolumeFilter:: ~TAVolumeFilter ()
   {
        PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
        pPO->RemoveObserver(this, PO_MessageConfig::ID_ApplicationStatus);
   }

   /* virtual */ void TAVolumeFilter:: MessageNotification (PO_MessageConfig::enID MsgId)
   {
      // PostOffice message observer implementation

      PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
       const ID_ApplicationStatus* pMsg = pPO->QueryMessage<ID_ApplicationStatus>(MsgId);
      ApplicationStateData Data (pMsg->value);

      switch (Data.m_State)
       {
      case AUD_APP_PWR_EVENT_APP_NORMAL:
    //    _properties.vResetDANValue();
    //    _setMinTAVolume = true;
       break;
      default:
       break;
       }
    }
   // -----------------------------------------------------------------------------

   /* virtual */ tenFunctionType TAVolumeFilter:: enGetType ()
   {
      return enTAVolumeFilter;
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void TAVolumeFilter:: vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData)
   {
      // check applicability
      if (EN_AUDIO_FADING_RES_SOURCESEL != enReason)
         return;
      tenVolumeMode enMode = _properties.enGetMode();
      tenInternalSource enSource = _streamSet.enGetCurrentSource();
      tenResource enResource = _streamSet.enGetResource();

      bool applicable
         =    (EN_INT_VOLMODE_SETUP_TA  == enMode)
           || ((AUD_INT_SRC_FM_TA == enSource) || (AUD_INT_SRC_DAB_TA == enSource));
      if ( ! applicable)
         return;

      ETG_TRACE_USR3(("TAVolumeFilter :  enMode : %d enSource : %d", enMode, enSource))
      #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_TA_DAN
      const tU8* pEntVolume  = _properties.pGetVolume(enResource, midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT);
      if(pEntVolume!=NULL)    //coverity fix
    {
      if(_setMinTAVolume && (*pEntVolume + _properties.s8GetDanValue()) < MIN_TA_STARTUP_VOLUME)
      {
        volumeData.m_Volume = MIN_TA_STARTUP_VOLUME;
        _setMinTAVolume = false;
      }
      else
      {
          if((*pEntVolume + _properties.s8GetDanValue()) < MIN_TA_VOLUME_LIMT)
                volumeData.m_Volume = MIN_TA_VOLUME_LIMT;
          else
        volumeData.m_Volume = (tU8)(*pEntVolume + _properties.s8GetDanValue()); //gen4 prio3 warning fix
      }

      tS8 danValue = (tS8)(volumeData.m_Volume - *pEntVolume);    //gen4 prio3 compiler warning fix

      _properties.vSetDanValue(danValue);
      }
      #else
      // adjust volume
      const tU8* pTAVolume  = _properties.pGetVolume(enResource, midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP);
      if (pTAVolume)
      {
         volumeData.m_Volume = *pTAVolume;
         if (EN_INT_VOLMODE_SETUP_TA  == enMode)
            return;

         if (_mustExceedEntertainmentVolume)
         {
            // in normal TA mode compare volume against entertainment volume und use the higher
            const tU8* pEntVolume  = _properties.pGetVolume(enResource, midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT);
            if (pEntVolume && (*pEntVolume > *pTAVolume))
                volumeData.m_Volume = *pEntVolume;

         }

         if(volumeData.m_Volume < MIN_TA_STARTUP_VOLUME)
           volumeData.m_Volume = MIN_TA_STARTUP_VOLUME;
      }
      else
      {
         ETG_TRACE_USR1(("vAdjustVolume():  no recent volume found for type %u at resource %u, using default"
            , ETG_CENUM(midw_fi_tcl_e8_Aud_VolumeType::tenType, midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP)
            , ETG_CENUM(tenResource, enResource)))
      }

    #endif
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager

