//
// SPIDuckingFilter.h
//
//  AUDIO_PROP_IPOD_DUCKING:
//    This property specially designed for Ipod-Out also known as CarPlay.
//    It is used to attenuate the main stream while an announcement on the mix stream is played.
//    This feature is called "ducking" by Apple Inc.
//
//  Created on: Nov 27, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_DBEA34DB_F603_407c_B0AC_0BE89036D4E8__INCLUDED_)
#define EA_DBEA34DB_F603_407c_B0AC_0BE89036D4E8__INCLUDED_


namespace VolumeManager
{

   class SourceGroup;

   // -----------------------------------------------------------------------------
   //
   //                       class  D u c k i n g - F i l t e r
   //
   //

   class SPIDuckingFilter    :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>

   {

      public:
         /* constructor */ SPIDuckingFilter(PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~SPIDuckingFilter();

         // IFunction implementation
         virtual tenFunctionType enGetType ();
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

         // PostOffice message observer implementation
         virtual void MessageNotification (PO_MessageConfig::enID MsgId);

      private:
         // helper functions
         void vSetAmplifierVolume (tU8 u8MainVolumeUserStep) const;
         void vApplyChanges () const;
         bool bConditionsAreMet () const;

         // member variables
         tenSPIMixMode _enDuckingActive;
         tS16          _s16VolumeDbLevel;
         bool          _activeSourceIsSPIInfo;
         tenMuteResult _enLastSPIMuteState;
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


#endif // !defined(EA_DBEA34DB_F603_407c_B0AC_0BE89036D4E8__INCLUDED_)
