//
// NavVolumeFilter.h
//
//  Created on: Sep 26, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_90CF4DD2_F0A9_4842_BC45_659886E65C36__INCLUDED_)
#define EA_90CF4DD2_F0A9_4842_BC45_659886E65C36__INCLUDED_


namespace VolumeManager
{
   class dBCalculator;
   class Stream;

   // -----------------------------------------------------------------------------
   //
   //       class   N a v i g a t i o n - V o l u m e - F i l t e r
   //
   //

   class NavVolumeFilter  :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      public:
         /* constructor */ NavVolumeFilter (PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~NavVolumeFilter ();

         // IFunction implementation
         virtual tenFunctionType enGetType ();
//         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

         // IF_MessageObserver implementation
         virtual void MessageNotification(PO_MessageConfig::enID MsgId);

      private:
         // Helper functions
         void SetDependentVolume (Stream& dependentStream, const dBCalculator& calc) const;
         void ResetDependentVolume (Stream& dependentStream) const;

    };

   // -----------------------------------------------------------------------------

}


//#endif /* NAVVOLUMEFILTER_H_ */
#endif // !defined(EA_90CF4DD2_F0A9_4842_BC45_659886E65C36__INCLUDED_)
