//
//  VolumeManager/Engine/Functions/DiagVolume.cpp
//
//  Created on: Aug 25, 2015
//      Author: rej1kor
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

// project includes
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES  // add loading of error codes
#include "Volume/Types.h"  // implicitly links types from <midw_fi_if.h>
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "./IFunction.h"
#include "./FunctionBase.h"
#include "InternalComponentCommunication/MessageConfig.h"

#include "./DiagVolume.h"
// - - - - - - - - - - - - -

#include "Volume/VolumeManager.h"
#include "Volume/PropertyStore.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/Engine/Actions/IAction.h"
#include "Volume/Engine/Actions/ActionBase.h"
#include "Volume/Engine/Actions/VolumeSetAction.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/TypeConversions/Functions.h"

#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/AmpVolumeData.h"  // for amplifier command
//#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeModeData.h"
#include "fc_audiomanager_service_Audio_Function.h"  // for fading module

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/DiagVolume.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------
   //
   // class   Diag Audio Gain - V o l u m e - F i l t e r
   //
   //


   /* constructor */ DiagVolume:: DiagVolume (PropertyStore& properties, const Configuration& config
         , const FunctionConfig& functionCfg, StreamSet& streamSet)
      : FunctionBase(properties, config, functionCfg, streamSet)
   {
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ DiagVolume:: ~DiagVolume ()
   {

   }

   // -----------------------------------------------------------------------------

   /* virtual */ tenFunctionType DiagVolume:: enGetType ()
   {
      return enDiagVolume;
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void DiagVolume:: vAdjustVolume (tenFadingReason /* enReason */, VolumeData& /* volumeData */)
   {
     return;
   }

   // -----------------------------------------------------------------------------


   /* virtual */ void DiagVolume:: vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand)
   {
      // check applicability
    tenStream enStream = fiAudioChannel_StreamID_Map::getSecond(volumeData.m_Channel);
    Stream* pStream = _streamSet.pGetStream(enStream);

    tenVolumeMode enMode = EN_INT_VOLMODE_NOT_DEF;
    if(pStream)
    enMode = pStream->enGetCurrentMode();

      if(enMode != EN_INT_VOLMODE_REMOTE_CONTROL_START)
       return;

      tenStream enActiveStream = _streamSet.enGetActiveStreamID();
      useStandardAmplifierCommand = false;

      ETG_TRACE_USR4(("DiagVolume: vAdjustAmplifierVolume Setting Audio Gain"));
      AmpVolumeData AmpData;
      AmpData.m_enStream = enActiveStream;
      AmpData.m_VolStep = _properties.u8GetVolume();

      if(enReason == EN_AUDIO_FADING_RES_SOURCESEL)
           AmpData.m_VoldB   = static_cast<tS16>(-120 * dBCalculator::dBStepMultiplicator);
      else
        AmpData.m_VoldB   = static_cast<tS16>(volumeData.m_VolumeGain * dBCalculator::dBStepMultiplicator);

      AmpData.m_RampLin = 100; // FastRamp : 100ms
      AmpData.m_RampdB = 80; //FastRamp : 80db
      VolumeManager::vLaunchAmplifierCommand(AmpData);
   }
}

