//
// BeepVolumeFilter.h
//
//  Created on: Dec 15, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_3BD7C265_673A_41d7_B1C6_F43075666A4B__INCLUDED_)
#define EA_3BD7C265_673A_41d7_B1C6_F43075666A4B__INCLUDED_


namespace VolumeManager
{
   class dBCalculator;
   class Stream;

   // -----------------------------------------------------------------------------
   //
   //                 class   B e e p - V o l u m e - F i l t e r
   //
   //

   class BeepVolumeFilter  :  public FunctionBase, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      public:
         /* constructor */ BeepVolumeFilter (PropertyStore& properties, const Configuration& config
               , const FunctionConfig& functionCfg, StreamSet& streamSet);
         virtual /* destructor */ ~BeepVolumeFilter ();

         // IFunction implementation
         virtual tenFunctionType enGetType ();
//         virtual void vAdjustVolume (tenFadingReason enReason, VolumeData& volumeData);
         virtual void vAdjustAmplifierVolume (tenFadingReason enReason, const VolumeData& volumeData, bool& useStandardAmplifierCommand);

         // IF_MessageObserver implementation
         virtual void MessageNotification(PO_MessageConfig::enID MsgId);

      private:
         // member variables
         bool _isMainAudioMuted;
         tenStream _enBeepStreamID;
         tU8 _u8MinBeepVolume;
         tU8 _u8MaxBeepVolume;
    };

   // -----------------------------------------------------------------------------

}


#endif // !defined(EA_3BD7C265_673A_41d7_B1C6_F43075666A4B__INCLUDED_)
