//
// AttenuationFilter.cpp
//
//  MAINSTREAM ATTENUATION
//
//  Created on: Aug 29, 2016
//      Author: REJ1KOR
//



// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"  // implicitly links <midw_fi_if.h>
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IFunction.h"
#include "./FunctionBase.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "AttenuationFilter.h"

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>


#include <vector>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "AudioProxy/aud_gio_dbus_handler.h"
#include "AudioProxy/aud_gio_dbus_audproc_proxy.h"

// - - - - - - - - - - - - -
#include "vd_adr3Msg_If.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/VolumeManager.h"
#include "Volume/PropertyStore.h"
#include "Volume/Engine/Actions/IAction.h"
#include "Volume/Engine/Actions/ActionBase.h"
#include "Volume/Engine/Actions/VolumeSetAction.h"
#include "Volume/TypeConversions/Functions.h"

#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/AmpVolumeData.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSPIMixData.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_SPIMixVolume.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_FAPAttenuation.h"
#include "InternalComponentCommunication/Messages/Beep/ID_ADASBeepActive.h"
#include "InternalComponentCommunication/Messages/mute/IDNotifyMute.h"
#include "InternalComponentCommunication/Messages/mute/IDTCUMuteRadioOrder.h"
#include "InternalComponentCommunication/Messages/Source/IDIntSource.h"
#include "InternalComponentCommunication/Messages/SoundConfig/IDSetSoundSystemConfig.h"
#include "InternalComponentCommunication/Messages/Volume/ID_Premium2Amp_Attenuation.h"

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/AttenuationFilter.cpp.trc.h"


namespace VolumeManager
{

#define UNDEF_VALUE 255
#define ATTENUATE 2
#define MAX_DB -120
  // -----------------------------------------------------------------------------

  /* constructor */ AttenuationFilter:: AttenuationFilter(PropertyStore& properties, const Configuration& config
                , const FunctionConfig& functionCfg, StreamSet& streamSet)
  : FunctionBase(properties, config, functionCfg, streamSet)
  , IF_MessageObserver<PO_MessageConfig::enID>("AttenuationFilter")
  ,_bMix1SrcActiveFlag(false)
  ,_bSPIInfoSrcActiveFlag(false)
  ,_bSPIDuckingActiveFlag(false)
  ,_bSPICarplayDuckingActiveFlag(false)
  ,_bCANAttenuationActiveFlag(false)
  ,_bCANPartialMuteAttenuationActiveFlag(false)
  ,_bADASAttenuationActiveFlag(false)
    ,_bCheckVolumeChangeAllowed(false)
  ,_bFAPAttenuationActiveFlag(false)
    ,_s16SPIDuckingVolAttenuationLevel(MUTE)
    ,_s16NaviVolAttenuationLevel(MUTE)
  ,_s16MainStreamAttenuationdBvalue(MUTE)
  ,_s16Mix1StreamAttenuationdBvalue(MUTE)
  ,_s16Mix2StreamAttenuationdBvalue(MUTE)
    ,_s16AdasBeepVolume(MUTE)
    ,_s16AttenuationValue(0)
  ,_u8soundConfig(0)
  ,_s16PrevAttenuationVal(0)
    ,enStreamcheck(EN_AUDIO_SOURCE_STREAM_DEFAULT)
    ,_enAdasBeeptype(EN_ADAS_BEEPTYPE_UNKNOWN)
    ,_enDuckingActive(EN_INT_SPI_UNDUCK)
  {
    _Voldata.vSetToDefault();

    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    pPO->AddObserver(this, PO_MessageConfig::ID_SPIMixVolume);

    // register for source change notifications
    pPO->AddObserver(this, PO_MessageConfig::IDIntSource);

    // register for mute changes
    pPO->AddObserver(this, PO_MessageConfig::ID_NotifyMute);

    // register for CAN Attenuation Values
    pPO->AddObserver(this, PO_MessageConfig::ID_CANAttenuation);

    // register for CAN Attenuation Values
    pPO->AddObserver(this, PO_MessageConfig::ID_CAN_PARTIAL_MUTE_Attenuation);

    // register for ID_ADASBeepActive
    pPO->AddObserver(this, PO_MessageConfig::ID_ADASBeepActive);

    //register for Volume Commands
    pPO->AddObserver(this, PO_MessageConfig::ID_CCA_Start_Volume);

    //register for SoundSystem Config
    pPO->AddObserver(this, PO_MessageConfig::IDSetSoundSystemConfig);

    //register for FAP Attenuation Message
    pPO->AddObserver(this, PO_MessageConfig::ID_FAPAttenuation);

    pPO->AddObserver(this, PO_MessageConfig::ID_TCUMuteRadioOrder);

  }


  // -----------------------------------------------------------------------------

  /* virtual destructor */ AttenuationFilter:: ~AttenuationFilter()
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_NotifyMute);
    pPO->RemoveObserver(this, PO_MessageConfig::IDIntSource);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_SPIMixVolume);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_CANAttenuation);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_CAN_PARTIAL_MUTE_Attenuation);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_ADASBeepActive);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_CCA_Start_Volume);
    pPO->RemoveObserver(this, PO_MessageConfig::IDSetSoundSystemConfig);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_FAPAttenuation);
    pPO->RemoveObserver(this, PO_MessageConfig::ID_TCUMuteRadioOrder);

  }

  // -----------------------------------------------------------------------------

  /* virtual */ tenFunctionType AttenuationFilter:: enGetType ()
  {
    return enAttenuationFilter;
  }


  // -----------------------------------------------------------------------------

  /* virtual */ void AttenuationFilter:: vAdjustAmplifierVolume (tenFadingReason  enReason,
                 const VolumeData& /* volumeData */,
                 bool& useStandardAmplifierCommand)
  {

    Stream* pStream = _streamSet.pGetActiveStream();

    if(pStream == NULL)
      return;

    if( pStream->enGetCurrentSource() == AUD_INT_SRC_TCU_ECALL)
    {
        ETG_TRACE_USR4(("AttenuationFilter:: Allow E-CALL to adjust amplifier volume, when attenuation is active"));
        return;
    }

    if( bIsCANAttenuationActive() == true || _properties.bIsTCUMuteRadioOrderActive() )
      {
  // Condition when Attenuation request is received even before Source selection.
  if(enReason == EN_AUDIO_FADING_RES_SOURCESEL && pStream->s16GetStreamAttenuationLevel() == MUTE)
    {
      //Try to recompute Volume
      vComputeAndAttenuateMainStreamVolumeLevel();
      vComputeAndAttenuateMix1StreamVolumeLevel();
      vComputeAndAttenuateMix2StreamVolumeLevel();
    useStandardAmplifierCommand = false;
    }
  else
    {
      // Requirement: Do Not allow volume change on any stream when Attenuation request from CAN is active.
      ETG_TRACE_USR4(("AttenuationFilter::CANAttenuationActive is active. No Volume change allowed on any Stream"));
    useStandardAmplifierCommand = false;
      return;
    }
      }

    if(bIsADASBeepsActive())
      {
  // Condition when Attenuation request is received even before Source selection.
  if(enReason == EN_AUDIO_FADING_RES_SOURCESEL && pStream->s16GetStreamAttenuationLevel() == MUTE)
    {
      //Try to recompute Volume
      vComputeAndAttenuateMainStreamVolumeLevel();
      vComputeAndAttenuateMix1StreamVolumeLevel();
      vComputeAndAttenuateMix2StreamVolumeLevel();
      useStandardAmplifierCommand = false; // Block Volume change in VolumeSet Action.
    }
  else
    {
      tenStream StreamId = pStream->enGetStreamID();

      // Change volume here only for first request When ADAS beeps are active or When Stream is changed. Consequent requests will be taken care by VolumeSet Action.
      if( _properties.enGetCurrentSource() != pStream->enGetCurrentSource() || !_bCheckVolumeChangeAllowed || enStreamcheck != StreamId )
        {
    ETG_TRACE_USR4(("AttenuationFilter::ADASBeepsActive. Changing Volume from Attenuated Level"));

    _bCheckVolumeChangeAllowed = true;  //Should be blocked for next Volume change as it is taken care in VolumeSet action.

    enStreamcheck = StreamId;
    tS16 db = s16GetAttenuatedDbLevel(StreamId);

    tU8 VolStep = 0;
    const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());

    if(NULL == pCalc)
      return;

    if(db == MUTE) // Attenuation request active but greater than current volume.. So Get the current volume and apply..
      {
        VolStep = u8GetStreamCurrentVolumeStep(StreamId);
        db = pCalc->s16GetdBValue(VolStep, EN_AUDIO_SOURCE_STREAM_DEFAULT);
      }
    else
      {
        VolStep = pCalc->u8GetStepValue(db);

        if(VolStep == UNDEF_VALUE)
          VolStep = pCalc->u8GetMinimumUserStep(); // Shouldn't hit here but worst case better to start from some minimum volume limit.
      }

    VolStep = u8GetCalculatedTargetStep(_Voldata, VolStep);
    const SourceConfig* pSecondarySource = _config.pGetSourceConfig(pStream->enGetCurrentSource());

    vApplyLimits(VolStep, pSecondarySource);

    vSetAmplifierVolume(VolStep,db, StreamId);

    //Update internal properties and send back the status for volume change.
    if(NULL != pSecondarySource)
      {
        _properties.vSetCurrentSource(*pSecondarySource,pStream->enGetResource());
        _properties.vUpdateVolume(pStream->enGetResource(), pStream->enGetCurrentMode(), *pSecondarySource, VolStep);

        // update VolumeList also.
        if ((EN_INT_VOLMODE_SETUP_TA == pStream->enGetCurrentMode()) &&
      _properties.bIsVolumeInList(pStream->enGetResource(), midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP))
          _properties.vUpdateVolumeInList(pStream->enGetResource(), midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP, VolStep);
        else
          _properties.vUpdateVolumeInList(pStream->enGetResource(), pSecondarySource->u8GetGroupType(), VolStep);

      }
    _properties.NotifyAllUpdates();
    useStandardAmplifierCommand = false; // Block Volume change in VolumeSet Action.
    return;
        }
    }
      }
  }

  // -----------------------------------------------------------------------------

  /* virtual */ void AttenuationFilter:: MessageNotification (PO_MessageConfig::enID MsgId)
  {
    // PostOffice message observer implementation
    switch (MsgId)
    {
      case PO_MessageConfig::ID_SPIMixVolume:
  {
    vHandleSPIMixVolumePOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::IDIntSource:
  {
    vHandleIntSourcePOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_NotifyMute:
  {
    vHandleNotifyMutePOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_CANAttenuation:
  {
    vHandleCANAttenuationPOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_CAN_PARTIAL_MUTE_Attenuation:
  {
	  vHandleCANPartialMuteAttenuationPOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_ADASBeepActive:
  {
    vHandleADASBeepActivePOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_CCA_Start_Volume:
  {
    vHandleSetVolumePOMsg(MsgId);
  }
  break;

      case PO_MessageConfig::ID_FAPAttenuation:
  {
    vHandleFAPAttenuationPOMsg(MsgId);
  }
  break;
      case PO_MessageConfig::IDSetSoundSystemConfig:
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;

    // Obtaining the sound system configuration received from External Amplifier
    if(pPO)
      {
        const IDSetSoundSystemConfig* pMsg = pPO->QueryMessage<IDSetSoundSystemConfig>(MsgId);
        if(pMsg)
    _u8soundConfig = pMsg->u8SoundConfig;
      }
  }
  break;
      case PO_MessageConfig::ID_TCUMuteRadioOrder:
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_TCUMuteRadioOrder* pMsg = pPO->QueryMessage<ID_TCUMuteRadioOrder>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    ETG_TRACE_USR4(("Sink_Mute Observer has received action : %x", pMsg->bTCUMute));

    if(pMsg->bTCUMute)
      {
        _properties.vSetTCUMuteRadioOrderActiveFlag();
      }
    else
      {
        _properties.vClearTCUMuteRadioOrderActiveFlag();
      }

  }
  break;

      default:
  ETG_TRACE_COMP(("AttenuationFilter::MessageNotification() : unhandled message received: ID = %u", MsgId ))
  break;
    }

  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter:: vSetAmplifierVolume (tU8 u8MainVolumeUserStep, tS16 dbValue, tenStream enStream) const
  {
    // apply filtering
    AmpVolumeData AmpData;
    AmpData.m_enStream = enStream;
    AmpData.m_VolStep  = u8MainVolumeUserStep;
    AmpData.m_VoldB    = static_cast<tS16>(dbValue * dBCalculator::dBStepMultiplicator);
    Ramp ramp          = _streamSet.queryRamp(EN_AUDIO_FADING_NOTIFY_CHG_VOL, EN_AUDIO_FADING_RES_USR, AmpData.m_enStream);
    AmpData.m_RampLin = ramp.lin;
    AmpData.m_RampdB = ramp.dB;
    VolumeManager::vLaunchAmplifierCommand(AmpData);
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter:: vRestorePremium2Mix1AmplifierVolume ()
  {
    AmpVolumeData AmpData;

    if(!bIsMix1SrcActive() && !bIsSPIDuckingActive())
    {
      AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX1;
      AmpData.m_VoldB    = 0;
    }

    ID_Premium2Amp_Attenuation outMsg(AmpData);

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::POMessages);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

    ETG_TRACE_USR2(("ID_Premium2Amp_Restoring"
        " - launched amplifier volume command for stream = %u, Step = %d"
        " , dB = %d, Ramp (lin/log) = %d/%d"
        , AmpData.m_enStream, AmpData.m_VolStep
        , AmpData.m_VoldB, AmpData.m_RampLin, AmpData.m_RampdB ))
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter:: vRestorePremium2Mix2AmplifierVolume ()
  {
    AmpVolumeData AmpData;

    if (!bIsSPIDuckingActive() && bIsMix1SrcActive()) //Condition check only when Carplay is ramping down to off but MIX1 is still active
    {
      AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX2;
      AmpData.m_VoldB    = -10;
    }
    else
    {
      AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX2;
      AmpData.m_VoldB    = 0;
    }

    _bSPICarplayDuckingActiveFlag = false;  //Set the flag to false which is applicable only to carplay ducking

    ID_Premium2Amp_Attenuation outMsg(AmpData);

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::POMessages);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

    ETG_TRACE_USR2(("ID_Premium2Amp_Restoring"
        " - launched amplifier volume command for stream = %u, Step = %d"
        " , dB = %d, Ramp (lin/log) = %d/%d"
        , AmpData.m_enStream, AmpData.m_VolStep
        , AmpData.m_VoldB, AmpData.m_RampLin, AmpData.m_RampdB ))
  }

  //-----------------------------------------------------------------------------
  void AttenuationFilter:: vSetPremium2AmplifierVolume (tU8 u8MainVolumeUserStep, tS16 dbValue)
  {
    // apply filtering
    AmpVolumeData AmpData;
    AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MAIN;

    if(bIsMix1SrcActive() && !bIsSPIDuckingActive())
    {
      AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX1;
      AmpData.m_VoldB    = -10;
    }

    else if(bIsSPIDuckingActive())
    {
      if(_enDuckingActive == EN_INT_SPI_DUCK) //Condition to check only for Carplay
      {
        AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX2;
        AmpData.m_VoldB    = dbValue;
        _bSPICarplayDuckingActiveFlag = true;

      }
      else if(_enDuckingActive == EN_INT_SPI_NATIVE_DUCK && !bIsMix1SrcActive())  //Condition to check for both, if MIX1 is active and also in non active case
      {
        AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MIX1;
        AmpData.m_VoldB    = -10;
      }
    }

    else
      return;


    ID_Premium2Amp_Attenuation outMsg(AmpData);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::POMessages);
    InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

    ETG_TRACE_USR2(("ID_Premium2Amp_Attenuation"
       " - launched amplifier volume command for stream = %u, Step = %d"
       " , dB = %d, Ramp (lin/log) = %d/%d"
       , AmpData.m_enStream, AmpData.m_VolStep
       , AmpData.m_VoldB, AmpData.m_RampLin, AmpData.m_RampdB ))
    (void)u8MainVolumeUserStep;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsMix1SrcActive() const
  {
    return _bMix1SrcActiveFlag;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsSPISrcActive() const
  {
    return _bSPIInfoSrcActiveFlag;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsSPIDuckingActive() const
  {
    return _bSPIDuckingActiveFlag;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsCANAttenuationActive() const
  {
    return _bCANAttenuationActiveFlag;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsADASBeepsActive() const
  {
    return _bADASAttenuationActiveFlag;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bIsFAPAttenuationActive() const
  {
    return _bFAPAttenuationActiveFlag;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleSPIMixVolumePOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

    const ID_SPIMixVolume* poMsg = pPO->QueryMessage<ID_SPIMixVolume>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMsg);

    if (_enDuckingActive != poMsg->value.m_SPIMixMode)
      {
  ETG_TRACE_USR2(("AttenuationFilter::MessageNotification() : changing SPIMixVolume: %u to %u with volume limit: %d "
      , ETG_CENUM(tenSPIMixMode, _enDuckingActive)
      , ETG_CENUM(tenSPIMixMode, poMsg->value.m_SPIMixMode)
      , poMsg->value.m_VolumeDbLevel))

            _enDuckingActive = poMsg->value.m_SPIMixMode;
  _s16SPIDuckingVolAttenuationLevel = poMsg->value.m_VolumeDbLevel;
      }
    else
      {
  ETG_TRACE_USR4(("AttenuationFilter::MessageNotification() : leaving SPIMixVolume: %u unchanged"
      , ETG_CENUM(tenSPIMixMode, _enDuckingActive)  ))
            return;
      }

    switch(_enDuckingActive)
    {
    case EN_INT_SPI_DUCK:
    {
      _bSPIDuckingActiveFlag = true;
      _properties.vSetSPIDuckingActiveFlag();
      _properties.vSetSPIDuckingLevel(_s16SPIDuckingVolAttenuationLevel);
      vComputeAndAttenuateMainStreamVolumeLevel();
      vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MIX2);
      break;
    }

    case EN_INT_SPI_NATIVE_DUCK:
    {
      _bSPIDuckingActiveFlag = true;
      _properties.vSetSPIDuckingActiveFlag();
      vComputeAndAttenuateMainStreamVolumeLevel();
      vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MIX2);
      break;
    }

    case EN_INT_SPI_DEVICE_DUCK:
    {
      vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MIX2);
      break;
    }

  case EN_INT_SPI_UNDUCK:
    {
      if(_bSPIDuckingActiveFlag)
      {
        _properties.vClearSPIDuckingActiveFlag();
        _bSPIDuckingActiveFlag = false;
      }
      _properties.vSetSPIDuckingLevel(MUTE);

      if(_properties.bIsExtAmpConnected() && _bSPICarplayDuckingActiveFlag && !bIsSPIDuckingActive())
        vRestorePremium2Mix2AmplifierVolume ();
      else
        vRestorePremium2Mix1AmplifierVolume ();

      if(bCheckIfAttenuationStillRequiredOnMainStream())
      {
        vComputeAndAttenuateMainStreamVolumeLevel();
        vCheckAndSetActiveStream();
      }
      else
      {
        _streamSet.vSetActiveStream(EN_AUDIO_SOURCE_STREAM_MAIN);
        vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
      }
      break;
    }
  default:
    break;
    }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleIntSourcePOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->QueryMessage<IDIntSource>(MsgId));

    const VolumeSourceData& data = pPO->QueryMessage<IDIntSource>(MsgId)->value;

    ETG_TRACE_USR2(("AttenuationFilter::vHandleIntSourcePOMsg() Source : %d", ETG_CENUM (tenInternalSource,data.m_Source)));
    if(midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX2 == data.m_Channel && AUD_INT_SRC_SPI_MIX == data.m_Source)
      {
  _bSPIInfoSrcActiveFlag = true;
      }

    if(midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX == data.m_Channel )
      {
  _bMix1SrcActiveFlag = true;
  _properties.vSetMix1ActiveFlag();
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleNotifyMutePOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_NotifyMute* pMsg = pPO->QueryMessage<ID_NotifyMute>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    ETG_TRACE_USR2(("AttenuationFilter::vHandleNotifyMutePOMsg() Stream : %d Action : %d",
  ETG_CENUM(tenStream,pMsg->enStream), ETG_CENUM(tenMuteResult, pMsg->enMuteResult)));

    switch(pMsg->enStream)
    {
      case EN_AUDIO_SOURCE_STREAM_MIX1:
  {
    if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_MUTE)
      {
        if(_properties.bIsMix1Active())
    {
      _bMix1SrcActiveFlag = false;
      _properties.vClearMix1ActiveFlag();

      if(_properties.bIsExtAmpConnected() && !bIsMix1SrcActive() && !bIsSPIDuckingActive())
        vRestorePremium2Mix1AmplifierVolume ();

      if(bCheckIfAttenuationStillRequiredOnMainStream())
        {
          vComputeAndAttenuateMainStreamVolumeLevel();
          vCheckAndSetActiveStream();
        }
      else
        {
          _streamSet.vSetActiveStream(EN_AUDIO_SOURCE_STREAM_MAIN);
          vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
        }
    }
      }
    else if (pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_DEMUTE)
      {
        vComputeAndAttenuateMainStreamVolumeLevel();
      }
  }
  break;
      case EN_AUDIO_SOURCE_STREAM_MIX2:
  {
    if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_MUTE)
      {
        _bSPIInfoSrcActiveFlag = false;
      }
  }
  break;

      default:
  break;
    }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleCANAttenuationPOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_CANAttenuation* pMsg = pPO->QueryMessage<ID_CANAttenuation>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    ETG_TRACE_USR2(("AttenuationFilter::vHandleCANAttenuationPOMsg() AttenuationCommand : %d, AttenuationValue = %d",
  pMsg->m_bAttenuationCommand, pMsg->m_bAttenuationValue));

  _s16AttenuationValue = pMsg->m_bAttenuationValue;
    if(_bCANAttenuationActiveFlag != pMsg->m_bAttenuationCommand || _s16PrevAttenuationVal != pMsg->m_bAttenuationValue)
      {
  if(pMsg->m_bAttenuationCommand || _bCANPartialMuteAttenuationActiveFlag)
    {
      _bCANAttenuationActiveFlag = true;

      _properties.vSetCANAttenuationFlag();
      vComputeAndAttenuateMainStreamVolumeLevel();
      vComputeAndAttenuateMix1StreamVolumeLevel();
      vComputeAndAttenuateMix2StreamVolumeLevel();
    }
  else
    {
      _bCANAttenuationActiveFlag = false;
      _properties.vClearCANAttenuationFlag();
      _properties.vSetCANAttenuationLevel(MUTE);
      vCheckAndRestoreVolumeLevels();
    }
      }
   _s16PrevAttenuationVal = pMsg->m_bAttenuationValue;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleCANPartialMuteAttenuationPOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_CAN_PARTIAL_MUTE_Attenuation* pMsg = pPO->QueryMessage<ID_CAN_PARTIAL_MUTE_Attenuation>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

    ETG_TRACE_USR2(("AttenuationFilter::vHandleCANPartialMuteAttenuationPOMsg() AttenuationCommand : %d, AttenuationValue = %d, MCANPartialMute = %d",
                   pMsg->m_bAttenuationCommand, pMsg->m_bAttenuationValue, pMsg->m_bCANPartialMute));

    _s16AttenuationValue = pMsg->m_bAttenuationValue;
    if(_bCANAttenuationActiveFlag != pMsg->m_bAttenuationCommand || _s16PrevAttenuationVal != pMsg->m_bAttenuationValue
    		|| _bCANPartialMuteAttenuationActiveFlag != pMsg->m_bCANPartialMute)
      {
  if(pMsg->m_bAttenuationCommand && pMsg->m_bCANPartialMute)
    {
      _bCANAttenuationActiveFlag = true;
      _bCANPartialMuteAttenuationActiveFlag = true;

      _properties.vSetCANAttenuationFlag();
      vComputeAndAttenuateMainStreamVolumeLevel();
      vComputeAndAttenuateMix1StreamVolumeLevel();
      vComputeAndAttenuateMix2StreamVolumeLevel();
    }
  else
    {
      _bCANAttenuationActiveFlag = false;
      _bCANPartialMuteAttenuationActiveFlag = false;

      _properties.vClearCANAttenuationFlag();
      _properties.vSetCANAttenuationLevel(MUTE);
      vCheckAndRestoreVolumeLevels();
    }
      }
   _s16PrevAttenuationVal = pMsg->m_bAttenuationValue;
  }
  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleADASBeepActivePOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_ADASBeepActive* pMsg = pPO->QueryMessage<ID_ADASBeepActive>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);


    ETG_TRACE_USR2(("AttenuationFilter::vHandleADASBeepActivePOMsg() ADASBeepActive : %d ",
  pMsg->m_bAdasBeepActive));

// commented to  enable no attenution in parkassist volume change
    //if(_bADASAttenuationActiveFlag != pMsg->m_bAdasBeepActive)
      {
  if(pMsg->m_bAdasBeepActive)
    {
      _bADASAttenuationActiveFlag = true;
      _properties.vSetADASAttenuationActiveFlag();
      _enAdasBeeptype = pMsg->m_entenAdasBeeptype;
      _s16AdasBeepVolume = static_cast<tS16>(pMsg->m_volume - 10);

      _properties.vSetADASAttenuationLevel(_s16AdasBeepVolume);
      vComputeAndAttenuateMainStreamVolumeLevel();
      vComputeAndAttenuateMix1StreamVolumeLevel();
      vComputeAndAttenuateMix2StreamVolumeLevel();
    }
  else
    {
      _bADASAttenuationActiveFlag = false;
      _properties.vClearADASAttenuationActiveFlag();
      _bCheckVolumeChangeAllowed = false;
      _properties.vSetADASAttenuationLevel(MUTE);
      enStreamcheck = EN_AUDIO_SOURCE_STREAM_DEFAULT;
      vCheckAndRestoreVolumeLevels();
    }
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleSetVolumePOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->QueryMessage<ID_CCA_Start_Volume>(MsgId));

    const VolumeData& pMsg = pPO->QueryMessage<ID_CCA_Start_Volume>(MsgId)->value;
    ETG_TRACE_USR2(("AttenuationFilter::vHandleSetVolumePOMsg got ID_CCA_Start_Volume"));

    _Voldata.setResource(pMsg.getResource());
    _Voldata.setVolume(pMsg.getVolume());
    _Voldata.setVolumeGain(pMsg.getVolumeGain());
    _Voldata.setVolumeType(pMsg.getVolumeType());
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vHandleFAPAttenuationPOMsg(PO_MessageConfig::enID MsgId)
  {
    PostOffice<PO_MessageConfig::enID>* pPO = InternalCommunicationAdapter::POMessages;
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    const ID_FAPAttenuation* pMsg = pPO->QueryMessage<ID_FAPAttenuation>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);


    if(_bFAPAttenuationActiveFlag != pMsg->m_u8AttenuationCommand)
      {
  if(pMsg->m_u8AttenuationCommand == ATTENUATE)
    {
      _bFAPAttenuationActiveFlag = true;
      vComputeAndAttenuateMainStreamVolumeLevel();
    }
  else
    {
      _bFAPAttenuationActiveFlag = false;
      if(bCheckIfAttenuationStillRequiredOnMainStream())
        {
    vComputeAndAttenuateMainStreamVolumeLevel();
    vCheckAndSetActiveStream();
        }
      else
        {
    _streamSet.vSetActiveStream(EN_AUDIO_SOURCE_STREAM_MAIN);
    vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
        }
    }
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vGetNaviVolAttenuationLevel(tU8& VolStep, tS16& dB)
  {
    const dBCalculator* pCalc = _config.pGetDBCalculator(AUD_INT_SRC_NAVI);
    if (NULL == pCalc)
      {
  ETG_TRACE_USR2(("AttenuationFilter::pCalc NULL"))
    return;
      }

    VolStep = u8GetStreamCurrentVolumeStep(EN_AUDIO_SOURCE_STREAM_MAIN);

    // calculate limited dB-value for amplifier
    dB  = pCalc->s16GetdBValue(VolStep, EN_AUDIO_SOURCE_STREAM_MAIN);

    ETG_TRACE_USR2(("AttenuationFilter::Calculated Navi Attenuation dB Level : %d", dB))
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vGetSPIDuckingVolAttenuationLevel(tU8& VolStep, tS16& dB)
  {
    // establish preconditions
    Stream*    pMainStream = _streamSet.pGetStream(EN_AUDIO_SOURCE_STREAM_MAIN);
    if (NULL == pMainStream)
      {
  ETG_TRACE_FATAL(("AttenuationFilter::vSetAmplifierVolume() - E R R O R : could not locate MAIN stream"))
     return ;
      }

    VolStep = u8GetStreamCurrentVolumeStep(EN_AUDIO_SOURCE_STREAM_MAIN);
    const dBCalculator* pCalc = _config.pGetDBCalculator(pMainStream->enGetCurrentSource());
    if (NULL == pCalc)
      {
  ETG_TRACE_ERR(("AttenuationFilter::vSetAmplifierVolume() - E R R O R : could not locate dB-calculator for active source %u on MAIN stream"
      , ETG_CENUM(tenInternalSource, pMainStream->enGetCurrentSource())))
     return ;
      }

    //Special Handling for PSA External Amplifier
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
    if ((_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1) && (_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2))
      {
         dB  = -165;
      }
    else
      {
          // calculate limited dB-value for amplifier
          dB  = pCalc->s16GetdBValue(VolStep, pMainStream->enGetStreamID());
          if (dB > _s16SPIDuckingVolAttenuationLevel)
            {
                dB = _s16SPIDuckingVolAttenuationLevel;
            }
      }
#else
    // calculate limited dB-value for amplifier
    dB  = pCalc->s16GetdBValue(VolStep, pMainStream->enGetStreamID());

    if (dB > _s16SPIDuckingVolAttenuationLevel)
      {
        dB = _s16SPIDuckingVolAttenuationLevel;
      }
#endif

    ETG_TRACE_USR2(("AttenuationFilter::Calculated SPI Ducking dB Level : %d", dB))
  }

  // -----------------------------------------------------------------------------
  tS16 AttenuationFilter::vGetCANAttenuationLevel(tU8 CurrentVolstep, Stream* pStream)
  {
  tS16 dB = MUTE;
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
  ETG_TRACE_USR2(("AttenuationFilter::CANAttenuation active --> Computing CANAttenuation Level for %d Stream", pStream->enGetStreamID()))
  const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());
  if (NULL == pCalc)
    {
      ETG_TRACE_ERR(("AttenuationFilter::vSetAmplifierVolume() - E R R O R : could not locate dB-calculator for active source %u on stream"
    , ETG_CENUM(tenInternalSource, pStream->enGetCurrentSource())))
          return 0;
    }

  // calculate limited dB-value for amplifier
  dB  = pCalc->s16GetdBValue(CurrentVolstep, pStream->enGetStreamID());

  dB = dB + (_s16AttenuationValue/dBCalculator:: dBStepMultiplicator);
  if(dB <= MAX_DB)
  {
    dB = MAX_DB;
  }
  ETG_TRACE_USR2(("AttenuationFilter::Calculated CAN Attenuation dB Level : %d", dB))
#else
    //Get Cluster Sound Level
    tU8 StepVal = u8GetClusterSoundLevel();

    ETG_TRACE_USR2(("AttenuationFilter::ClusterSoundLevel : %d", StepVal))

    // Better to set current Volume value in the stream in case of Error
    if(StepVal == UNDEF_VALUE)
      StepVal = CurrentVolstep;

    //Get Corresponding dB Level
    if(pStream)
      {
  const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());

  if(StepVal < CurrentVolstep)
    {
      if(pCalc)
        {
    dB  = pCalc->s16GetdBValue(StepVal, EN_AUDIO_SOURCE_STREAM_MAIN);
    ETG_TRACE_USR2(("AttenuationFilter::Calculated CAN Attenuation dB Level : %d", dB))
        }
    }
  else
    {
      ETG_TRACE_USR2(("AttenuationFilter::CAN Attenuation Level more than Current Volume... No Reduction..."))
    }
      }
#endif

    _properties.vSetCANAttenuationLevel(dB);
    return dB;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndAttenuateMainStreamVolumeLevel()
  {
    vector<tS16> dBvector;
    dBvector.clear();
    Stream*    pStream = _streamSet.pGetStream(EN_AUDIO_SOURCE_STREAM_MAIN);

    if(NULL == pStream)
      return;

    //Special Handling for E-CALL. E-CALL volume should not be attenuated on any case.
    if( pStream->enGetCurrentSource() == AUD_INT_SRC_TCU_ECALL)
      {
  ETG_TRACE_USR2(("AttenuationFilter::Volume should not be attenuated for E-Call. Exiting Computation......"))
             return;
      }

    tU8 currentEntVolumeStep = u8GetStreamCurrentVolumeStep(EN_AUDIO_SOURCE_STREAM_MAIN);;

    ETG_TRACE_USR2(("AttenuationFilter::Computing Attenuation Levels for Main Stream"))

    //If Navi Active get the corresponding attenuation value
    // Generalizing flag to mix1
    //
    if(bIsMix1SrcActive() || bIsFAPAttenuationActive())
      {
  if(affectsVolumeGroup(u8GetActiveSourceTypeInStream(EN_AUDIO_SOURCE_STREAM_MAIN))) //Only for Allowed Source Groups Attenuation should be applied.
    {
      vComputeAndPushNaviAttenuationLevel(dBvector, currentEntVolumeStep);
    }
  else
    {
      //Special case. When NonEntertainment source is active and CAN attenuation stops, restore the original volume.
      if(pStream->enGetCurrentSource() != pStream->enGetRecentEntertainmentSource() && !bCheckAttenuationViaCANactive())
        {
    vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
        }
    }
      }

    //If SPIDucking Active get the corresponding attenuation value
    if(bIsSPIDuckingActive())
    {
      if(_enDuckingActive == EN_INT_SPI_DUCK) //Carplay Ducking
      {
        if (pStream->enGetCurrentSource() != AUD_INT_SRC_TCU_ECALL) // SPIDucking allowed for all source expect ECALL.[CarPlay]
        {
          vComputeAndPushSPIDuckingAttenuationLevel(dBvector, currentEntVolumeStep);
        }
        else
        {
          //Special case. When NonEntertainment source is active and CAN attenuation stops, restore the original volume.
          if(pStream->enGetCurrentSource() != pStream->enGetRecentEntertainmentSource() && !bCheckAttenuationViaCANactive())
          {
            vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
          }
        }
      }

      if(_enDuckingActive == EN_INT_SPI_NATIVE_DUCK)  //AAP Ducking
      {
        if(affectsVolumeGroup(u8GetActiveSourceTypeInStream(EN_AUDIO_SOURCE_STREAM_MAIN))) //Only for Allowed Source Groups Attenuation should be applied.
        {
          vComputeAndPushNaviAttenuationLevel(dBvector, currentEntVolumeStep);
        }
        else
        {
          //Special case. When NonEntertainment source is active and CAN attenuation stops, restore the original volume.
          if(pStream->enGetCurrentSource() != pStream->enGetRecentEntertainmentSource() && !bCheckAttenuationViaCANactive())
          {
            vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
          }
        }
      }
    }
    //If CAN Attenuation is Active get the corresponding attenuation value
    if(bIsCANAttenuationActive())
      {
  vComputeAndPushCANAttenuationLevel(dBvector, currentEntVolumeStep, pStream);
      }

    //If ADASBeep is Active get the corresponding attenuation value
    if(bIsADASBeepsActive())
      {
  vComputeAndPushADASBeepAttenuationLevel(dBvector, currentEntVolumeStep, pStream);
      }

    if(!dBvector.empty())
      {
  //Fetch the lowest attenuation value and send the dbvalue to ADR3.
  sort(dBvector.begin(), dBvector.end());
  _s16MainStreamAttenuationdBvalue = dBvector.front();

  ETG_TRACE_USR2(("AttenuationFilter::Final Computed dBlevel for Main Stream Attenuation : %d", _s16MainStreamAttenuationdBvalue))


#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
    if ((_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1) && (_u8soundConfig != (tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2))
      {
            AmpVolumeData AmpData;
            AmpData.m_enStream = EN_AUDIO_SOURCE_STREAM_MAIN;
            AmpData.m_VolStep  = currentEntVolumeStep;
            AmpData.m_VoldB    = _s16MainStreamAttenuationdBvalue; // dB = -165; Hardcoded.. PSA expects this value to do ducking if External amplifier is connected.
            Ramp ramp          = _streamSet.queryRamp(EN_AUDIO_FADING_NOTIFY_CHG_VOL, EN_AUDIO_FADING_RES_USR, AmpData.m_enStream);
            AmpData.m_RampLin = ramp.lin;
            AmpData.m_RampdB = ramp.dB;
            VolumeManager::vLaunchAmplifierCommand(AmpData);
      }
    else
      {
            pStream->vSetStreamAttenuationlevel(_s16MainStreamAttenuationdBvalue);
            vSetAmplifierVolume (currentEntVolumeStep, _s16MainStreamAttenuationdBvalue, EN_AUDIO_SOURCE_STREAM_MAIN);
      }
#else
            pStream->vSetStreamAttenuationlevel(_s16MainStreamAttenuationdBvalue);
            if(_properties.bIsExtAmpConnected())
              vSetPremium2AmplifierVolume (currentEntVolumeStep, _s16MainStreamAttenuationdBvalue);
            else
                vSetAmplifierVolume (currentEntVolumeStep, _s16MainStreamAttenuationdBvalue, EN_AUDIO_SOURCE_STREAM_MAIN);
#endif


      }
    else
      {
            ETG_TRACE_USR2(("AttenuationFilter::No Attenuation to be Set for Main Stream. Setting Current Volume....."))
            const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());

            tS16 dB = MUTE;
            vResetAttenuationDBLevelOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
            if(pCalc)
                dB  = pCalc->s16GetdBValue(currentEntVolumeStep, EN_AUDIO_SOURCE_STREAM_MAIN);
            vSetAmplifierVolume (currentEntVolumeStep, dB, EN_AUDIO_SOURCE_STREAM_MAIN);
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndAttenuateMix1StreamVolumeLevel()
  {
    tU8 Mix1StreamVol = MUTE;
    vector<tS16> dBvector;
    dBvector.clear();
    Mix1StreamVol = u8GetStreamCurrentVolumeStep(EN_AUDIO_SOURCE_STREAM_MIX1);
    Stream*    pStream = _streamSet.pGetStream(EN_AUDIO_SOURCE_STREAM_MIX1);

    if(NULL == pStream)
      return;

    if(bIsMix1SrcActive() || bIsFAPAttenuationActive())
      {
  //If CAN Attenuation is Active get the corresponding attenuation value
  if(bIsCANAttenuationActive())
    {
      vComputeAndPushCANAttenuationLevel(dBvector, Mix1StreamVol, pStream);
    }

  //If ADASBeep is Active get the corresponding attenuation value
  if(bIsADASBeepsActive())
    {
      vComputeAndPushADASBeepAttenuationLevel(dBvector, Mix1StreamVol, pStream);
    }

  if(!dBvector.empty())
    {
      //Fetch the lowest attenuation value and send the dbvalue to ADR3.
      sort(dBvector.begin(), dBvector.end());
      _s16Mix1StreamAttenuationdBvalue = dBvector.front();
      pStream->vSetStreamAttenuationlevel(_s16Mix1StreamAttenuationdBvalue);
      ETG_TRACE_USR2(("AttenuationFilter::Final Computed dBlevel for Mix1 Stream Attenuation : %d", _s16Mix1StreamAttenuationdBvalue))
      vSetAmplifierVolume(Mix1StreamVol,_s16Mix1StreamAttenuationdBvalue, EN_AUDIO_SOURCE_STREAM_MIX1);
    }
      }
    else
      {
  vResetAttenuationDBLevelOnStream(EN_AUDIO_SOURCE_STREAM_MIX1);
  ETG_TRACE_USR2(("AttenuationFilter::MIX1 Stream not active. Hence No Attenuation done."))
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndAttenuateMix2StreamVolumeLevel()
  {
    tU8 Mix2StreamVol = MUTE;
    vector<tS16> dBvector;
    dBvector.clear();
    Mix2StreamVol = u8GetStreamCurrentVolumeStep(EN_AUDIO_SOURCE_STREAM_MIX2);
    Stream*    pStream = _streamSet.pGetStream(EN_AUDIO_SOURCE_STREAM_MIX2);

    if(NULL == pStream)
      return;

    if(bIsSPISrcActive())
      {
  //If CAN Attenuation is Active get the corresponding attenuation value
  if(bIsCANAttenuationActive())
    {
      vComputeAndPushCANAttenuationLevel(dBvector, Mix2StreamVol, pStream);
    }

  //If ADASBeep is Active get the corresponding attenuation value
  if(bIsADASBeepsActive())
    {
      vComputeAndPushADASBeepAttenuationLevel(dBvector, Mix2StreamVol, pStream);
    }

  if(!dBvector.empty())
    {
      //Fetch the lowest attenuation value and send the dbvalue to ADR3.
      sort(dBvector.begin(), dBvector.end());
      _s16Mix2StreamAttenuationdBvalue = dBvector.front();
      pStream->vSetStreamAttenuationlevel(_s16Mix2StreamAttenuationdBvalue);
      ETG_TRACE_USR2(("AttenuationFilter::Final Computed dBlevel for Mix2 Stream Attenuation : %d", _s16Mix2StreamAttenuationdBvalue))
      vSetAmplifierVolume(Mix2StreamVol,_s16Mix2StreamAttenuationdBvalue, EN_AUDIO_SOURCE_STREAM_MIX2);
    }
      }
    else
      {
  vResetAttenuationDBLevelOnStream(EN_AUDIO_SOURCE_STREAM_MIX2);
  ETG_TRACE_USR2(("AttenuationFilter::MIX2 Stream not active. Hence No Attenuation done."))
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndPushNaviAttenuationLevel(vector<tS16>& dBvector, tU8 currentEntVolumeStep)
  {

    ETG_TRACE_USR2(("AttenuationFilter::NavSource active --> Computing Nav Attenuation Level for Main Stream"))
      tS16 NavdbAttenuationvalue = MUTE;
    vGetNaviVolAttenuationLevel(currentEntVolumeStep, NavdbAttenuationvalue);

    if(NavdbAttenuationvalue != MUTE)
      dBvector.push_back(NavdbAttenuationvalue);

  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndPushSPIDuckingAttenuationLevel(vector<tS16>& dBvector, tU8 currentEntVolumeStep)
  {

    ETG_TRACE_USR2(("AttenuationFilter::SPIDucking active --> Computing SPIDucking Level  for Main Stream"))
      tS16 SPIdbAttenuationvalue = MUTE;
    vGetSPIDuckingVolAttenuationLevel(currentEntVolumeStep, SPIdbAttenuationvalue);

    if(SPIdbAttenuationvalue != MUTE)
      dBvector.push_back(SPIdbAttenuationvalue);

  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndPushCANAttenuationLevel(vector<tS16>& dBvector,tU8 Volstep, Stream* pStream)
  {
    ETG_TRACE_USR2(("AttenuationFilter::CANAttenuation active --> Computing CANAttenuation Level for Main Stream"))

    if(pStream)
      {
         tS16 CANAttenVal = vGetCANAttenuationLevel(Volstep, pStream);
         if(CANAttenVal != MUTE)
         {
            pStream->vSetCANAttenuationActive();
            dBvector.push_back(CANAttenVal);
         }
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vComputeAndPushADASBeepAttenuationLevel(vector<tS16>& dBvector,tU8 Volstep, Stream* pStream)
  {
    //Get Corresponding dB Level
    if(pStream == NULL)
      return;

    ETG_TRACE_USR2(("AttenuationFilter::ADASBeep active --> Computing ADASBeep Attenuation Level for %d Stream", pStream->enGetStreamID()));

    const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());
    tS16 db = MUTE;

    if(pCalc)
      db  = pCalc->s16GetdBValue(Volstep, EN_AUDIO_SOURCE_STREAM_MAIN);

    if(db > _s16AdasBeepVolume)
      {
  dBvector.push_back(_s16AdasBeepVolume);
  ETG_TRACE_USR2(("AttenuationFilter::Calculated ADASBeep Attenuation Level : %d", db));
      }
    else
      ETG_TRACE_USR2(("AttenuationFilter::ADAS Attenuation Level more than current volume in %d stream", pStream->enGetStreamID()));
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vCheckAndSetActiveStream()
  {
    if(bIsMix1SrcActive())
      {
  vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MIX1);
      }
    else if(bIsSPIDuckingActive())
      {
  vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MIX2);
      }
    else
      {
  vSetActiveStreamAndParameters(EN_AUDIO_SOURCE_STREAM_MAIN);
      }
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vSetActiveStreamAndParameters(tenStream instream)
  {
    Stream*    pStream = _streamSet.pGetStream(instream);
    if(pStream)
      {
  _streamSet.vSetActiveStream(instream);
  tenVolumeMode enMode = pStream->enGetCurrentMode();
  tenStream enStreamID = pStream->enGetStreamID();

  _properties.vUpdateMode(enMode, enStreamID, _streamSet.enGetResource());
  const SourceConfig* pSourceCfg = _config.pGetSourceConfig(pStream->enGetCurrentSource());
  if(NULL != pSourceCfg)
    {
      _properties.vSetCurrentSource(*pSourceCfg,pStream->enGetResource());
    }
  _properties.NotifyAllUpdates();
      }
    else
      ETG_TRACE_FATAL(("AttenuationFilter::pStream NULL"))
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bCheckIfAttenuationStillRequiredOnMainStream()
  {
    tBool RetVal = false;

    if( bIsMix1SrcActive() || bIsSPIDuckingActive() || bCheckAttenuationViaCANactive() || bIsFAPAttenuationActive() )
      {
  RetVal = true;
      }

    //Clear Attenuation Active Flag if Attenuation Via CAN/ADAS beeps are active.
    if(!bCheckAttenuationViaCANactive())
      {
  Stream*    pStream = _streamSet.pGetStream(EN_AUDIO_SOURCE_STREAM_MAIN);
  if(pStream)
    pStream->vClearCANAttenuationActive();
      }

    ETG_TRACE_USR2(("AttenuationFilter::bCheckIfAttenuationStillRequiredOnMainStream() : %d", RetVal))
    return RetVal;
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bCheckIfAttenuationStillRequiredOnMixStreams()
  {
    tBool RetVal = false;

    if(_bCANAttenuationActiveFlag == true || _bADASAttenuationActiveFlag == true)
      {
  RetVal = true;
      }

    ETG_TRACE_USR2(("AttenuationFilter::bCheckIfAttenuationStillRequiredOnMixStreams() : %d", RetVal))
    return RetVal;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vRestorePreviousvolumeOnStream(tenStream inStream)
  {
    ETG_TRACE_USR2(("AttenuationFilter::Restoring Volume on Stream : %d", ETG_CENUM(tenStream,inStream)))
              Stream*    pStream = _streamSet.pGetStream(inStream);
    tU8 VolStep = 0;

    vResetAttenuationDBLevelOnStream(inStream);

    if(NULL == pStream)
      {
  ETG_TRACE_FATAL(("AttenuationFilter::Main Stream NULL"))
          return;
      }

    // for reset, use calculator of source in dependent stream
    const dBCalculator* pCalc = _config.pGetDBCalculator(pStream->enGetCurrentSource());

    if (pCalc)
      {
  VolStep = u8GetStreamCurrentVolumeStep(inStream);

  ETG_TRACE_USR4(("AttenuationFilter::Re-setting previous volume to %u for source %u"
      , VolStep, ETG_CENUM(tenInternalSource, pStream->enGetCurrentSource())))

  Ramp ramp = _streamSet.queryRamp(EN_AUDIO_FADING_NOTIFY_CHG_VOL, EN_AUDIO_FADING_RES_SOURCESEL,
           pStream->enGetStreamID());
  pStream->setVolume(*pCalc, VolStep, ramp);

  if(_streamSet.enGetActiveStreamID() == inStream)
    {
      const SourceConfig* pSecondarySource = _config.pGetSourceConfig(pStream->enGetCurrentSource());
      if(NULL != pSecondarySource)
        {
    _properties.vSetCurrentSource(*pSecondarySource,pStream->enGetResource());
        }
      _properties.NotifyAllUpdates();
    }
      }
    else
      {
  ETG_TRACE_ERR(("AttenuationFilter::vRestorePreviousvolume() -  E R R O R :  invalid configuration for dependent source %u"
      , ETG_CENUM(tenInternalSource, pStream->enGetCurrentSource())))
      }
  }

  // -----------------------------------------------------------------------------
  tU8  AttenuationFilter::u8GetStreamCurrentVolumeStep(tenStream InStream)
  {
    Stream*    pStream = _streamSet.pGetStream(InStream);
    tU8 StreamVolStep = 0;
    if(pStream)
      {
  if(pStream->enGetCurrentSource() == AUD_INT_SRC_FM_TA || pStream->enGetCurrentSource() == AUD_INT_SRC_DAB_TA)
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_TA_DAN
      const tU8* pEntVolume  = _properties.pGetVolume(pStream->enGetResource(), midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT);

      if(pEntVolume)
        StreamVolStep = (tU8)(*pEntVolume + _properties.s8GetDanValue()); //gen4 prio3 warning fix
#else
      const tU8* pTAVolume  = _properties.pGetVolume(pStream->enGetResource(), midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_TASETUP);
      if(pTAVolume)
        StreamVolStep = *pTAVolume;
#endif

      ETG_TRACE_USR4(("AttenuationFilter::Current VolumeStep : %d for Src in Stream : %d"
    , StreamVolStep, ETG_CENUM(tenInternalSource, pStream->enGetCurrentSource())))
    }
  else
    {
      tU8 sourceType = u8GetActiveSourceTypeInStream(InStream);

      const tU8* pVolume = _properties.pGetVolume(_streamSet.enGetResource(), sourceType);
      if (NULL == pVolume)
        {
    ETG_TRACE_ERR(("AttenuationFilter::No Volume for sourcetype %d Found", sourceType))
             return 0;
        }

      StreamVolStep = *pVolume;
      ETG_TRACE_USR2(("AttenuationFilter::Current VolumeStep : %d for Src in Stream : %d", StreamVolStep, ETG_CENUM(tenStream,InStream)))
    }
      }
    return StreamVolStep;
  }

  // -----------------------------------------------------------------------------
  tU8 AttenuationFilter::u8GetActiveSourceTypeInStream(tenStream InStream)
  {
    // establish preconditions
    Stream*    pStream = _streamSet.pGetStream(InStream);
    if (NULL == pStream)
      {
  ETG_TRACE_FATAL(("AttenuationFilter::vSetAmplifierVolume() - E R R O R : could not locate %d stream",
      ETG_CENUM(tenStream,InStream)))
     return UNDEF_VALUE;
      }
    // query current dependent volume from property store
    const SourceConfig* pSourceCfg = _config.pGetSourceConfig(pStream->enGetCurrentSource());
    if (NULL == pSourceCfg)
      {
  ETG_TRACE_ERR(("AttenuationFilter::No pSourceCfg for %d Found",
      ETG_CENUM(tenInternalSource,pStream->enGetCurrentSource())));
  return UNDEF_VALUE;
      }

    tU8 sourceType = pSourceCfg->u8GetGroupType();

    return sourceType;
  }
  // -----------------------------------------------------------------------------
  void AttenuationFilter::vCheckAndRestoreVolumeLevels()
  {

    //For Main stream
    if(bCheckIfAttenuationStillRequiredOnMainStream())
      {
  vComputeAndAttenuateMainStreamVolumeLevel();
      }
    else
      {
  vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MAIN);
      }

    //For MIX1 stream
    if(bIsMix1SrcActive())
      {
  if(bCheckIfAttenuationStillRequiredOnMixStreams())
    {
      vComputeAndAttenuateMix1StreamVolumeLevel();
    }
  else
    {
      vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MIX1);
    }
      }

    //For MIX2 stream
    if(bIsSPISrcActive())
      {
  if(bCheckIfAttenuationStillRequiredOnMixStreams())
    {
      vComputeAndAttenuateMix2StreamVolumeLevel();
    }
  else
    {
      vRestorePreviousvolumeOnStream(EN_AUDIO_SOURCE_STREAM_MIX2);
    }
      }
  }

  // -----------------------------------------------------------------------------
  tU8 AttenuationFilter::u8GetClusterSoundLevel() const
  {
    tU8 u8ClusterSndLvl = UNDEF_VALUE ;

    //Read EOL Cluster_Sound_Level from KDS
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ClusterSoundLevel", &u8ClusterSndLvl, 1)))
      {
  ETG_TRACE_USR4((" EOL ClusterSoundLevel: %d",u8ClusterSndLvl));
      }
    else
      {
  ETG_TRACE_ERR(("AttenuationFilter::Error in reading EOL ClusterSoundLevel Parameter"));
      }

    return u8ClusterSndLvl;
  }

  // -----------------------------------------------------------------------------
  tU8 AttenuationFilter:: u8GetCalculatedTargetStep (const VolumeData& data, tU8 currentVol)
  {
    // determine intended volume according to change direction
    switch (data.m_VolumeType.getVolumeType())
    {
      case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_ABS:
  return data.m_Volume;

      case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_INC:
  return (tS16)(currentVol + data.m_Volume) <= 255 ? static_cast<tU8>(currentVol + data.m_Volume) : 255;

      case midw_fi_tcl_e8_AudioVolumeType::FI_EN_AUDIO_VAL_TYPE_DEC:
  return (tS16)(currentVol - data.m_Volume) >= 0 ? static_cast<tU8>(currentVol - data.m_Volume) : 0;

      default:
  ETG_TRACE_ERR(("AttenuationFilter::undefined change direction: leaving current volume %u untouched ..."
      , currentVol))

      ETG_TRACE_USR2(("AttenuationFilter:: CurrentVolume : %d", currentVol))
      return currentVol;  // skip further processing
    }
  }

  // -----------------------------------------------------------------------------
  tS16 AttenuationFilter::s16GetAttenuatedDbLevel(tenStream StreamId)
  {
    tS16 dbLevel = MUTE;

    switch(StreamId)
    {
      case EN_AUDIO_SOURCE_STREAM_MAIN:
  dbLevel = _s16MainStreamAttenuationdBvalue;
  break;
      case EN_AUDIO_SOURCE_STREAM_MIX1:
  dbLevel = _s16Mix1StreamAttenuationdBvalue;
  break;
      case EN_AUDIO_SOURCE_STREAM_MIX2:
  dbLevel = _s16Mix2StreamAttenuationdBvalue;
  break;
      default:
  break;
    }

    ETG_TRACE_USR2(("AttenuationFilter:: s16GetAttenuatedDbLevel returning Attenuated DbLevel : %d on Stream : %d", dbLevel,  ETG_CENUM(tenStream,StreamId)))
    return dbLevel;
  }

  // -----------------------------------------------------------------------------
  tU8 AttenuationFilter::u8GetUPAEOLLevelOffset()
  {
    tU8 UPAEOLLevelOffset = 0; //EOL Offset Level

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","ParkingAidsUPAGain", &UPAEOLLevelOffset, 1)))
      {
  ETG_TRACE_USR4(("AttenuationFilter::ADAS_UPA_EOL Offset level: %d",UPAEOLLevelOffset));
      }
    else
      {
  ETG_TRACE_ERR(("AttenuationFilter::Error in reading EOL Parameter"));
      }

    return UPAEOLLevelOffset;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vApplyLimits(tU8& Step, const SourceConfig* pSrcConfig)
  {
    VolumeConstraints limits;
    if (pSrcConfig)
      limits = pSrcConfig->getVolumeLimits();

    if (Step < limits.minStep)
      {
  Step = limits.minStep;
      }
    else if (Step > limits.maxStep)
      {
  Step = limits.maxStep;
      }
  }

  // -----------------------------------------------------------------------------
  bool AttenuationFilter::bCheckAttenuationViaCANactive()
  {
    if( _bCANAttenuationActiveFlag  || _bADASAttenuationActiveFlag )
      return true;
    else
      return false;
  }

  // -----------------------------------------------------------------------------
  void AttenuationFilter::vResetAttenuationDBLevelOnStream(tenStream inStream)
  {
    switch(inStream)
    {
      case EN_AUDIO_SOURCE_STREAM_MAIN:
  _s16MainStreamAttenuationdBvalue = MUTE;
  break;
      case EN_AUDIO_SOURCE_STREAM_MIX1:
  _s16Mix1StreamAttenuationdBvalue = MUTE;
  break;
      case EN_AUDIO_SOURCE_STREAM_MIX2:
  _s16Mix2StreamAttenuationdBvalue = MUTE;
  break;
      default:
  break;
    }
  }
}  // namespace VolumeManager
