//
// VolumeManager/Engine/Engine.h   for sub-component VolumeManager
//
//
//  Created on: Jun 17, 2014
//      Author: Martin Koch, Fa. ESE
//

#include "config/dp/AudioUserDpIfSelect.h"
#if !defined(EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_)
#define EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_
//#ifndef OBSERVER_H_
//#define OBSERVER_H_

#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
class Fading_IF;
class midw_fi_tcl_Aud_VolumeStatusList;


namespace VolumeManager
{

   class StreamSet;
   class IAction;
   class ActionFactory;
   class IFunction;
   class PropertyStore;
   class SourceList;
   class Configuration;
   class PDCAttenuator;
   class HeatProtector;
   class SPIDuckingFilter;
   struct FunctionConfig;


   class Engine : private Uncopyable, public IF_MessageObserver<PO_MessageConfig::enID>
   {
      // capture all Volume-related PO-command messages
      //

      public:
         /* constructor */ Engine(PropertyStore& store, const Configuration& config, Fading_IF* pFader);
         virtual /* destructor */ ~Engine();

         // implement IF_MessageObserver
         virtual void MessageNotification(PO_MessageConfig::enID MsgId);

         bool bProcessListChange (const midw_fi_tcl_Aud_VolumeStatusList& List, tU8 Resource, tU16& u16Error);
         bool bProcessPDCCommand (midw_fi_tcl_e8_PDCAttenuation::tenType PDCAttenuationCommand, tU16& u16Error);
         bool bProcessPDCLevel (tU8 PDCAttenutionLevel, tU16& u16Error);
         bool bProcessOverTempReduction (bool downScaling_Active, tU8 reductionInterval, tU16& u16Error);
         void vApplyOnVolumeLimits ();
         void vResetToFactoryDefaults ();
         bool bIsAttenuationActive();
         // TTFis support
         void vHandleTTFisCommand (tU32 size, const tU8* pcu8Data);

      private:
         // Member variables
         PropertyStore&  _properties;
         const Configuration&  _config;
         Array<StreamSet>  _streamSets;
         IFunction**       _ppFunctions;
         PDCAttenuator*    _pPDCAttenuator;
         HeatProtector*    _pHeatProtector;
         SPIDuckingFilter* _pDuckingFilter;
         size_t            _functionCount;
         ActionFactory*    _pActionFactory;
         bool              _isAppStateNormal;
         bool              _bSPIDuckingActive;
         bool              _bCANAttenuationActiveFlag;
         bool              _bADASAttenuationActiveFlag;
         // Helper functions
         IFunction* createSpecialFunction (const FunctionConfig& functionCfg, unsigned streamSetIndex);
         bool bExecuteAction (IAction& action, tenResource enResource);
   };

}  //  namespace VolumeManager

//#endif // OBSERVER_H_
#endif // !defined(EA_F3E8E4C0_D3FB_4a06_AAED_B30D7CE1FCFB__INCLUDED_)
