
//
// VolumeManager/Engine/Actions/VolumeSetActionExtAmp.h
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//



// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#include "Volume/Types.h"  // implicitly links midw_fi alltypes.h and stl_pif.h vector
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "./ActionBase.h"
#include "./VolumeSetActionExtAmp.h"
// - - - - - - - - - - - - -

#include "Volume/Engine/Stream.h"
#include "Volume/Engine/StreamSet.h"
#include "Volume/Engine/Functions/IFunction.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Configuration/dBCalculator.h"
#include "Volume/Configuration/Configuration.h"
#include "Volume/PropertyStore.h"
#include "Volume/TypeConversions/Functions.h"

#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "InternalComponentCommunication/Messages/Volume/IDSetExtAmpVolume.h"

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/VolumeSetActionExtAmp.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */ VolumeSetActionExtAmp:: VolumeSetActionExtAmp (PropertyStore& properties, const Configuration& config
         , const VolumeData& data, tenFadingReason enReason)
      : ActionBase(properties, config)
      , _data(data)
      , _enMode(_properties.enGetMode())
      , _enReason(enReason)
   {
      ETG_TRACE_USR3(("VolumeSetActionExtAmp() invoked for reason %u while in mode %u with active source %u"
            , ETG_CENUM(tenFadingReason, _enReason), ETG_CENUM(tenVolumeMode, _enMode)
            , ETG_CENUM(tenInternalSource, _properties.enGetCurrentSource())))
      _data.printData();
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ VolumeSetActionExtAmp:: ~VolumeSetActionExtAmp ()
   {
      ETG_TRACE_USR4(("VolumeSetActionExtAmp() completed."))
   }

   // -----------------------------------------------------------------------------

   /* virtual */ void VolumeSetActionExtAmp:: vExecute (StreamSet& streamSet)
   {

     VolumeData data;
     data.m_Channel = _data.m_Channel;
     data.m_Resource = _data.m_Resource;
     data.m_Volume = _data.m_Volume;

    if (_properties.enGetCurrentSource() == AUD_INT_SRC_PHONE_VR)
    {
        data.m_VolumeGroup = EN_VOLTYPE_OFFBOARDSDS;
    } else
    {
        const SourceConfig* pSourceCfg = _config.pGetSourceConfig(_properties.enGetCurrentSource());
        if (pSourceCfg != NULL)   //coverity fix
        {
            data.m_VolumeGroup = (tenVolumeType) _properties.enGetExtAmpVolumegroup(pSourceCfg->u8GetGroupType());

        }
    }
     data.m_VolumeType.setVolumeType(_data.m_VolumeType.getVolumeType());

     ETG_TRACE_USR4(("VolumeStep : %d m_VolumeGroup : %d m_VolumeType : %d", data.m_Volume, data.m_VolumeGroup, data.m_VolumeType.getVolumeType()))

     IDSetExtAmpVolume outMsg(data);
     InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&outMsg);
     (void)streamSet;

   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager
