//
// VolumeManager/Engine/Actions/VolumeSetAction.h
//
//  Created on: Jul 3, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_27577BBD_F9CF_48ef_A0F1_0D99BF30196B__INCLUDED_)
#define EA_27577BBD_F9CF_48ef_A0F1_0D99BF30196B__INCLUDED_
//#ifndef VOLUMESETACTION_H_
//#define VOLUMESETACTION_H_


class VolumeData;


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Configuration;
   class SourceConfig;
   struct VolumeConstraints;
   // -----------------------------------------------------------------------------

   class VolumeSetAction  : public ActionBase
   {
   public:
      /* constructor */ VolumeSetAction (PropertyStore& properties, const Configuration& config
            , const VolumeData& data, tenFadingReason enReason);
      virtual /* destructor */ ~VolumeSetAction ();

      // IAction implementation
      virtual void vExecute (StreamSet& streamSet);

      static tenActions enGetFadingAction (tenFadingReason enReason);

   private:
      // member variables
      const VolumeData& _data;
      const tenVolumeMode _enMode;
      const tenFadingReason _enReason;
      tS8 s8Dan;
      // helper functions
      void vApply (StreamSet& streamSet, VolumeData& nextVolume);
      void vUpdate (const VolumeData& nextVolume, const SourceConfig* pSourceConfig);

      const SourceConfig* pGetTargetSourceConfig (const StreamSet& streamSet);
      tU8 u8GetCurrentVolume (const StreamSet& streamSet);
      tU8 u8GetCalculatedTargetStep (const VolumeData& data, tU8 currentVol);
      void vApplyLimits (VolumeData& nextVolume, const SourceConfig* pSourceConfig, tU8 currentVol);
    void vGetCalculatedDANValue(VolumeConstraints limits,const tU8 u8TargetVol);
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


//#endif /* VOLUMESETACTION_H_ */
#endif // !defined(EA_27577BBD_F9CF_48ef_A0F1_0D99BF30196B__INCLUDED_)
