//
// VolumeManager/Engine/Actions/SourceSwitchActionWhenMixActive.h
//
//  Created on: Oct 12, 2015
//      Author: rej1kor (RBEI/ECV2)
//

#if !defined(SOURCESWITCHACTION_MIX_H_)
#define SOURCESWITCHACTION_MIX_H_

class VolumeSourceData;

namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class SourceSwitchActionWhenMixActive  : public ActionBase
   {
      // Action to modify volumes of main stream sources when Mix is active.
      //

      public:
         /* constructor */  SourceSwitchActionWhenMixActive (PropertyStore& properties, const Configuration& config, const VolumeSourceData& data);
         virtual /* destructor */ ~SourceSwitchActionWhenMixActive ();

         // IAction implementation
         virtual void vExecute (StreamSet& streamSet);

      private:
         const VolumeSourceData& _data;
         tU8 u8CurSrcVolStep;
         tS16 s16GetCurrentVolumeDBLevel(StreamSet& streamSet, tU8 GrpType);
         tS16 s16GetDBLevelToADR(tenInternalSource InSource, tS16 CurVolStepDBLevel);
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager

#endif
