//
// VolumeManager/Engine/Actions/SourceSwitchAction.h
//
//  Created on: Jul 30, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_1B4FC4A4_ABDB_49c3_B070_FB1A4753C068__INCLUDED_)
#define EA_1B4FC4A4_ABDB_49c3_B070_FB1A4753C068__INCLUDED_
//#ifndef SOURCESWITCHACTION_H_
//#define SOURCESWITCHACTION_H_


class VolumeSourceData;

namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Configuration;
   class SourceConfig;
//   class PropertyStore;

   // -----------------------------------------------------------------------------

   class SourceSwitchAction  : public ActionBase
   {
   public:
      /* constructor */ SourceSwitchAction (PropertyStore& properties, const Configuration& config, const VolumeSourceData& data);
      virtual /* destructor */ ~SourceSwitchAction ();

      // IAction implementation
      virtual void vExecute (StreamSet& streamSet);

   private:
      // Member variables
      const tenInternalSource _enLastSource;
      const SourceConfig* _pNextSource;

      // helper functions
      void vUpdateProperties (StreamSet& streamSet);

      void vResetCurrentVolume (StreamSet& streamSet);
      void vRestoreRecentVolume (StreamSet& streamSet);
      void vSpecialHandlingForMIX2(StreamSet& streamSet);

   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager



//#endif /* SOURCESWITCHACTION_H_ */
#endif // !defined(EA_1B4FC4A4_ABDB_49c3_B070_FB1A4753C068__INCLUDED_)
