//
// VolumeManager/Engine/Actions/OnVolumeLimitAction.cpp
//
//  Created on: Sep 18, 2014
//      Author: Martin Koch, Fa. ESE
//


// framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

#include "Volume/Types.h"  // implicitly links <midw_fi_if.h> for alltypes.h and <stl_pif.h> for vector
#include "Volume/Utilities/Uncopyable.h"
#include "Volume/Utilities/Array.hpp"
#include "./IAction.h"
#include "./ActionBase.h"
#include "./ListChangeAction.h"
#include "./OnVolumeLimitAction.h"
// - - - - - - - - - - - - -

//include datapool files
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "Volume/Configuration/Configuration.h"
//#include "Volume/Engine/StreamSet.h"
#include "Volume/TypeConversions/Functions.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/PropertyStore.h"


//#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeData.h"

#include "fc_audiomanager_trace.h"
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/OnVolumeLimitAction.cpp.trc.h"



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   /* constructor */  OnVolumeLimitAction:: OnVolumeLimitAction (PropertyStore& properties, const Configuration& config)
      : ListChangeAction(properties, config, getLimitedList(properties, config))
   {
      ETG_TRACE_USR3(("OnVolumeLimitAction() invoked "))
   }

   // -----------------------------------------------------------------------------

   /* virtual destructor */ OnVolumeLimitAction:: ~OnVolumeLimitAction ()
   {

   }

   tU8 OnVolumeLimitAction::computeCurrentVolBasedOnMinAndMaxVolLimit(tU8 minlimitval, tU8 CurrentVol, tU8 limitval)
   {
     if (minlimitval > CurrentVol)
       return minlimitval;
     else if (limitval < CurrentVol)
       return limitval;
     return CurrentVol;
   }
   // -----------------------------------------------------------------------------

   /* static */ midw_fi_tcl_Aud_VolumeStatusList OnVolumeLimitAction:: getLimitedList (PropertyStore& properties, const Configuration& config)
   {
      // scan configured volume groups and compare referred OnVolumeLimit value
      // with current volume.
      //
      // If current value exceeds limits, limit is applied and limited value
      // is appended to the restriction list.
      //
      // Note: this function is used at a time the base class in not initialized properly,
      //       so defining it as non-static member instead of passing parameters is meaningless.
      //

      // provide return value
      midw_fi_tcl_Aud_VolumeStatusList list;

      const GroupConfig* pGroups = NULL;
      size_t numberOfGroups = 0;
      config.vGetSourceGroupConfigs(pGroups, numberOfGroups);
      if (NULL == pGroups)
      {
         ETG_TRACE_FATAL(("getLimitedList() - E R R O R  : group configuration not found"))
         return list;
      }

      // scan groups
      for (unsigned i = 0; i < numberOfGroups; ++i)
      {
         if ((NULL == pGroups[i].pOnVolLimits) && (pGroups[i].typeId != midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT))
            continue;   // no limit specified

         // obtain current (not necessarily active) volume
         const tU8* pCurrentVol = properties.pGetVolume(Speaker, pGroups[i].typeId);

         if (NULL == pCurrentVol)
           continue;

         tU8 CurrentVol = *pCurrentVol;  // start with current value

         tU8 limitval = 0;
         tU8 minlimitval=0;

#if defined VARIANT_S_FTR_ENABLE_FEAT_DP_MAXSTARTUPVOL
         dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
         if(pGroups[i].typeId == midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT)
           {
             limitvolume.s32GetData(limitval);
             ETG_TRACE_USR3(("Max on volume limit received from dp =%d ",limitval ))
           }
         else
           {
             const tU8* pLimitVol = properties.pGetVolume(Speaker, pGroups[i].pOnVolLimits->typeId);
             if(NULL == pLimitVol)
               continue;
             limitval = *pLimitVol;
           }
#elif defined VARIANT_S_FTR_ENABLE_FEAT_DP_MIN_MAX_STARTUPVOL
         dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
         dp_tclAudioManagerDPMinimumOnVolLimit limitvolume_min;  //minimum volume limit
         if(pGroups[i].typeId == midw_fi_tcl_e8_Aud_VolumeType::FI_EN_VOLUME_ENTERTAINMENT)
           {
             limitvolume.s32GetData(limitval);
             ETG_TRACE_USR3(("Max on volume limit received from dp =%d ",limitval ))
             limitvolume_min.s32GetData(minlimitval);            //minimum volume limit
             ETG_TRACE_USR3(("Min on volume limit received from dp =%d ",minlimitval ))
           }
         else
           {
             const tU8* pLimitVol = properties.pGetVolume(Speaker, pGroups[i].pOnVolLimits->typeId);
             if(NULL == pLimitVol)
               continue;

             limitval = *pLimitVol;
           }

#elif defined VARIANT_S_FTR_ENABLE_FEAT_EOL_MAXSTARTUPVOL
         tU8 u8MaxVolumeStartup;

         if (DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig", "MaxVolumeStartup", &u8MaxVolumeStartup, 1))
           {
             limitval = u8MaxVolumeStartup;
             ETG_TRACE_USR3(("limitval : %d", limitval))
           }
         else
           {
             const tU8* pLimitVol = properties.pGetVolume(Speaker, pGroups[i].pOnVolLimits->typeId);
             if(NULL == pLimitVol)
               continue;

             limitval = *pLimitVol;
           }
#else
         const tU8* pLimitVol = properties.pGetVolume(Speaker, pGroups[i].pOnVolLimits->typeId);
         if(NULL == pLimitVol)
           continue;

         limitval = *pLimitVol;
#endif

         ETG_TRACE_USR3(("Current volume before limiting  =%d ",CurrentVol));

     CurrentVol = computeCurrentVolBasedOnMinAndMaxVolLimit(minlimitval, CurrentVol, limitval);

         ETG_TRACE_USR3(("Current volume after limiting  =%d ",CurrentVol));

         // if not short-circuited to next loop element, append limited value to restriction list
         midw_fi_tcl_Aud_VolumeStatus listEntry;
         listEntry.AudVolumeType.enType = fiVolumeListEntry_Map::getFirst(pGroups[i].typeId);
         listEntry.Volume = CurrentVol;
         list.VolumeStatusList.push_back(listEntry);
         ETG_TRACE_USR3(("getLimitedList()  : group %u\tlimited to %u", listEntry.AudVolumeType.enType, listEntry.Volume))
      }

      ETG_TRACE_USR2(("getLimitedList() -   : %u of %u volume groups limited"
            , list.VolumeStatusList.size(), numberOfGroups))

      return list;
   }

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager
