//
// VolumeManager/Engine/Actions/ModeChangeAction.h
//
//  Created on: Sep 2, 2014
//      Author: Martin Koch, Fa. ESE
//


#if !defined(EA_7B403520_EFAD_475c_A75C_CFA1B9C52952__INCLUDED_)
#define EA_7B403520_EFAD_475c_A75C_CFA1B9C52952__INCLUDED_
//#ifndef MODECHANGEACTION_H_
//#define MODECHANGEACTION_H_


class VolumeModeData;


namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class Configuration;
   class StreamSet;

   // -----------------------------------------------------------------------------

   class ModeChangeAction  : public ActionBase
   {
      public:
         /* constructor */ ModeChangeAction (PropertyStore& properties, const Configuration& config, const VolumeModeData& modeData);
         virtual /* destructor */ ~ModeChangeAction ();

         // IAction implementation
         virtual void vExecute (StreamSet& streamSet);

      private:
         // Member variables
         const VolumeModeData& _modeData;

         // Helper functions
         bool bImpliesSourceChange();
         void vExecuteImplicitSourceChange(StreamSet& streamSet);
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager



//#endif /* MODECHANGEACTION_H_ */
#endif // !defined(EA_7B403520_EFAD_475c_A75C_CFA1B9C52952__INCLUDED_)
