//
// VolumeManager/Engine/Actions/ListChangeAction.h
//
//  Created on: Sep 18, 2014
//      Author: Martin Koch, Fa. ESE
//

#if !defined(EA_4CE261F6_F66D_4280_95E7_44C13D9F42DD__INCLUDED_)
#define EA_4CE261F6_F66D_4280_95E7_44C13D9F42DD__INCLUDED_
//#ifndef LISTCHANGEACTION_H_
//#define LISTCHANGEACTION_H_


class midw_fi_tcl_Aud_VolumeStatusList;



namespace VolumeManager
{

   // -----------------------------------------------------------------------------

   class ListChangeAction  : public ActionBase
   {
      // Action to modify volumes configured as persistent,
      // not necessarily active at the moment
      //
      // This action is normally used to process a CCA VolumeList.Set command,
      // but serves also as base class for the derived OnVolumeLimitAction
      //

      public:
         /* constructor */  ListChangeAction (PropertyStore& properties, const Configuration& config, const midw_fi_tcl_Aud_VolumeStatusList& volumeList);
         virtual /* destructor */ ~ListChangeAction ();

         // IAction implementation
         virtual void vExecute (StreamSet& streamSet);

      private:
         // member variables
         midw_fi_tcl_Aud_VolumeStatusList _volumeList;

         // Helper functions
         void vUpdateActiveSource (StreamSet& streamSet, tU8 volume);
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager


//#endif /* LISTCHANGEACTION_H_ */
#endif // !defined(EA_4CE261F6_F66D_4280_95E7_44C13D9F42DD__INCLUDED_)
