//
// VolumeManager/Engine/ActionFactory.h
//
// Factory class for volume modifying actions
//
//  Created on: Jul 4, 2014
//      Author: Martin Koch, Fa. ESEi
//


#if !defined(EA_5CE9CA6D_196C_4873_A6D2_7D29D703B473__INCLUDED_)
#define EA_5CE9CA6D_196C_4873_A6D2_7D29D703B473__INCLUDED_
//#ifndef ACTIONFACTORY_H_
//#define ACTIONFACTORY_H_

class VolumeData;
class VolumeSourceData;
class VolumeModeData;
class midw_fi_tcl_Aud_VolumeStatusList;


namespace VolumeManager
{
   class PropertyStore;
   class Configuration;
   class IAction;

   // -----------------------------------------------------------------------------

   class ActionFactory  :  private Uncopyable
   {
   public:
      /* constructor */ ActionFactory (PropertyStore& propertyStore, const Configuration& config);
      /* destructor */ ~ActionFactory();

      // factory functions
      IAction* getVolumeSetAction (const VolumeData& volumeData);
      IAction* getListChangeAction (const midw_fi_tcl_Aud_VolumeStatusList& volumeList);
      IAction* getModeChangeAction (const VolumeModeData& modeData);
      IAction* getSourceSwitchAction (const VolumeSourceData& sourceData);
      IAction* getSourceSwitchActionWhenMixActive (const VolumeSourceData& sourceData);
      IAction* getLockAction (tenVolumeLockRequester enRequester, tenVolumeLock enNewLockState);
      IAction* getOnVolumeLimitAction ();
      IAction* getVolumeSetActionExtAmp (const VolumeData& volumeData);
//      IAction* get...Action(...);

   private:
      PropertyStore&       _propertyStore;
      const Configuration& _config;
   };

   // -----------------------------------------------------------------------------

}  // namespace VolumeManager




//#endif /* ACTIONFACTORY_H_ */
#endif // !defined(EA_5CE9CA6D_196C_4873_A6D2_7D29D703B473__INCLUDED_)

