//
// VolumeManager/dBCalculator.h
//
//  calculate dB-values from user-step values for volume
//   use configurable lookup table
//
//  Created on: Jul 7, 2014
//      Author: Martin Koch, Fa. ESE
//


#if !defined(EA_3AB3FFC1_58EE_4811_8B01_F34258350942__INCLUDED_)
#define EA_3AB3FFC1_58EE_4811_8B01_F34258350942__INCLUDED_
//#ifndef DBCALCULATOR_H_
//#define DBCALCULATOR_H_


namespace VolumeManager
{

   // --------------------------------------------------------------------------

   struct  tDBTable
   {
      tU8  u8UserStep;
      tS16 s16Primary;  // dB
      tS16 s16Secondary; // dB (reduced entertainment volume during navigation announcement)
   };

   // --------------------------------------------------------------------------

   class dBCalculator  : private Uncopyable
   {
   private:
      tDBTable* _pDataFromXML; // table pointer obtained through constructor (delete this one on end)
      tDBTable* _pData;        // working table (may point to read-only data)
      size_t    _size;
      char*    _name;
      tenStream _secondaryStreamID;
      tenResource  _sink;

   public:
      /* constructor */ dBCalculator(tDBTable* pNewTable, unsigned u32TableRowCount, const char* name, tenStream secondaryStreamID, tenResource sink);
      /* default constructor */ dBCalculator();
      /* destructor */ ~dBCalculator();
      void swap(dBCalculator& rhs);

      // convert volume value given as user step to dB
      tS16 s16GetdBValue(tU8 u8UserStep, tenStream enStream) const;
      tU8  u8GetStepValue(tS16 dbValue) const;
      tU8  u8GetMinimumUserStep() const;
      tU8  u8GetMaximumUserStep() const;
      const char* sGetName() const;
      tU8  u8Calculate(tS16 db) const;
      tenStream enGetSecondaryStreamID() const;
      tenResource enGetSinkID() const;

      static const tS16 dBStepMultiplicator; // ADR3 is using 1/4 dB values, thus the defines of the system feature list need to be multiplied

   private:
      // helper for swap
      dBCalculator& /* assignment */ operator= (const dBCalculator& rhs);
   };


   // --------------------------------------------------------------------------


}   // namespace VolumeManager


//#endif /* DBCALCULATOR_H_ */
#endif // !defined(EA_3AB3FFC1_58EE_4811_8B01_F34258350942__INCLUDED_)

