//
// VolumeManager/Configuration/Configuration.h
//
// Provide configuration details for audio sources regarding
//    source grouping
//    persistence
//    min/max/default user-step constraints
//    related output stream,
//    calculation of dB-values forwarded to amplifier
// as defined in file "Configuration.xml"
//
//  Created on: Aug 1, 2014
//      Author: Martin Koch, Fa. ESE
//


#if !defined(EA_A2BB3CFA_D5D2_40ee_A161_91B55F17BEFA__INCLUDED_)
#define EA_A2BB3CFA_D5D2_40ee_A161_91B55F17BEFA__INCLUDED_
//#ifndef CONFIGURATION_H_
//#define CONFIGURATION_H_


#include "Volume/Utilities/Uncopyable.h"



namespace VolumeManager
{
   struct StreamSetConfig;
   struct StreamConfig;
   struct GroupConfig;
   struct FunctionConfig;
   struct VolumeConstraints;
   class SourceConfig;
   class dBCalculator;

   // --------------------------------------------------------------------------

   class Configuration  : private Uncopyable
   {
      public:

         // - - - - - - - - - - - - -

//         /* constructor */ Configuration (GroupConfig* pGroups, size_t numberOfGroups, SourceConfig* pSources, size_t numberOfSources);
         /* default constructor */ Configuration ();
         /* destructor */ ~Configuration ();

         size_t getStreamSetCount () const;
         size_t getStreamCount () const;
         size_t getSourceGroupCount () const;
         const StreamSetConfig* pGetStreamSetConfig (size_t index) const;
         const StreamConfig* pGetStreamConfig (size_t index) const;
//         static const StreamConfig& getDefaultStreamConfig ();
//         void vGetSourceConfigs (const SourceConfig*& ext_pSources, size_t& ext_NumberOfSources) const;
         const SourceConfig* pGetSourceConfig (tenInternalSource enSource) const;
         const dBCalculator* pGetDBCalculator (tenInternalSource enSource) const;

         const VolumeConstraints* pGetVolumeLimitsByGroup (tU8 u8GroupTypeId, bool requestPersistenceLimits = false) const;

         void vGetSourceGroupConfigs (const GroupConfig*& ext_pGroups, size_t& ext_NumberOfGroups) const;
         void pGetStreamSet (const StreamSetConfig*& StreamSet) const;

      private:
         dBCalculator*     _pCalculators;// array[]
         FunctionConfig*   _pFunctions;  // array[]
         StreamSetConfig*  _pSets;  // array[]
         StreamConfig*     _pStreams; // array[]
         const StreamConfig** _pStreamMap;  // array[]
         GroupConfig*      _pGroups;  // array[]
         SourceConfig*     _pSources; // array[]
         size_t            _calculatorCount;
         size_t            _functionCount;
         size_t            _setCount;
         size_t            _streamCount;
         size_t            _sourceCount;
         size_t            _sourceGroupCount;
   };

   // ==========================================================================

}

//#endif /* CONFIGURATION_H_ */
#endif // !defined(EA_A2BB3CFA_D5D2_40ee_A161_91B55F17BEFA__INCLUDED_)

