/**
* @file TuningDataServiceMessage.h
* @author CM-AI wie1hi
* @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
* @addtogroup fc_audiomanager
* @{
*/

#ifndef TUNINGDATASERVICEMESSAGE_H_
#define TUNINGDATASERVICEMESSAGE_H_

class TuningDataServiceMessage
{
public:
   tU16 preface;
   tU8  version;
   tU8  serviceID;
   tU32 dataLength;
   tU8* getData();

#define TUNING_DATA_SERVICE_MESSAGE_HEADER_SIZE \
   (sizeof(TuningDataServiceMessage::preface) + \
   sizeof(TuningDataServiceMessage::version) + \
   sizeof(TuningDataServiceMessage::serviceID) + \
   sizeof(TuningDataServiceMessage::dataLength))

   static size_t getHeaderSize();
   tBool allocDataMemory(tU32 length);

   /**
    * Free memory
    */
   tVoid free();

   TuningDataServiceMessage();
   ~TuningDataServiceMessage();
private:
   tU8* data;
   tU32 allocatedLength;
   TuningDataServiceMessage(const TuningDataServiceMessage &msg);
   TuningDataServiceMessage& operator = (const TuningDataServiceMessage& tdsm);

   tBool bCheckInvariant();
};


#endif /* TUNINGDATASERVICEMESSAGE_H_ */
