/************************************************************************
 * FILE:         SoundTool_TcpRxTx.cpp
 * PROJECT:      G3G
 * SW-COMPONENT: fc_audiomanager
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Receive thread for communication with DSPStudio client
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 *************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
// next one to get ahl stuff
#include "../fc_audiomanager_main.h"

#include "fc_audiomanager_componentfactory_if.h"
#include "SoundTool_TcpRxTx.h"
#include "SoundToolClient.h"

#include "vd_adr3_main.h"

// for TCP
//#include <stdlib.h>
#include <unistd.h>

#include <sys/socket.h>
#include <netinet/in.h>
//#include <stdio.h>
#include <string.h>
// end

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"

#include "../../fc_audiomanager_main.h"
#include "aud_sinkmgr_main.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SOUND_TOOL_CLIENT
#include "trcGenProj/Header/SoundTool_TcpRxTx.cpp.trc.h"
#endif

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------
//SoundToolClient*            SoundTool_TcpRxTx::m_SoundToolClient = NULL;
static tU8 m_u8recBuf[REC_BUF_SIZE];

/*************************************************************************
*
* FUNCTION:   SoundTool_TcpRxTx
*
* DESCRIPTION: Constructor
*              Keep pointer to SoundToolClient in member variable
*
*************************************************************************/
SoundTool_TcpRxTx::SoundTool_TcpRxTx(SoundToolClient* poSoundToolClient)
{
  //ETG_TRACE_USR4(("thread entered."));
  m_poSoundToolClient = poSoundToolClient;

  temp_sock_desc = 0;
  _hRxThreadId = OSAL_NULL;

}

/*************************************************************************
*
* FUNCTION:   ~SoundTool_TcpRxTx
*
* DESCRIPTION: Destructor
*
* PARAMETER:  None
*
* RETURNVALUE: None
*
*************************************************************************/

SoundTool_TcpRxTx::~SoundTool_TcpRxTx()
{
  m_poSoundToolClient = NULL;
}

void SoundTool_TcpRxTx::SocketSend(int size, tU8* pBuf)
{
#ifdef DEBUG_PRINT
    FILE* dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/SockSend.log","a");
    fprintf(dbg_write_ptr,"SocketSend size %d\n",size);

    for(int idx=0;idx<size;idx++)
    {
      fprintf(dbg_write_ptr,"0x%x, ",*(pBuf+idx));
      if( (idx>0) && (idx%20==0) ) fprintf(dbg_write_ptr,"\n");
    }
    fprintf(dbg_write_ptr,"\n");
    fclose(dbg_write_ptr);
#endif

  tLong k;
  if(temp_sock_desc != 0)
  {
    k= send(temp_sock_desc, pBuf, (size_t)size, 0);
    if(k == size)
    {
      //ETG_TRACE_USR4(("Send OK!"));
      et_vTraceBinary((int)TR_CLASS_FC_AUDIOMANAGER_SOUND_TOOL_CLIENT,(int)TR_LEVEL_USER_4,ET_EN_T8LIST,
          size, pBuf, ET_EN_DONE);

    }
  }
  else
  {
    ETG_TRACE_USR4(("No socket, temp_sock_desc == 0"));
  }
}

/*************************************************************************
*
* FUNCTION:   Thread entry function vStartThread
*
* DESCRIPTION: Needs to be a static
*
* PARAMETER:  Pointer to itself
*************************************************************************/
void SoundTool_TcpRxTx::vStartThread(tVoid* pvArg)
{
  if(pvArg != OSAL_NULL)
  {
    SoundTool_TcpRxTx* pSoundTool_TcpRxTx = reinterpret_cast<SoundTool_TcpRxTx*>(pvArg);
    // call the thread loop
    pSoundTool_TcpRxTx->SocketReceive();
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
}
/*************************************************************************
*
* FUNCTION:   Thread wroker function SocketReceive
*
* DESCRIPTION: Blocking Receive that waits for DSPStudio comands
*
* PARAMETER:  None
*
* RETURNVALUE: None
*
*************************************************************************/
void SoundTool_TcpRxTx::SocketReceive(tVoid)
{
  bool bLoop = true;
    //int sock_desc = (int)socket(AF_INET, SOCK_STREAM, 0);
  int sock_desc = (int)socket(AF_INET, SOCK_STREAM, 6); // 6 for IPPROTO_TCP
    if (sock_desc == -1)
    {
        //ETG_TRACE_ERR(("cannot create socket!"));
        return;
    }

#ifdef DEBUG_PRINT
    FILE* dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
    fprintf (dbg_write_ptr, "################ SoundTool_TcpRxTx::SocketReceive #############\n");
    fclose(dbg_write_ptr);
#endif

    struct sockaddr_in server;
    memset(&server, 0, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(SOUND_TOOL_PORT);
    if (bind(sock_desc, (struct sockaddr*)&server, sizeof(server)) != 0)
    {
#ifdef DEBUG_PRINT
        dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
        fprintf (dbg_write_ptr, "bind failed, closing socket\n");
        fclose(dbg_write_ptr);
#endif
        //ETG_TRACE_ERR(("cannot bind socket!"));
        close(sock_desc);
        return;
    }
#ifdef DEBUG_PRINT
    dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
    fprintf (dbg_write_ptr, "bind ok, now call listen\n");
    fclose(dbg_write_ptr);
#endif
    // listen on socket, max 20 connections allowed
    if (listen(sock_desc, 20) != 0)
    {
#ifdef DEBUG_PRINT
        dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
        fprintf (dbg_write_ptr, "listen failed\n");
        fclose(dbg_write_ptr);
#endif
        //ETG_TRACE_ERR(("cannot listen on socket!"));
        close(sock_desc);
        return;
    }

#ifdef DEBUG_PRINT
    dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
    fprintf (dbg_write_ptr, "listen ok, call accept\n");
    fclose(dbg_write_ptr);
#endif
    struct sockaddr_in client;
    memset(&client, 0, sizeof(client));
    socklen_t len = sizeof(client);

    // with this we can receive and send
    temp_sock_desc = accept(sock_desc, (struct sockaddr*)&client, &len);

    if (temp_sock_desc == -1)
    {
#ifdef DEBUG_PRINT
        dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
        fprintf (dbg_write_ptr, "accept failed\n");
        fclose(dbg_write_ptr);
#endif
#       //ETG_TRACE_ERR(("cannot accept client!"));
        close(sock_desc);
        return;
    }

    int k;
    unsigned int msgSize;
    tBool receiveAll;
    //OSAL_tMSecond tickcount;
    //tU32 timeout;
#ifdef DEBUG_PRINT
    dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
    fprintf (dbg_write_ptr, "no run recv loop...\n");
    fclose(dbg_write_ptr);
#endif
    // thread loop
    while(bLoop == true)
    {
      k=0;
      msgSize=0;

      //receive loop

      receiveAll=false;
      do //receive loop
      {
        // k is increased by received bytes
        k += (int)recv(temp_sock_desc, m_u8recBuf+k, (size_t)(REC_BUF_SIZE - k), 0);
        if( (k>1) && (msgSize==0) )
        {
          // at least two bytes to identify the coming size
          msgSize=m_u8recBuf[0]; //_H
          msgSize = msgSize<<8;
          msgSize = msgSize + m_u8recBuf[1]; //_L
          // can only be used if recv is set to non blocking
            //tickcount = OSAL_ClockGetElapsedTime();
            //timeout = tickcount+100;
        }
        // error conditions
        if(k == -1)
        {
          receiveAll=false;
          //ETG_TRACE_ERR(("cannot read from client!"));
          break;
        }
        else if(k == 0)
            {
          receiveAll=false;

          //ETG_TRACE_ERR(("client disconnected."));
          OSAL_s32ThreadWait(200);

          temp_sock_desc = accept(sock_desc, (struct sockaddr*)&client, &len);
            if (temp_sock_desc == -1)
            {
                //ETG_TRACE_ERR(("cannot accept client!"));
                close(sock_desc);
                return;
            }
                break;
            }
        else if((unsigned int)k >= msgSize)
        {
          receiveAll=true;
          break; //all Bytes received
        }

      } while(bLoop == true);
      //while(OSAL_ClockGetElapsedTime() < timeout); // a timeout should end

        if(receiveAll==true)
        {
          if(k>230) k=230;
      et_vTraceBinary((int)TR_CLASS_FC_AUDIOMANAGER_SOUND_TOOL_CLIENT,(int)TR_LEVEL_USER_4,ET_EN_T8LIST,
          k,m_u8recBuf, ET_EN_DONE);

#ifdef DEBUG_PRINT
        dbg_write_ptr = fopen("/var/opt/bosch/dynamic/ffs/Soundtool.log","a");
        fprintf (dbg_write_ptr, "exit loop, got %d bytes\n",k);
        fclose(dbg_write_ptr);
#endif
      m_poSoundToolClient->vRxTcp((tPCUChar)(m_u8recBuf));
        }
        else
        {
          //Msg not complete -> Error handling: sleep and go for another receive
      OSAL_s32ThreadWait(200);
        }

    } //while(1)
    // Lint will complain since next two lines can never be reached
    //close(temp_sock_desc);
    //close(sock_desc);

    //ETG_TRACE_ERR(("server disconnected"));
    //return;
}

/*************************************************************************
*
* FUNCTION:   setUpServer
*
* DESCRIPTION: Method to spawn the thread
*
* PARAMETER:  None
*
* RETURNVALUE: None
*
*************************************************************************/
int SoundTool_TcpRxTx::setUpServer()
{
  OSAL_trThreadAttribute  rAttr;
  tC8                     szThreadName[OSAL_C_U32_MAX_NAMELENGTH] = "";

  // Note:Maximum size of thread name limited to 8
  //tString tStrTemp = OSAL_szStringCopy( szThreadName, "Soundtool_RxTx");
  (void)OSAL_szStringCopy( szThreadName, "Soundtool_RxTx");
  //tStrTemp = tStrDummy;

  // Local variables to store data read from registry
  tU32 u32ThreadPrio = 0;
  tU32 u32StackSize  = 0;

  vGetThreadPrioandStacksize(u32ThreadPrio, u32StackSize);

  //ETG_TRACE_USR3(("vRxThreadSetup() ,u32ThreadPrio= %d,u32StackSize= %d",u32ThreadPrio,u32StackSize));

  // Initialize thread parameters
  rAttr.szName       = szThreadName;
  rAttr.s32StackSize = (tS32)u32StackSize;
  rAttr.u32Priority  = u32ThreadPrio;
  rAttr.pfEntry      = (OSAL_tpfThreadEntry)&SoundTool_TcpRxTx::vStartThread;
  rAttr.pvArg        = (tPVoid)this;

  _hRxThreadId = OSAL_ThreadSpawn(&rAttr);

  if ( _hRxThreadId == OSAL_ERROR )
  {
    tS32 s32OsalError = (tS32)OSAL_u32ErrorCode(  );
    ETG_TRACE_USR2(("setUpServer -> Thread spawn failed errorcode=%x" ,s32OsalError ));

  }
#if 0
  else
  {
    //ETG_TRACE_USR1(("SocketReceive ,OSAL_ThreadSpawn()-> Thread creation successful."));

  }
#endif
  return 0;


}


tVoid SoundTool_TcpRxTx::vGetThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const
{
  // check with vd_adr3_inc.cpp: it is also possible to have this config in registry
  // Assign default value.
  u32ThreadPrio = SOUNDTOOL_DEFAULT_PRIO;
  u32StackSize  = SOUNDTOOL_DEFAULT_STACKSIZE;

  // Indicate that the thread is running on default priority
  //ETG_TRACE_ERR(( "vGetThreadPrioandStacksize prio=%d, stack size=%d",u32ThreadPrio,u32StackSize));
}

// EOF
