/*******************************************************************************
 *
 * FILE:          SoundToolClient.h
 *
 * SW-COMPONENT:  SoundToolClient application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _SOUND_TOOL_CLIENT_H_
#define _SOUND_TOOL_CLIENT_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
//#define AHL_S_IMPORT_INTERFACE_GENERIC
//#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
//#include "ahl_if.h"

#include "../fc_audiomanager_trace_input.h"



/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*
*/
//typedef std::vector<PropertyIF_Base* > PropertyIF_BaseList;
//typedef std::vector<PropertyIF_Base*>::iterator PropertyIF_BaseIter;

#define SOUNDTOOL_SUCCESS  0x55
#define SOUNDTOOL_FAILURE  0xAA
// When splitting big messages (e.g. files we use an additional header)
// tU8 message code, needed to identify the message on PC side (TTFis dll)
// tU8 flag to mark that this message is splitted and this is one piece
// tU8 MsgCounter MSB we add a message counter then we are able to count messages and if wanted identify a loss
// tU8 MsgCounter LSB it can also be usefull for debugging on PC in TTFis dll when pieces are concatenated agai
//                The message counter will run from 1,2,...n
// tU8 4 Bytes size (MSB) Only the message with message counter 1 has the complete size inside
// tU8 4 Bytes size
// tU8 4 Bytes size
// tU8 4 Bytes size (LSB)
#define MSG_HEADER_WITH_SIZE   8 // 4 Byte size information
#define MSG_HEADER             4 // no size information, hence 4 byte smaller

//#define MSG_SPLIT_FLAG_OFFSET
//#define MSG_FILESIZE_OFFSET

#define MSG_FIRST_MSG        0x01
#define MSG_IS_SPLITTED      0x01

// the size that we use for one CSM message, can be increased later up to max. It seems that 239 is the max
#define MSG_SIZE_REPLY 200
//C_TRACE_MAX = 239 so we need to split also reply message and collect it on other side

//This file has to be present to allow soundtuning with Soundtool via socket connection. Without this we will not create a socket.
//This should prevent that we keep a socket open by default
#define SOUNDTOOL_ENABLE_FILE "/var/opt/bosch/static/audio/audiomanager/soundtool_enable.txt"
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

//class fc_audiomanager_tclApp;
//class fc_audiomanager_tclService_Audio_Function;
class SoundTool_TcpRxTx;

class SoundToolClient : public fc_audiomanager_tclTraceInput,
                        public fc_audiomanager_IClientHandler_Soundtool
{
public:
  //static SoundToolClient* m_poSoundToolClient;
  //static tBool bRegisterPropertyOwner(PropertyIF_Base* pPropertyIF_Base);

  //static SoundToolClient* getSoundToolClient();

  SoundToolClient(fc_audiomanager_tclApp* poMainAppl, fc_audiomanager_tclService_Audio_Function* poService);
  virtual ~SoundToolClient(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  tVoid vInit()const;
  static tVoid vOnApplicationClose();
  //tBool bRegisterPropertyOwner(PropertyIF_Base* pPropertyIF_Base);
  SoundToolClient* getSoundToolClient();

  /**************************************************************************
   *
   **************************************************************************/
   void vRxTcp(tPCUChar pcu8Data);

  // inbox for TTFis
  virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

private:
  static SoundTool_TcpRxTx*        m_poSoundTool_TcpRxTx;

  static SoundToolClient        *poSoundToolClient;
  static fc_audiomanager_tclApp *poCcaMainApp;

  fc_audiomanager_tclService_Audio_Function *poAudioService;

  // we should have a vector here for all Property Owners
  // and a iterator
//  std::vector<PropertyIF_Base*>::iterator m_pPropertyIF_BaseIter;


  tVoid handleSetConfigFile(tU32 size, tPCUChar pcu8Data)const;
  tVoid handleGetConfigFile(tU32 size, tPCUChar pcu8Data)const;
  // not used because Opcode SaveConfigFile (0x04) is not implemented
  // save will happen within the SetConfigFile (0x02) command
  //tVoid handleSaveConfigFile(tPCUChar pcu8Data);

  tVoid sendGetConfigFile(tU8 const* const pu8Data, tU16 u16Size)const;

  tS32 saveConfigFile(tU16 u16FileID)const;

  tVoid sendSetConfigFileStatus(tU8 u8Status)const;
  //tVoid sendSetPropertyStatus(tU8 u8Status)const;
  tU32 getTotalFileLength(tPCUChar pcu8Data)const;

  //tVoid handleGetPropertyListLength(tU8* pu8Data)const;
  tVoid handleGetPropertyListLength(tU32 size, tU8 const* const pu8Data)const;

  //tVoid sendGetPropertyDummy(tU8 u8PropertyID, tU8* pcu8Data);
  //tVoid sendGetProperty(tU8 u8PropertyID, tU8* pcu8Data, trPropertyData* pProperty)const;

  tVoid setSoundToolFlag(tU8 u8Command) const;
  tVoid removeSizeInDelayAndEqu(tU8* pu8Data, tS32& s32Size) const;
};

#endif //_SOUND_TOOL_CLIENT_H_

