/*******************************************************************************
 *
 * FILE:          SoundHandler.h
 *
 * SW-COMPONENT:  SoundHandler application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _SOUND_HANLDER_H_
#define _SOUND_HANLDER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
//#define AHL_S_IMPORT_INTERFACE_GENERIC
//#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
//#include <ahl_if.h>

#include "../fc_audiomanager_trace_input.h"

//#include "../../PostOffice/PostOffice.hpp"
#include "InternalCommunicationAdapter.h"
//#include "../../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"

#include "config/dp/AudioUserDpIfSelect.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*
*/

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;



class SoundHandler : public fc_audiomanager_tclTraceInput, public IF_MessageObserver<PO_MessageConfig::enID>
{

  static SoundHandler* m_poSoundHandler;
  static bool RemoteControlFlag;
public:
  SoundHandler(fc_audiomanager_tclApp* poMainAppl, fc_audiomanager_tclService_Audio_Function* poService);
  virtual ~SoundHandler(tVoid);

  /**************************************************************************
   *  methods.
   **************************************************************************/
  tVoid vInit()const;
  static tVoid vOnApplicationClose();

    tBool vCheckPropertyAvailablility(tS8& sPtyValue,tBool sPtyAvail);
    tVoid vOnLoadSettings();
    tVoid vOnLoadSettings(tU16 u16FunctionId);

   tBool bGetStatusMessage(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bProcessSet(tU16 u16FunctionID, fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);


  /**************************************************************************
   *
   **************************************************************************/
private:
   tBool bSetBass(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetTreble(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetBalance(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetFader(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetGala(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetAuxInLevel(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetBeepLevel(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetMidRange(fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetLoudness(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetDynamicCompression(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetEquPreset(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetOptimization(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetRoomEffect(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetRearMuteStatus(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
   tBool bSetGeometryModeStatus(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);

   tBool bSendAmpAvailStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendBassStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendMidRangeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendTrebleStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendBalanceStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
    tBool bSendLoudnessStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendFaderStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
    tBool bSendGalaStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendAuxInLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    tBool bSendBeepLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  tBool bSendDynamicCompressionStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendMeMSoundStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendOptimizationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendPDCAttenuationLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendPDCAttenuationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendEquPresetStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendRoomEffectStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendRearMuteStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendGeometryMode(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  tBool bSendDiagDefSetPhaseStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
    //below 3 functions are used only in A-IVI
  /***************************************************************************************************/
  tBool bSetFMEnhancer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSendFMEnhancerStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  tBool bSetSubWoofer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSetAutomaticGainControl(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSendAutomaticGainControlStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  tBool bSetAudioPilotMode(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSendAudioPilotModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;

  tBool bSetAudioPilotIntensity(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode);
  tBool bSendAudioPilotIntensityStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;
  /****************************************************************************************************/
  tVoid vStoreAndSendBassPOMsg(tS8);
  tVoid vStoreAndSendTreblePOMsg(tS8);
  tBool bStoreAndSendBalancePOMsg(tS8);
  tBool bStoreAndSendFaderPOMsg(tS8);
  tVoid vStoreAndSendMidRangePOMsg(tS8);
  tBool bStoreAndSendLoudnessPOMsg(tU8);
  tBool bStoreAndSendRoomEffectPOMsg(tU8);
  tBool bStoreAndSendGalaPOMsg(tS8);
  tVoid vStoreBeepLevel(tU8);
  tVoid vStoreAndSendEquPresetPOMsg(tU8);
  tVoid vStoreAndSendOptimizationPOMsg(tU8);

  tVoid vOnLoadUserSettings();
  tVoid vOnLoadMinMaxSettings();
  tVoid vLoadBalanceFaderSettings();

  tVoid vStoreAndUpdateExtAmpSettings(tU8 u8Type, tS8 s8Steps);
   AudioUserDpIf* pAudUsrDpIf;

public:
  // inbox for TTFis
  virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

  // PostOffice
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void vAddObserver();
  bool gala_availability_changed(bool availability);
  InternalCommunicationAdapter* pPO; // Pointer for post office access

  tU8 KDSAvailability();


private:
  static fc_audiomanager_tclApp *poCcaMainApp;
  fc_audiomanager_tclService_Audio_Function *poAudioService;

   tS8 m_s8Fader;
   tS8 m_s8Treble;
   tS8 m_s8Balance;
   tS8 m_s8Bass;
   tU8 m_u8Gala;
   tU8 m_u8AuxIn;
   tU8 m_u8BeepLevel;
   tS8 m_s8MidRange;
   tU8 m_u8Loudness;
   tU8 m_u8DynCompression;
   tU8 m_u8EquPreset;
   tU8 m_u8Optimization;
   tU8 m_u8RoomEffect;
   tU8 m_u8RearMute;
   tU8 m_u8GeometryMode;
   tU8 m_DiagDefsetPhase;  // added to send the DiagDefset value to Controller plugin
   tU8 m_AudioMode;
   tS16 m_s16ANCDbvalue;
   tS8 m_s8PrevBal;
   tS8 m_s8PrevFad;

   //Minimum value for all sound properties
   tS8 m_s8MinBass;
   tS8 m_s8MinTreble;
   tS8 m_s8MinMidRange;
   tS8 m_s8MinFader;
   tS8 m_s8MinBalance;
   tS8 m_s8MinAuxIn;
   tS8 m_s8MinLoudness;

   //Maximum value for all sound properties
   tS8 m_s8MaxBass;
   tS8 m_s8MaxTreble;
   tS8 m_s8MaxMidRange;
   tS8 m_s8MaxFader;
   tS8 m_s8MaxBalance;
   tS8 m_s8MaxGala;
   tS8 m_s8MaxAuxIn;
   tS8 m_s8MaxLoudness;
   tS8 m_s8MaxDynCompression;
   tS8 m_s8MaxEquPreset;
   tS8 m_s8MaxOptimization;
   tS8 m_s8MaxRoomEffect;

   tBool m_bSDVCAvailability;
   tBool m_bBassAvailability;
   tBool m_bTrebleAvailability;
   tBool m_bBalanceAvailability;
   tBool m_bSurroundModeAvailability;
   tBool m_bAudioPilotAvailability;
   tBool m_bStagingAvailability;
   tBool m_bLoudnessAvailability;
   tBool m_bRoomEffectAvailability;
   tBool m_bAGCAvailability;
   tBool m_bMidRangeAvailability;
   tBool m_bFaderAvailability;
   tBool m_bSubWooferAvailability;
   tVoid vCheckSWAvailabilility();
   tVoid vHandleTraceAmpAvailabilityInput(tPCUChar pcu8Data);
   tBool m_bIsExtAmpConnected;
   tBool m_bAudioPilotMode;
   tU8 m_u8AudioPilotIntensity;
   tBool m_bUpaMuteState;
   tVoid vOnLoadExtAmpSettingsList();
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   tVoid vCheckMidRangeSWAvailablility();

   tBool m_bFMEnhancer;
   tBool m_bSubWoofer;

   tS8 m_s8MaxSubWoofer;
   tS8 m_s8MinSubWoofer;
   tBool m_bAGCMode;
 #endif
};

#endif //_PERSISTENT_MGR_H_

