/*******************************************************************************
 *
 * FILE:          SoundHandler.cpp
 *
 * SW-COMPONENT:  SoundHandler application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links "osal_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <midw_fi_if.h>

#include "SoundHandler.h"
#include "../fc_audiomanager_service_Audio_Function.h"
#include "Arkamys/RNAIVI/ArkamysFeatureHandlerRNAIVI.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
#include "../fc_audiomanager_trace.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SOUND_HANDLER
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SOUND
#include "trcGenProj/Header/SoundHandler.cpp.trc.h"
#endif

#include "../vd_adr3/vd_adr3Msg_If.h"
#include "../vd_adr3/vd_adr3_Config_Types.h"
#include "../vd_adr3/vd_adr3_Config.h"
#include "../vd_adr3/vd_adr3_main.h"

#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagRemoteControl.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_SetDiagFader.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_SetDiagBalance.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../InternalComponentCommunication/Messages/Sound/ID_ArkamysModeSet.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagRemoteControlType.h"
#include "../InternalComponentCommunication/Messages/ChildSleep/IDCCARearMute.h"
#include "../InternalComponentCommunication/Messages/settings/IDProfileDataChanged.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_ExtAmpSettingsStatus.h"
#include "../InternalComponentCommunication/Messages/BOSE_Amp/ID_ExtAmpSettingsList.h"
#include "../util/Macro.h"
#include "../InternalComponentCommunication/Messages/Beep/IDCCAUPATempMute.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define ACTIVE 1
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#define DEACTIVE 0
#define ERROR 2
#define US 0
#define CAN 1
#define MEX 2
#define UK 3
#define TKY 4
#define EUR 6
#define TWN 8
#define HKG 9
#endif
/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/
// Static self reference to be used in function callbacks.
fc_audiomanager_tclApp*   SoundHandler::poCcaMainApp  = NULL;
bool             SoundHandler::RemoteControlFlag=false;
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: SoundHandler::SoundHandler()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
SoundHandler::SoundHandler(fc_audiomanager_tclApp* poMainAppl, fc_audiomanager_tclService_Audio_Function* poService):
    IF_MessageObserver<PO_MessageConfig::enID>("SoundHandler"),
    pAudUsrDpIf(NULL)
{
    ETG_TRACE_USR4(("SoundHandler() entered."));

    SoundHandler::poCcaMainApp = poMainAppl;
    SoundHandler::poAudioService = poService;

    pPO = InternalCommunicationAdapter::getInstance();
    vAddObserver();

    m_s8Fader = 0;
    m_s8Treble = 0;
    m_s8Balance = 0;
    m_s8Bass = 0;
    m_u8Gala = 0;
    m_u8AuxIn = 0;
    m_s8MidRange = 0;
    m_u8Loudness = 0;
    m_u8DynCompression = 0;
    m_u8EquPreset = 0;
    m_u8Optimization = 0;
    m_u8BeepLevel = 0;
    m_u8RoomEffect = 0;
    m_u8RearMute = 0;
    m_u8GeometryMode = 0;
    m_s8MinBass = 0;
    m_s8MinTreble = 0;
    m_s8MinMidRange = 0;
    m_s8MinFader = 0;
    m_s8MinBalance = 0;
    m_s8MinAuxIn = 0;
    m_s8MinLoudness = 0;
    m_AudioMode = 0;
    m_s8MaxBass = 0;
    m_s8MaxTreble = 0;
    m_s8MaxMidRange = 0;
    m_s8MaxFader = 0;
    m_s8MaxBalance = 0;
    m_s8MaxGala = 0;
    m_s8MaxAuxIn = 0;
    m_s8MaxLoudness = 0;
    m_s8MaxDynCompression = 0;
    m_s8MaxEquPreset = 0;
    m_s8MaxOptimization = 0;
    m_s8MaxRoomEffect = 0;
    m_DiagDefsetPhase = EN_DEFSET_UNDEF; //setting to undef as in fi definition
    m_s16ANCDbvalue = -7;  // ANC default scaler value x 4
  m_s8PrevBal = 0;
  m_s8PrevFad = 0;
    m_bSDVCAvailability = TRUE;
    m_bBassAvailability = TRUE;
    m_bTrebleAvailability = TRUE;
    m_bBalanceAvailability = TRUE;
    m_bSurroundModeAvailability = FALSE;
    m_bAudioPilotAvailability = FALSE;
    m_bStagingAvailability = TRUE;
  m_bLoudnessAvailability = TRUE;
    m_bRoomEffectAvailability = TRUE;
    m_bAGCAvailability = FALSE;
    m_bFaderAvailability = TRUE;
    m_bMidRangeAvailability = TRUE;
    m_bSubWooferAvailability = FALSE;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    m_bSubWoofer = true;
    m_bFMEnhancer = true;
    m_s8MinSubWoofer = 0;
    m_s8MaxSubWoofer = 0;
    m_bAGCMode = false;
#endif

   m_bIsExtAmpConnected = false;
   m_bAudioPilotMode = false;
   m_u8AudioPilotIntensity = 2;
   m_bUpaMuteState = false;
   pAudUsrDpIf = AudioUserDpIfSelect::pGetAudUsrDpIf();
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::~SoundHandler()
 *
 * DESCRIPTION: Destructor.
 *
 *              Invalidate static self reference.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
SoundHandler::~SoundHandler()
{
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    SoundHandler::poCcaMainApp = NULL;
    SoundHandler::poAudioService = NULL;
    pPO = NULL;
    return;
}


/********************************************************************************
 * vCheckMidRangeAvailablility().
 *******************************************************************************/
tVoid SoundHandler::vCheckSWAvailabilility()
{
    ETG_TRACE_USR4(("SoundHandler vCheckSWAvailabilility () entered."));
  tU8 Speaker = SOUND_CONFIG_ITEM_VALUE_UNDEF;
    tU8 Soundsys = SOUND_CONFIG_ITEM_VALUE_UNDEF;
    tU8 Region   = SOUND_CONFIG_ITEM_VALUE_UNDEF;
    ETG_TRACE_USR4(("Speaker : %d",Speaker));
    ETG_TRACE_USR4(("Soundsys : %d",Soundsys));
    ETG_TRACE_USR4(("Region : %d",Region));

#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    //reading the amplifier configuration from the KDS datapool
   // tU8 Speaker = SOUND_CONFIG_ITEM_VALUE_UNDEF;
  // tU8 Soundsys = SOUND_CONFIG_ITEM_VALUE_UNDEF;
  //  tU8 Region   = SOUND_CONFIG_ITEM_VALUE_UNDEF;
    //setting to default before updating based on KDS Data.
    m_bMidRangeAvailability = true;
    m_bSubWooferAvailability = false;
    m_bFaderAvailability = true;
    tU8 u8AmpConfig;
    tU8 u8RegionType;
    tBool bANCStatus;
    tU8 pu8Payload[2] ;

    //check gala and loudness availablity
    KDSAvailability();

    if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &u8AmpConfig, 1))
    {
        ETG_TRACE_USR4(("SoundHandler vCheckMidRangeAvailablility() AmpConfig = %d",u8AmpConfig));
        if((u8AmpConfig == EXTERNALAMP_BOSEWOMCAN) || (u8AmpConfig == BOSE_PERSONAL_SPACE))
        {
            m_bMidRangeAvailability = false;
            Soundsys = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4;
      if(u8AmpConfig == BOSE_PERSONAL_SPACE)
                 {
              ETG_TRACE_USR4(("BosePersonal space entered."));
                 m_bBalanceAvailability = false;
                 }
        }
        Speaker = SOUND_CONFIG_ITEM_VALUE_4SPEAKER;
        if(u8AmpConfig == INTERNALAMP_2SPEAKER || u8AmpConfig == INTERNALAMP_4SPEAKER ||u8AmpConfig ==HEAD_UNIT_ALONE)
        {
            m_bSubWooferAvailability = true;
            Soundsys = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1;
        }
    if(u8AmpConfig == EXTERNAL_ANC)
        {
            m_bSubWooferAvailability = true;
            Soundsys = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM5;
        }
        if(u8AmpConfig == INTERNALAMP_2SPEAKER || u8AmpConfig == EXTERNAL_DAIMLER_2)
        {
            m_bFaderAvailability = false;
            if(poAudioService)
                poAudioService->updateClients(MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS);
            Speaker = SOUND_CONFIG_ITEM_VALUE_2SPEAKER_FRONT;
            ETG_TRACE_USR4(("vSetConfigItem called for 2 Speaker System."));
        }
        if(u8AmpConfig == PREMIUM_AMP1)
        {
            m_bSDVCAvailability = FALSE ;
            m_bAudioPilotAvailability = TRUE;
      //update gala to 1 incase gala!=0 when read from dp
       if(m_u8Gala != 0)
       {
                m_u8Gala = 1;
       }
        }

        if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8RegionType, 1))
        {
            ETG_TRACE_USR4(("Configured Region Type : %d", u8RegionType))

                    switch(u8RegionType)
            {
                case US:
                case CAN:
                case MEX:
                {
                    Region = SOUND_CONFIG_ITEM_VALUE_NAR;
                    break;
                }
                case UK:
                case TKY:
                case EUR:
                {
                    Region = SOUND_CONFIG_ITEM_VALUE_EUROPE;
                    break;
                }
                case TWN:
                case HKG:
                {
                    Region = SOUND_CONFIG_ITEM_VALUE_ASIA;
                    break;
                }
                default:
                    Region = SOUND_CONFIG_ITEM_VALUE_ROW;
                    break;
            }
        }
        vd_adr3_config::vSetConfigItem(Speaker,Soundsys,Region,SOUND_CONFIG_ITEM_VALUE_UNDEF);


        if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","ANCActivation", &bANCStatus, 1))
        {

            vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_ANC_ONOFF, VD_ADR3_OPTYPE_SET, 1, &bANCStatus, ANC_ONOFF);

            // send the message to ADR as ON/OFF based on response received

            if(bANCStatus)
            {

                ETG_TRACE_USR4(("ANC status is activated with bANCStatus : %d",bANCStatus));

                pu8Payload[0] = (tU8)((m_s16ANCDbvalue & 0xFF00)>>8);
                pu8Payload[1] = (tU8)(m_s16ANCDbvalue & 0x00FF);

                vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_ANC_VOLUME, VD_ADR3_OPTYPE_SET, 2 , pu8Payload , ANC_VOLUME);

                ETG_TRACE_USR4(("message sent to ADR with scaler value : %d",m_s16ANCDbvalue));

                //DB ANC scaler value -7 db(-1.75 x 4) is sent to ADR .

            }
            else
            {

                // tU8 u8ANCDbval = 0;
                tU8 u8ANCDbval[2];

                u8ANCDbval[1]=0;
                u8ANCDbval[0]=0;

                ETG_TRACE_USR4(("ANC status is disabled with bANCStatus : %d",bANCStatus));

                vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, VD_ADR3_FKT_ID_ANC_VOLUME, VD_ADR3_OPTYPE_SET , 2, u8ANCDbval , ANC_VOLUME);

                //Set scaler level to zero and send message to ADR





            }
        }

    }
#endif

#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV
     KDSAvailability();
   vd_adr3_config::vSetConfigItem(Speaker,Soundsys,Region,ARS_AUD_APP_SOUNDITEM_VEHICLE_2);
#endif

#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART
     KDSAvailability();
   vd_adr3_config::vSetConfigItem(Speaker,Soundsys,Region,ARS_AUD_APP_SOUNDITEM_VEHICLE_1);

#endif

    ETG_TRACE_USR4(("SoundHandler,updating clients with MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION"));
    if(poAudioService)
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION);
}

/********************************************************************************
 * vInit().
 *******************************************************************************/
tVoid SoundHandler::vInit()const
{
    ETG_TRACE_USR4(("SoundHandler vInit() entered."));
    return;
}

tVoid SoundHandler::vOnLoadSettings(tU16 u16FunctionId)
{
    ETG_TRACE_USR4(("Overloaded vOnLoadSettings"));
    if(u16FunctionId == MIDW_MASCFFI_C_U16_ROOMEFFECT)
    {
        tS32 s32Res = 0;
        if(pAudUsrDpIf)
            pAudUsrDpIf->s32GetSoundStaging(m_u8RoomEffect);

        m_AudioMode = (tU8)EN_ARKAMYS_PREMIUM1;
        //deliver to Arkamys
        MSG_Settings oSettingsRoomEffect(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_ROOM_EFFECT, (tS16)m_u8RoomEffect);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsRoomEffect);

        if(poAudioService != NULL)
        {
            poAudioService->updateClients(MIDW_MASCFFI_C_U16_ROOMEFFECT);
            ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() RoomEffect=%d Result=%d",(tU16)m_u8RoomEffect,s32Res));
        }

    }
  if(u16FunctionId == MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL)
  {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    tS32 s32Res = 0;
    if(pAudUsrDpIf)
      s32Res = pAudUsrDpIf->s32GetAutomaticGainControl(m_bAGCMode);
    if(poAudioService != NULL)
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL);

    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() AGC=%d Result=%d",m_bAGCMode,s32Res));
      MSG_Settings oSettingsAGC(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUTO_GAIN_CONTROL, (tS16)m_bAGCMode);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsAGC);
#endif
  }
}

tVoid SoundHandler::vOnLoadSettings()
{
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() entered."));

    vOnLoadUserSettings();
    vOnLoadMinMaxSettings();
}

tVoid SoundHandler::vOnLoadUserSettings()
{
    if((poAudioService != NULL) && (pAudUsrDpIf != NULL))
    {
        tS32 s32Res = 0;

        s32Res = pAudUsrDpIf->s32GetGala(m_u8Gala);
        vCheckSWAvailabilility();

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_GALA);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Gala=%u Result=%d",(tU16)m_u8Gala,s32Res));

        vLoadBalanceFaderSettings();

        if(vCheckPropertyAvailablility(m_s8Treble,m_bTrebleAvailability))
            s32Res = pAudUsrDpIf->s32GetTreble(m_s8Treble);

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_TREBLE);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Treble=%d, Result=%d",(tS16)m_s8Treble,s32Res));

        if(vCheckPropertyAvailablility(m_s8Bass,m_bBassAvailability))
            s32Res = pAudUsrDpIf->s32GetBass(m_s8Bass);

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_BASS);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Bass=%d, Result=%d",(tS16)m_s8Bass,s32Res));

        if(vCheckPropertyAvailablility(m_s8MidRange,m_bMidRangeAvailability))
            s32Res = pAudUsrDpIf->s32GetMidRange(m_s8MidRange);

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_MIDRANGE);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() MidRange=%d, Result=%d",(tS16)m_s8MidRange,s32Res));

        s32Res = pAudUsrDpIf->s32GetBeepLevel(m_u8BeepLevel);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_BEEPLEVEL);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() BeepLevel=%u Result=%d",(tU16)m_u8BeepLevel,s32Res));

        s32Res = pAudUsrDpIf->s32GetEquPreset(m_u8EquPreset);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_EQUALISERPRESET);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() EquPreset=%d Result=%d",(tU16)m_u8EquPreset,s32Res));

        s32Res = pAudUsrDpIf->s32GetOptimization(m_u8Optimization);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_OPTIMIZATION);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Optimization=%d Result=%d",(tU16)m_u8Optimization,s32Res));

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_CENTER);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_SUBWOOFER);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_SURROUNDSETTING);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_GEOMETRY_MODE);

        dp_tclAudioManagerDPAuxInLevel oAuxInLevel;
        s32Res = oAuxInLevel.s32GetData(m_u8AuxIn);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUXINLEVEL);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() AuxInLevel=%u Result=%d",(tU16)m_u8AuxIn,s32Res));

        if(vCheckPropertyAvailablility((tS8&)m_u8Loudness,m_bLoudnessAvailability))
            s32Res = pAudUsrDpIf->s32GetLoudness(m_u8Loudness);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_LOUDNESS);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Loudness=%d Result=%d",(tU16)m_u8Loudness,s32Res));

        dp_tclAudioManagerDPDynCompression oDynaCompression;
        s32Res = oDynaCompression.s32GetData(m_u8DynCompression);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() DynaCompression=%d Result=%d",(tU16)m_u8DynCompression,s32Res));

        //Room Effect
        if(vCheckPropertyAvailablility((tS8&)m_u8RoomEffect,m_bRoomEffectAvailability) == TRUE)
        {
            if(m_AudioMode == (tU8)EN_ARKAMYS_PREMIUM1)
            {
                s32Res = pAudUsrDpIf->s32GetSoundStaging(m_u8RoomEffect);
            }
            else
            {
                s32Res = pAudUsrDpIf->s32GetRoomEffect(m_u8RoomEffect);
            }
        }
        else
            m_u8RoomEffect =0;

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_ROOMEFFECT);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() RoomEffect=%d Result=%d",(tU16)m_u8RoomEffect,s32Res));

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
        //BassExciter
        if(vCheckPropertyAvailablility((tS8&)m_bSubWoofer,m_bSubWooferAvailability) == TRUE)
        {
        tS16 subWoofer = 0;
        s32Res = pAudUsrDpIf->s32GetSubwoofer(subWoofer);
        m_bSubWoofer = static_cast<tBool>(subWoofer & 0x01);
        }
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_SUBWOOFER);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() Virtual subwoofer=%d Result=%d",m_bSubWoofer,s32Res));

        s32Res = pAudUsrDpIf->s32GetAutomaticGainControl(m_bAGCMode);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() AGC=%d Result=%d",m_bAGCMode,s32Res));
        s32Res = pAudUsrDpIf->s32GetAudioPilotMode(m_bAudioPilotMode);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUDIOPILOTMODE);
        ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() AudioPilotMode=%d Result=%d",m_bAudioPilotMode,s32Res));

      s32Res = pAudUsrDpIf->s32GetAudioPilotIntensity(m_u8AudioPilotIntensity);
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY);
      ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() AudioPilotIntensity=%d Result=%d",m_u8AudioPilotIntensity,s32Res));
#endif

        //deliver to vd_adr
        MSG_Settings oSettingsBass(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_BASS, (tS16)m_s8Bass);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsBass);

        MSG_Settings oSettingsTreble(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_TREBLE, (tS16)m_s8Treble);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsTreble);

        MSG_Settings oSettingsMidRange(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_MID, (tS16)m_s8MidRange);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsMidRange);

        MSG_Settings oSettingsLoudness(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_LOUDNESS, (tS16)m_u8Loudness);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsLoudness);

        MSG_Settings oSettingsEquPreset(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_EQUPRESET, (tS16)m_u8EquPreset);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsEquPreset);

        MSG_Settings oSettingsOptimization(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_OPTIMIZATION, (tS16)m_u8Optimization);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsOptimization);

        MSG_Settings oSettingsGala(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SDVC, (tS16)m_u8Gala);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsGala);

        //deliver to Arkamys
        tU8 u8RoomEffect = m_u8RoomEffect;
        if(m_bIsExtAmpConnected)
           u8RoomEffect+=1;//hmi mappings are 0 to 4, ext amp prem2 mappings are 1 to 5. hence 1 is added
        MSG_Settings oSettingsRoomEffect(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_ROOM_EFFECT, (tS16)u8RoomEffect);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsRoomEffect);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
        //bass exciter or bass enhancer or virtual sub woofer
        MSG_Settings oSettingsSubWoofer(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_VIRTUAL_SUB_WOOFER, (tS16)m_bSubWoofer);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsSubWoofer);

        MSG_Settings oSettingsAGC(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUTO_GAIN_CONTROL, (tS16)m_bAGCMode);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsAGC);
      MSG_Settings oSettingsAudPilotMode(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUDIO_PILOT_MODE, (tS16)m_bAudioPilotMode);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsAudPilotMode);

      MSG_Settings oSettingsAudPilotIntensity(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUDIO_PILOT_INTENSITY, (tS16)m_u8AudioPilotIntensity);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsAudPilotIntensity);
#endif
    }
}

tVoid SoundHandler::vOnLoadMinMaxSettings()
{
    tS32 s32Res = 0;

    //Bass
    dp_tclAudioManagerDPBass_Max oBassMax;
    s32Res = oBassMax.s32GetData(m_s8MaxBass);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxBass=%d, Result=%d",(tS16)m_s8MaxBass,s32Res));
    dp_tclAudioManagerDPBass_Min oBassMin;
    s32Res = oBassMin.s32GetData(m_s8MinBass);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinBass=%d, Result=%d",(tS16)m_s8MinBass,s32Res));

    //Treble
    dp_tclAudioManagerDPTreble_Max oTrebleMax;
    s32Res = oTrebleMax.s32GetData(m_s8MaxTreble);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxTreble=%d, Result=%d",(tS16)m_s8MaxTreble,s32Res));
    dp_tclAudioManagerDPTreble_Min oTrebleMin;
    s32Res = oTrebleMin.s32GetData(m_s8MinTreble);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinTreble=%d, Result=%d",(tS16)m_s8MinTreble,s32Res));

    //MidRange
    dp_tclAudioManagerDPMidRange_Max oMidRangeMax;
    s32Res = oMidRangeMax.s32GetData(m_s8MaxMidRange);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxMidRange=%d, Result=%d",(tS16)m_s8MaxMidRange,s32Res));
    dp_tclAudioManagerDPMidRange_Min oMidRangeMin;
    s32Res = oMidRangeMin.s32GetData(m_s8MinMidRange);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinMidRange=%d, Result=%d",(tS16)m_s8MinMidRange,s32Res));

    //Fader
    dp_tclAudioManagerDPFader_Max oFaderMax;
    s32Res = oFaderMax.s32GetData(m_s8MaxFader);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxFader=%d, Result=%d",(tS16)m_s8MaxFader,s32Res));
    dp_tclAudioManagerDPFader_Min oFaderMin;
    s32Res = oFaderMin.s32GetData(m_s8MinFader);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinFader=%d, Result=%d",(tS16)m_s8MinFader,s32Res));

    //Balance
    dp_tclAudioManagerDPBalance_Max oBalanceMax;
    s32Res = oBalanceMax.s32GetData(m_s8MaxBalance);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxBalance=%d, Result=%d",(tS16)m_s8MaxBalance,s32Res));
    dp_tclAudioManagerDPBalance_Min oBalanceMin;
    s32Res = oBalanceMin.s32GetData(m_s8MinBalance);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinBalance=%d, Result=%d",(tS16)m_s8MinBalance,s32Res));


    //Loudness
    dp_tclAudioManagerDPLoudness_Max oLoudnessMax;
    s32Res = oLoudnessMax.s32GetData(m_s8MaxLoudness);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxLoudness=%d, Result=%d",(tS16)m_s8MaxLoudness,s32Res));
    dp_tclAudioManagerDPLoudness_Min oLoudnessMin;
    s32Res = oLoudnessMin.s32GetData(m_s8MinLoudness);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MinLoudness=%d, Result=%d",(tS16)m_s8MinLoudness,s32Res));

    //DynaCompression
    dp_tclAudioManagerDPDynCompression_Max oDynaCompressionMax;
    s32Res = oDynaCompressionMax.s32GetData(m_s8MaxDynCompression);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxDynCompression=%d, Result=%d",(tS16)m_s8MaxDynCompression,s32Res));

    //EquPreset
    dp_tclAudioManagerDPEquPreset_Max oEquPresetMax;
    s32Res = oEquPresetMax.s32GetData(m_s8MaxEquPreset);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxEquPreset=%d, Result=%d",(tS16)m_s8MaxEquPreset,s32Res));

    //Optimization
    dp_tclAudioManagerDPOptimization_Max oOptimizationMax;
    s32Res = oOptimizationMax.s32GetData(m_s8MaxOptimization);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxOptimization=%d, Result=%d",(tS16)m_s8MaxOptimization,s32Res));

    //Gala
    dp_tclAudioManagerDPGala_Max oGalaMax;
    s32Res = oGalaMax.s32GetData(m_s8MaxGala);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxGala=%d, Result=%d",(tS16)m_s8MaxGala,s32Res));

    //RoomEffect
    dp_tclAudioManagerDPRoomEffect_Max oRoomEffectMax;
    s32Res = oRoomEffectMax.s32GetData(m_s8MaxRoomEffect);
    ETG_TRACE_USR4(("SoundHandler vOnLoadSettings() m_s8MaxRoomEffect=%d, Result=%d",(tS16)m_s8MaxRoomEffect,s32Res));

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    dp_tclAudioManagerDPSubWoofer_Min oSubWooferMin;
    s32Res = oSubWooferMin.s32GetData(m_s8MinSubWoofer);
    ETG_TRACE_USR4(("SubWooferMin_Value = %x",m_s8MinSubWoofer ));
    ETG_TRACE_USR4(("REsult = %x",s32Res ));

    dp_tclAudioManagerDPSubWoofer_Max oSubWooferMax;
    s32Res = oSubWooferMax.s32GetData(m_s8MaxSubWoofer);
    ETG_TRACE_USR4(("SubWooferMax_Value = %x",m_s8MaxSubWoofer ));
    ETG_TRACE_USR4(("REsult = %x",s32Res ));
#endif
}


/********************************************************************************
 * FUNCTION: KDSAvailability()
 *
 * DESCRIPTION:  This function is called to check if gala is available
 *
 * PARAMETER:   None
 *
 * RETURNVALUE:  tU8
 *******************************************************************************/
tU8 SoundHandler::KDSAvailability()
{
    ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::KDSAvailability entered"));

    tU8 u8Config;
    //read item from the KDS key's bytes- stream

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SoundVolumeConfig","Loudness", &u8Config, 1)))
    {
        ETG_TRACE_USR4(("u8Config loudness value : %d", u8Config));
        if(u8Config == 0 )
        {
            m_bLoudnessAvailability = FALSE;
        }
    }
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","SpeedCurve", &u8Config, 1)))
    {
        ETG_TRACE_USR4(("u8Config gala value : %d", u8Config));
        if(u8Config != 0 )
        {
            gala_availability_changed(true);

            return ACTIVE;
        }
        else
        {
            gala_availability_changed(false);
            return DEACTIVE;
        }
    }
    else
    {
        m_u8Gala =3;
        ETG_TRACE_ERR(("Error in KDS read  , default is set to 3 "));
        return ERROR;
    }
  #endif

 return ACTIVE;
}
bool SoundHandler::gala_availability_changed(bool availability)
{
    m_bSDVCAvailability = availability;
    #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    tU8 u8AmpConfig;
    if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &u8AmpConfig, 1))
    {

      if(u8AmpConfig != PREMIUM_AMP1)
      {
    #endif
     if(!(m_bSDVCAvailability))
     {
        tS32 s32Res=0;

        m_u8Gala = midw_fi_tcl_e8_GalaLevel::FI_EN_AUDIO_GALA_OFF;
        MSG_Settings oSettingsGala(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SDVC, (tS16)m_u8Gala);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsGala);

        if(pAudUsrDpIf)
        {
            s32Res = pAudUsrDpIf->s32SetGala(m_u8Gala);
            ETG_TRACE_USR4(("Persistent Memory storage Result for Gala = %x",s32Res));//to solve compiler error
        }
    }

    AUD_POINTER_CHECK_CALL (poAudioService);
    if((poAudioService->updateClients(MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION)!= AIL_EN_N_NO_ERROR))
    {
        ETG_TRACE_ERR(("ERROR: eUpdateClients():-> Updating the clients for AudioDeviceStatus failed"));
        return false;
    }
    else
    {
        ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients for AudioDeviceStatus passed"));
    }

  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    }
  }
  #endif
    return true;
}

tBool SoundHandler::bSendAmpAvailStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const
{
    ETG_TRACE_USR4(("SoundHandler::bSendAmpAvailStatus"));

    (tVoid)poInMsg;
    tBool bRetVal = false;
    midw_mascffi_tclMsgAmpAvailFunctionStatus oAmpAvailStatus;

    oAmpAvailStatus.Gala = m_bSDVCAvailability;
    ETG_TRACE_USR4(("Updating GALA availability %d",m_bSDVCAvailability));
    oAmpAvailStatus.Bass = m_bBassAvailability;
    ETG_TRACE_USR4(("Updating BASS availability %d",m_bBassAvailability));
    oAmpAvailStatus.Treble = m_bTrebleAvailability;
    ETG_TRACE_USR4(("Updating TREBLE availability %d",m_bTrebleAvailability));
    oAmpAvailStatus.Balance = m_bBalanceAvailability;
    ETG_TRACE_USR4(("Updating BALANCE availability %d",m_bBalanceAvailability));
    oAmpAvailStatus.SurroundMode = m_bSurroundModeAvailability;
    ETG_TRACE_USR4(("Updating SURROUND availability %d",m_bSurroundModeAvailability));
    oAmpAvailStatus.AudioPilot = m_bAudioPilotAvailability;
    ETG_TRACE_USR4(("Updating AUDIO PILOT availability %d",m_bAudioPilotAvailability));
    oAmpAvailStatus.Staging = m_bStagingAvailability;
    ETG_TRACE_USR4(("Updating STAGING availability %d",m_bStagingAvailability));
    oAmpAvailStatus.Loudness = m_bLoudnessAvailability;
    ETG_TRACE_USR4(("Updating LOUDNESS availability %d",m_bLoudnessAvailability));
    oAmpAvailStatus.RoomEffect = m_bRoomEffectAvailability;
    ETG_TRACE_USR4(("Updating ROOM EFFECT availability %d",m_bRoomEffectAvailability));
    oAmpAvailStatus.AGC = m_bAGCAvailability;
    ETG_TRACE_USR4(("Updating AGC availability %d",m_bAGCAvailability));

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    ETG_TRACE_USR4(("Updating Middle availability %d",m_bMidRangeAvailability));
    oAmpAvailStatus.Middle = m_bMidRangeAvailability;
    ETG_TRACE_USR4(("Updating Fader availability %d",m_bFaderAvailability));
    oAmpAvailStatus.Fader = m_bFaderAvailability;
    ETG_TRACE_USR4(("Updating SubWoofer availability %d",m_bSubWooferAvailability));
    oAmpAvailStatus.SubWoofer = m_bSubWooferAvailability;
#endif
    fi_tclVisitorMessage oCCaMsg(oAmpAvailStatus);
    // Always destroy the FI data object before leaving its creation scope
    oAmpAvailStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}
tVoid SoundHandler::vHandleTraceAmpAvailabilityInput(tPCUChar pcu8Data)
{
    tU8 u8Pty  = pcu8Data[2];
    tS8 value  = pcu8Data[3];
    switch(u8Pty)
    {
    case TRC::enBass:
        m_bBassAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating m_bBassAvailability availability %d",m_bBassAvailability));
        break;
    case TRC::enTreble:
        m_bTrebleAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating enTreble availability %d",m_bTrebleAvailability));
        break;
    case TRC::enMiddle:
        m_bMidRangeAvailability =(tBool)value;
        ETG_TRACE_USR4(("Updating m_bMidRangeAvailability availability %d",m_bMidRangeAvailability));
        break;
    case TRC::enBalance:
        m_bBalanceAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating BALANCE availability %d",m_bBalanceAvailability));
        break;
    case TRC::enFader:
        m_bFaderAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating FADER availability %d",m_bFaderAvailability));
        break;
    case TRC::enGala:
        m_bSDVCAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating SDVC availability %d",m_bSDVCAvailability));
        break;
    case TRC::enLoudness:
        m_bLoudnessAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating LOUDNESS availability %d",m_bLoudnessAvailability));
        break;
    case TRC::enRoomEffect:
        m_bRoomEffectAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating ROOM EFFECT availability %d",m_bRoomEffectAvailability));
        break;
    case TRC::enSurround:
        m_bSurroundModeAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating SURROUND availability %d",m_bSurroundModeAvailability));
        break;
    case TRC::enAudioPilot:
        m_bAudioPilotAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating AUDIO PILOT availability %d",m_bAudioPilotAvailability));
        break;
    case TRC::enStaging:
        m_bStagingAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating STAGING availability %d",m_bStagingAvailability));
        break;
    case TRC::enAGC:
        m_bAGCAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating AGC availability %d",m_bAGCAvailability));
        break;
    case TRC::enSubwoofer:
        m_bSubWooferAvailability = (tBool)value;
        ETG_TRACE_USR4(("Updating SUBWOOFER availability %d",m_bSubWooferAvailability));
        break;
    default :
        ETG_TRACE_USR4(("invalid property"));
        return;
    }
    vOnLoadSettings();
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (poAudioService);

    if(poAudioService->updateClients(MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION)!= AIL_EN_N_NO_ERROR)
    {
        ETG_TRACE_ERR(("ERROR: eUpdateClients():-> Updating the clients for AudioDeviceStatus failed"));
    }
    else
    {
        ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients for AudioDeviceStatus passed"));
    }

}
tBool SoundHandler::bGetStatusMessage(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)
{
    switch (u16FunctionId)
    {
    case MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION:
        return bSendAmpAvailStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_BALANCE  :
    return bSendBalanceStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_BASS :
        return bSendBassStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_MIDRANGE :
        return bSendMidRangeStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_TREBLE:
        return bSendTrebleStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_GALA:
        return bSendGalaStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_LOUDNESS :
        return bSendLoudnessStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_FADER:
        return bSendFaderStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_AUXINLEVEL:
        return bSendAuxInLevelStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_BEEPLEVEL:
        return bSendBeepLevelStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION:
        return bSendDynamicCompressionStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
        return bSendEquPresetStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_MEMSOUND:
        return bSendMeMSoundStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_OPTIMIZATION:
        return bSendOptimizationStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
        return bSendPDCAttenuationLevelStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_PDCATTENUATION:
        return bSendPDCAttenuationStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_ROOMEFFECT:
        return bSendRoomEffectStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_REAR_MUTE:
        return bSendRearMuteStatus(roOutMsg, poInMsg);

    case MIDW_MASCFFI_C_U16_GEOMETRY_MODE:
        return bSendGeometryMode(roOutMsg, poInMsg);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    case MIDW_MASCFFI_C_U16_FMENHANCERMODE:
        return bSendFMEnhancerStatus(roOutMsg, poInMsg);
#endif
        // case MIDW_MASCFFI_C_U16_SUBWOOFER: handled in service function since this property is re-used

    case MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE: //property Id : DiagDefSetPhase
    {
        tBool res =  bSendDiagDefSetPhaseStatus(roOutMsg, poInMsg);
        m_DiagDefsetPhase = EN_DEFSET_UNDEF; //setting to UNDEF because on immediate IGN OFF & ON,this value is retained.
        return res;
    }

    case MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL:
        return bSendAutomaticGainControlStatus(roOutMsg, poInMsg);
   case MIDW_MASCFFI_C_U16_AUDIOPILOTMODE:
     return bSendAudioPilotModeStatus(roOutMsg, poInMsg);

   case MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY:
     return bSendAudioPilotIntensityStatus(roOutMsg, poInMsg);
    default:
        return FALSE;
    }
}

tBool SoundHandler::bProcessSet(tU16 u16FunctionID, fi_tclVisitorMessage& roMessage, tBool& bPropertyChanged, tU16& u16ErrorCode)
{

    ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionID));

    // Handle property setting for this function ID here ...

    // Set [OUT] parameter 'bPropertyChanged' to TRUE if the value of the just
    // set property has changed.

    switch (u16FunctionID)
    {
    case MIDW_MASCFFI_C_U16_BALANCE  :
        return bSetBalance(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_BASS :
        return bSetBass(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_MIDRANGE :
        //cannot be set in Nissan LCN2kai
        //u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_DISABLED;
        return bSetMidRange(roMessage, bPropertyChanged, u16ErrorCode);
    case MIDW_MASCFFI_C_U16_TREBLE:
        return bSetTreble(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_GALA:
        return bSetGala(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_LOUDNESS :
        //constant in LCN2kai
        //bPropertyChanged = FALSE;
        return bSetLoudness(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_FADER  :
        return bSetFader(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_AUXINLEVEL:
        return bSetAuxInLevel(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_BEEPLEVEL:
        return bSetBeepLevel(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
        return bSetEquPreset(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION:
        return bSetDynamicCompression(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_MEMSOUND:
        return TRUE; // positively reply to request, but ignore requested setting
    case MIDW_MASCFFI_C_U16_OPTIMIZATION:
        return bSetOptimization(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_ROOMEFFECT:
        return bSetRoomEffect(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_PDCATTENUATION:
    case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
        u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_DISABLED;  // reject request
        return FALSE;

    case MIDW_MASCFFI_C_U16_REAR_MUTE:
        return bSetRearMuteStatus(roMessage, bPropertyChanged, u16ErrorCode);
        return false;

    case MIDW_MASCFFI_C_U16_GEOMETRY_MODE:
        return bSetGeometryModeStatus(roMessage, bPropertyChanged, u16ErrorCode);
        return false;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    case MIDW_MASCFFI_C_U16_FMENHANCERMODE:
        return bSetFMEnhancer(roMessage, bPropertyChanged, u16ErrorCode);

    case MIDW_MASCFFI_C_U16_SUBWOOFER:
        return bSetSubWoofer(roMessage, bPropertyChanged, u16ErrorCode);
#endif
    case MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL:
        return bSetAutomaticGainControl(roMessage, bPropertyChanged, u16ErrorCode);
   case MIDW_MASCFFI_C_U16_AUDIOPILOTMODE:
     return bSetAudioPilotMode(roMessage, bPropertyChanged, u16ErrorCode);

   case MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY:
     return bSetAudioPilotIntensity(roMessage, bPropertyChanged, u16ErrorCode);
    default:
        u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_OPCODENOTSUPPORTED;
        return FALSE;
    }
}

tBool SoundHandler::bSetBass(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    midw_mascffi_tclMsgBassSet inmsg;

   tS8 s8Bass = m_s8Bass;
   if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR4(("vSetBass() Type=0x%x, Bass=0x%x", inmsg.SoundType.enType, inmsg.Bass));
      midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

      if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
      {
         bPropertyChanged = (0 != inmsg.Bass);
         if(m_s8Bass < (m_s8MaxBass - inmsg.Bass))
           s8Bass = (tS8)(m_s8Bass + inmsg.Bass);
         else
           s8Bass = m_s8MaxBass;
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
      {
        bPropertyChanged = (0 != inmsg.Bass);
        if(m_s8Bass > (m_s8MinBass + inmsg.Bass))
          s8Bass = (tS8)(m_s8Bass - inmsg.Bass);
        else
          s8Bass = m_s8MinBass;
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
      {
        bPropertyChanged = (m_s8Bass != inmsg.Bass);
        if((inmsg.Bass >= m_s8MinBass)&&(inmsg.Bass <= m_s8MaxBass))
          s8Bass = inmsg.Bass;
        else if(inmsg.Bass < m_s8MinBass)
          s8Bass = m_s8MinBass;
        else
          s8Bass = m_s8MaxBass;
      }
      else
      {
         ETG_TRACE_ERR(("vSetBass() unknown SoundType"));
         u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
         return FALSE;
      }
   }

   vStoreAndSendBassPOMsg(s8Bass);

    return TRUE;
}

tBool SoundHandler::bSetBalance(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
   tS8 s8Balance = m_s8Balance;
   midw_mascffi_tclMsgBalanceSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetBalance() Type=0x%x, Balance=0x%x", inmsg.SoundType.enType, inmsg.Balance));

        midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

      if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
      {
         bPropertyChanged = (0 != inmsg.Balance);
         if(m_s8Balance < (m_s8MaxBalance - inmsg.Balance)) {
           s8Balance = (tS8)(m_s8Balance + inmsg.Balance);
         } else {
           s8Balance = m_s8MaxBalance;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
      {
         bPropertyChanged = (0 != inmsg.Balance);
         if(m_s8Balance > (m_s8MinBalance + inmsg.Balance)) {
           s8Balance = (tS8)(m_s8Balance - inmsg.Balance);
         } else {
           s8Balance = m_s8MinBalance;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
      {
         bPropertyChanged = (inmsg.Balance != m_s8Balance);
         if((inmsg.Balance >= m_s8MinBalance)&&(inmsg.Balance <= m_s8MaxBalance))
           s8Balance = inmsg.Balance;
     else if(inmsg.Balance < m_s8MinBalance)
       s8Balance = m_s8MinBalance;
     else
       s8Balance = m_s8MaxBalance;
      }
      else
      {
         ETG_TRACE_ERR(("vSetBalance() unknown SoundType"));
         u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
         return FALSE;
      }
   }
   return bStoreAndSendBalancePOMsg(s8Balance);
}

tBool SoundHandler::bSetTreble(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
   tS8 s8Treble = m_s8Treble;
   midw_mascffi_tclMsgTrebleSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetTreble() Type=0x%x, Treble=0x%x", inmsg.SoundType.enType, inmsg.Treble));

        midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

      if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
      {
         bPropertyChanged = (0 != inmsg.Treble);
         if(m_s8Treble < (m_s8MaxTreble - inmsg.Treble)) {
           s8Treble = (tS8)(m_s8Treble + inmsg.Treble);
         } else {
           s8Treble = m_s8MaxTreble;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
      {
         bPropertyChanged = (0 != inmsg.Treble);
         if(m_s8Treble > (m_s8MinTreble + inmsg.Treble)) {
           s8Treble = (tS8)(m_s8Treble - inmsg.Treble);
         } else {
           s8Treble = m_s8MinTreble;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
      {
         bPropertyChanged = (m_s8Treble != inmsg.Treble);
         if((inmsg.Treble >= m_s8MinTreble)&&(inmsg.Treble <= m_s8MaxTreble))
           s8Treble = inmsg.Treble;
     else if(inmsg.Treble < m_s8MinTreble)
       s8Treble = m_s8MinTreble;
     else
       s8Treble = m_s8MaxTreble;
      }
      else
      {
         ETG_TRACE_ERR(("vSetTreble() unknown SoundType"));
         u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
         return FALSE;
      }
   }
   vStoreAndSendTreblePOMsg(s8Treble);
   return TRUE;
}

tBool SoundHandler::bSetFader(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
   tS8 s8Fader = m_s8Fader;
   midw_mascffi_tclMsgFaderSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetFader() Type=0x%x, Fader=0x%x", inmsg.SoundType.enType, inmsg.Fader));
        midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

      if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
      {
         bPropertyChanged = (0 != inmsg.Fader);
         if(m_s8Fader < (m_s8MaxFader - inmsg.Fader)) {
           s8Fader = (tS8)(m_s8Fader + inmsg.Fader);
         } else {
           s8Fader = m_s8MaxFader;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
      {
         bPropertyChanged = (0 != inmsg.Fader);
         if(m_s8Fader > (m_s8MinFader + inmsg.Fader)) {
           s8Fader = (tS8)(m_s8Fader - inmsg.Fader);
         } else {
           s8Fader = m_s8MinFader;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
      {
         bPropertyChanged = (m_s8Fader != inmsg.Fader);
         if((inmsg.Fader >= m_s8MinFader)&&(inmsg.Fader <= m_s8MaxFader))
           s8Fader = inmsg.Fader;
     else if(inmsg.Fader < m_s8MinFader)
       s8Fader = m_s8MinFader;
     else
       s8Fader = m_s8MaxFader;
      }
      else
      {
         ETG_TRACE_ERR(("vSetFader() unknown SoundType"));
         u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
         return FALSE;
      }
   }
   return bStoreAndSendFaderPOMsg(s8Fader);

}

tBool SoundHandler::bSetGala(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /* u16ErrorCode */)
{

    midw_mascffi_tclMsgGalaSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetGala() GalaLevel=0x%x, Resource=0x%x", inmsg.GalaLevel.enType, inmsg.Resource.enType));

        bPropertyChanged = (m_u8Gala != (tU8)inmsg.GalaLevel.enType);
        m_u8Gala = (tU8)inmsg.GalaLevel.enType;

        if(inmsg.GalaLevel.enType > m_s8MaxGala)
        {
            m_u8Gala = m_s8MaxGala;
        }

    }

    return bStoreAndSendGalaPOMsg(m_u8Gala);
}
tBool SoundHandler::bStoreAndSendGalaPOMsg(tS8)
{
    if(m_bAudioPilotAvailability == TRUE && m_u8Gala != 0)
        m_u8Gala = 1;
    else if(vCheckPropertyAvailablility((tS8&)m_u8Gala,m_bSDVCAvailability) == TRUE)
        ETG_TRACE_USR4(("Gala available"));
    //store persistent
    if(m_bAudioPilotAvailability == TRUE || m_bSDVCAvailability == TRUE)
    {
        tS32 s32Res=0;

        if(pAudUsrDpIf)
            s32Res = pAudUsrDpIf->s32SetGala(m_u8Gala);

        ETG_TRACE_USR4(("Persistent Memory storage Result for Gala = %x",s32Res));//to solve compiler error
    }

    //deliver to vd_adr
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SDVC, (tS16)m_u8Gala);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
}


tBool SoundHandler::bSetAuxInLevel(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /* u16ErrorCode */)
{

    midw_mascffi_tclMsgAuxInLevelSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetAuxInLevel() AuxInLevel=0x%x", inmsg.AuxInLevel.enType));
        bPropertyChanged = (m_u8AuxIn != inmsg.AuxInLevel.enType);
        m_u8AuxIn = inmsg.AuxInLevel.enType;
    }

    //store persistent
    tS32 s32Res=0;
    dp_tclAudioManagerDPAuxInLevel oAuxInLevel;
    s32Res = oAuxInLevel.s32SetData(m_u8AuxIn);
    (tVoid)s32Res;

    ETG_TRACE_USR4(("Persistent Memory storage Result for oAuxInLevel = %x",s32Res));//to solve compiler error

    MSG_VolumeOffsetAux oVolOffsetAux((tenAuxInLevel)m_u8AuxIn);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oVolOffsetAux);

    return TRUE;
}

tBool SoundHandler::bSetBeepLevel(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /* u16ErrorCode */)
{

    midw_mascffi_tclMsgBeepLevelSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetBeepLevel() BeepLevel=0x%x", inmsg.BeepLevel.enType));
        bPropertyChanged = (m_u8BeepLevel != inmsg.BeepLevel.enType);
        m_u8BeepLevel = inmsg.BeepLevel.enType;
    }

    vStoreBeepLevel(m_u8BeepLevel);
    return TRUE;
}

tBool SoundHandler::bSetMidRange(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler vSetMidRange() entered."));

   tS8 s8MidRange = m_s8MidRange;
   midw_mascffi_tclMsgMidRangeSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetMidRange() Type=0x%x, MidRange=0x%x", inmsg.SoundType.enType, inmsg.MidRange));

        midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

      if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
      {
     bPropertyChanged = (0 != inmsg.MidRange);
         if(m_s8MidRange < (m_s8MaxMidRange - inmsg.MidRange)) {
           s8MidRange = (tS8)(m_s8MidRange + inmsg.MidRange);
         } else {
           s8MidRange = m_s8MaxMidRange;
         }
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
      {
     bPropertyChanged = (0 != inmsg.MidRange);
         if(m_s8MidRange > (m_s8MinMidRange + inmsg.MidRange))
           s8MidRange = (tS8)(m_s8MidRange - inmsg.MidRange);
         else
           s8MidRange = m_s8MinMidRange;
      }
      else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
      {
        bPropertyChanged = (m_s8MidRange != inmsg.MidRange);
      if((inmsg.MidRange >= m_s8MinMidRange)&&(inmsg.MidRange <= m_s8MaxMidRange))
        s8MidRange = inmsg.MidRange;
      else if(inmsg.MidRange < m_s8MinMidRange)
        s8MidRange = m_s8MinMidRange;
      else
        s8MidRange = m_s8MaxMidRange;
      }
      else
      {
         ETG_TRACE_ERR(("vSetMidRange() unknown SoundType"));
         u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
         return FALSE;
      }
   }
   vStoreAndSendMidRangePOMsg(s8MidRange);
   return TRUE;
}

tBool SoundHandler::bSetLoudness(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetLoudness() entered."));

    midw_mascffi_tclMsgLoudnessSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("vSetLoudness() Type=0x%x, Loudness=0x%x", inmsg.SoundType.enType, inmsg.Loudness));

        midw_fi_tcl_e8_AudioSoundType::tenType enType = inmsg.SoundType.enType;

        if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_INC)
        {
            bPropertyChanged = (0 != inmsg.Loudness);
            if(m_u8Loudness < (m_s8MaxLoudness - inmsg.Loudness)) {
                m_u8Loudness = (tU8)(m_u8Loudness + inmsg.Loudness);
            } else {
                m_u8Loudness = m_s8MaxLoudness;
            }
        }
        else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_DEC)
        {
            bPropertyChanged = (0 != inmsg.Loudness);
            if(m_u8Loudness > (m_s8MinLoudness + inmsg.Loudness))
                m_u8Loudness = (tU8)(m_u8Loudness - inmsg.Loudness);
            else
                m_u8Loudness = m_s8MinLoudness;
        }
        else if(enType == midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS)
        {
            bPropertyChanged = (m_u8Loudness != inmsg.Loudness);
            if(((tS8)inmsg.Loudness >= m_s8MinLoudness)&&((tS8)inmsg.Loudness <= m_s8MaxLoudness))
                m_u8Loudness = inmsg.Loudness;
            else if((tS8)inmsg.Loudness < m_s8MinLoudness)
                m_u8Loudness = m_s8MinLoudness;
            else
                m_u8Loudness = m_s8MaxLoudness;
        }
        else
        {
            ETG_TRACE_ERR(("bSetLoudness() unknown SoundType"));
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            return FALSE;
        }
    }
    return bStoreAndSendLoudnessPOMsg(m_u8Loudness);
}
tBool SoundHandler::bStoreAndSendLoudnessPOMsg(tU8)
{
    if(vCheckPropertyAvailablility((tS8&)m_u8Loudness,m_bLoudnessAvailability))
    {
        //store persistent
        tS32 s32Res=0;

        if(pAudUsrDpIf)
            pAudUsrDpIf->s32SetLoudness(m_u8Loudness);

        ETG_TRACE_USR4(("Persistent Memory storage Result for Loudness = %x",s32Res));
    }
    //deliver to vd_adr
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_LOUDNESS, (tS16)m_u8Loudness);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
}
tBool SoundHandler::bSetDynamicCompression(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetDynamicCompression() entered."));

    midw_mascffi_tclMsgDynamicCompressionSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetDynamicCompression() Dynamic Compression Type=0x%x, Resource=0x%x", inmsg.DynComp.enType, inmsg.Resource.enType));

        bPropertyChanged = (m_u8DynCompression != (tU8)inmsg.DynComp.enType);
        m_u8DynCompression = (tU8)inmsg.DynComp.enType;

        if(inmsg.DynComp.enType > m_s8MaxDynCompression)
        {
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            return FALSE;
        }
    }
    //store persistent
    tS32 s32Res=0;
    dp_tclAudioManagerDPDynCompression oDynaCompression;
    s32Res = oDynaCompression.s32SetData(m_u8DynCompression);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Dynamic Copmression = %x",s32Res));

    //deliver to vd_adr
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_DYNAMIC_COMPRESSION, (tS16)m_u8DynCompression);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
}

tBool SoundHandler::bSetEquPreset(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetEquPreset() entered."));

    midw_mascffi_tclMsgEqualiserPresetSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetEquPreset() EquPreset Type=0x%x, Resource=0x%x", inmsg.EquPreset.enType, inmsg.Resource.enType));

        bPropertyChanged = (m_u8EquPreset != (tU8)inmsg.EquPreset.enType);
        m_u8EquPreset = (tU8)inmsg.EquPreset.enType;

        if(inmsg.EquPreset.enType > m_s8MaxEquPreset)
        {
            m_u8EquPreset = m_s8MaxEquPreset;
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            // return FALSE;
        }
    }
    vStoreAndSendEquPresetPOMsg(m_u8EquPreset);
    return TRUE;
}

tBool SoundHandler::bSetOptimization(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetOptimization() entered."));

    midw_mascffi_tclMsgOptimizationSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetOptimization() Optimization Type=0x%x, Resource=0x%x", inmsg.Optimization.enType, inmsg.Resource.enType));

        bPropertyChanged = (m_u8Optimization != (tU8)inmsg.Optimization.enType);
        m_u8Optimization = (tU8)inmsg.Optimization.enType;

        if(inmsg.Optimization.enType > m_s8MaxOptimization)
        {
            m_u8Optimization = m_s8MaxOptimization;
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            // return FALSE;
        }
    }
    vStoreAndSendOptimizationPOMsg(m_u8Optimization);
    return TRUE;
}

tBool SoundHandler::bSetRearMuteStatus(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /*u16ErrorCode*/)
{
    ETG_TRACE_USR4(("bSetRearMuteStatus entered."));
    midw_mascffi_tclMsgRear_MuteSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4((" rear mute Type=0x%x", inmsg.Rear_Mute.enType));
        bPropertyChanged = (m_u8RearMute != (tU8)inmsg.Rear_Mute.enType);
        m_u8RearMute = inmsg.Rear_Mute.enType;
        ID_CCAStart_RearMute startRearMute(inmsg.Rear_Mute.enType);
        if((InternalCommunicationAdapter::getInstance()!=NULL) && (InternalCommunicationAdapter::getInstance()->POMessages!=NULL))
            InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startRearMute);
        return TRUE;
    }
    return FALSE;

}

tBool SoundHandler::bSetGeometryModeStatus(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("bSetGeometryModeStatus entered."));
    midw_mascffi_tclMsgGeometry_ModeSet inmsg;

    //get geometry mode
    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4((" Geometry mode Type=0x%x", inmsg.Geometry_Mode.enType));
        bPropertyChanged = (m_u8GeometryMode != (tU8)inmsg.Geometry_Mode.enType);
        m_u8GeometryMode = inmsg.Geometry_Mode.enType;

        switch(m_u8GeometryMode)
        {
        case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_MANUAL:
        case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_CHILD_SLEEP:
        case midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_ALL_CAR:
        {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
            if(pAudUsrDpIf)
            {
                tS32 s32Res = pAudUsrDpIf->s32SetGeometryMode(m_u8GeometryMode);
                ETG_TRACE_USR4(("Persistent Memory storage Result for m_u8GeometryMode = %x",m_u8GeometryMode));
                ETG_TRACE_USR4(("s32Res : %d",s32Res));
            }
#endif
        }
            break;

        default:
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            return FALSE;
        }
    }
    vLoadBalanceFaderSettings();
    return TRUE;
}

tBool SoundHandler::bSetRoomEffect(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetRoomEffect() entered."));

  tU8 u8RoomEffect = m_u8RoomEffect;
  midw_mascffi_tclMsgRoomEffectSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetRoomEffect() RoomEffect Type=0x%x, Resource=0x%x", inmsg.RoomEffect.enType, inmsg.Resource.enType));

        if(m_AudioMode == (tU8)EN_ARKAMYS_PREMIUM1)
        {
            if(inmsg.RoomEffect.enType > 1)
            {
                u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
                return FALSE;
            }
        }
        else if (inmsg.RoomEffect.enType > m_s8MaxRoomEffect)
        {
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            return FALSE;
        }

    bPropertyChanged = (m_u8RoomEffect != (tU8)inmsg.RoomEffect.enType);
    u8RoomEffect = (tU8)inmsg.RoomEffect.enType;

    if ((m_AudioMode == (tU8)EN_ARKAMYS_AUDITORIUM) && ((tU8)inmsg.RoomEffect.enType == m_s8MaxRoomEffect))
      u8RoomEffect = (tU8)(m_s8MaxRoomEffect - 1); //gen4 prio3 compiler warning fix

    if(m_bIsExtAmpConnected)//hmi mappings are 0 to 4, ext amp prem2 mappings are 1 to 5. hence 1 is added
      u8RoomEffect = (tU8)(u8RoomEffect+1);        //gen4 prio3 compiler warning fix


    }
  return bStoreAndSendRoomEffectPOMsg(u8RoomEffect);
}

tBool SoundHandler::bStoreAndSendRoomEffectPOMsg(tU8 u8RoomEffect)
{
   if(vCheckPropertyAvailablility((tS8&)u8RoomEffect,m_bRoomEffectAvailability) && (!m_bIsExtAmpConnected))//do not store into DP for ext amp
   {
   m_u8RoomEffect = u8RoomEffect;
   //store persistent
     tS32 s32Res=0;
     if(m_AudioMode == (tU8)EN_ARKAMYS_PREMIUM1)
     {
       if(pAudUsrDpIf)
         pAudUsrDpIf->s32SetSoundStaging(m_u8RoomEffect);

            ETG_TRACE_USR4(("Persistent Memory storage Result for SoundStaging = %x",s32Res));
        }
        else
        {
            if(pAudUsrDpIf)
                s32Res = pAudUsrDpIf->s32SetRoomEffect(m_u8RoomEffect);

       ETG_TRACE_USR4(("Persistent Memory storage Result for RoomEffect = %x",s32Res));
       }
   }
   //deliver to Arkamys
   MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_ROOM_EFFECT, (tS16)u8RoomEffect);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
}
tBool SoundHandler::bSetFMEnhancer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /*u16ErrorCode*/)
{

    ETG_TRACE_USR4(("SoundHandler bSetFMEnhancer() entered."));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    midw_mascffi_tclMsgFMEnhancerModeSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetFMEnhancer() Enhancer mode=0x%x", inmsg.FMEnhancer));

        bPropertyChanged = (m_bFMEnhancer != (tU8)inmsg.FMEnhancer);
        m_bFMEnhancer = inmsg.FMEnhancer;

    }

    //deliver to arkamys
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_FM_ENHANCER, (tS16)m_bFMEnhancer);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
#else
    (void)roVisitorMsg;
    bPropertyChanged = FALSE;
    return TRUE;
#endif
}

tBool SoundHandler::bSetSubWoofer(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
    ETG_TRACE_USR4(("SoundHandler bSetSubWoofer() entered."));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    midw_mascffi_tclMsgSubWooferSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetSubWoofer() virtual sub woofer value=0x%x", inmsg.SubWoofer));

        bPropertyChanged = (m_bSubWoofer != inmsg.SubWoofer);
        if (inmsg.SubWoofer > m_s8MaxSubWoofer || inmsg.SubWoofer < m_s8MinSubWoofer)
        {
            u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
            return FALSE;
        }
        m_bSubWoofer = (tBool)inmsg.SubWoofer;
    }
    if(m_bSubWooferAvailability)
    {
        //store persistent
        tS32 s32Res=0;

        if(pAudUsrDpIf)
            s32Res = pAudUsrDpIf->s32SetSubwoofer((tS16)m_bSubWoofer);

        ETG_TRACE_USR4(("Persistent Memory storage Result for Virtual Sub woofer or bass exciter = %x",s32Res));
    }
    else
        m_bSubWoofer = FALSE;

    //deliver to arkamys
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_VIRTUAL_SUB_WOOFER, (tS16)m_bSubWoofer);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
#else
    (void)roVisitorMsg;
    (void)u16ErrorCode;
    bPropertyChanged = FALSE;
    return TRUE;
#endif
}

tBool SoundHandler::bSetAutomaticGainControl(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /*u16ErrorCode*/)
{
    ETG_TRACE_USR4(("SoundHandler bSetAutomaticGainControl() entered."));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    midw_mascffi_tclMsgAutomaticGainControlSet inmsg;

    if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("bSetAutomaticGainControl() AGC mode=0x%x", inmsg.AutomaticGainControl));

        bPropertyChanged = (m_bAGCMode != (tU8)inmsg.AutomaticGainControl);
        m_bAGCMode = inmsg.AutomaticGainControl;

    }

    if(!m_bAGCAvailability)
        m_bAGCMode = false;
    else
    {
        //store persistent
        tS32 s32Res=0;
        if(pAudUsrDpIf)
            s32Res = pAudUsrDpIf->s32SetAutomaticGainControl(m_bAGCMode);

    ETG_TRACE_USR4(("Persistent Memory storage Result for AGC = %x",s32Res));
  }

    //deliver to arkamys
    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUTO_GAIN_CONTROL, (tS16)m_bAGCMode);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    return TRUE;
#else
    (void)roVisitorMsg;
    bPropertyChanged = FALSE;
    return TRUE;
#endif
}

tBool SoundHandler::bSetAudioPilotMode(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& /*u16ErrorCode*/)
{
  ETG_TRACE_USR4(("SoundHandler bSetAudioPilotMode() entered."));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  tBool bAudioPilotMode = m_bAudioPilotMode;
  midw_mascffi_tclMsgAudioPilotModeSet inmsg;

  if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("bSetAudioPilotMode() mode=0x%x", inmsg.AudPilotMode));

    bPropertyChanged = (m_bAudioPilotMode != (tU8)inmsg.AudPilotMode);
    bAudioPilotMode = inmsg.AudPilotMode;

  }

  //deliver to ext amp
  MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUDIO_PILOT_MODE, (tS16)bAudioPilotMode);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

  return TRUE;
#else
  (void)roVisitorMsg;
  bPropertyChanged = FALSE;
  return TRUE;
#endif
}

tBool SoundHandler::bSetAudioPilotIntensity(fi_tclVisitorMessage& roVisitorMsg, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
  ETG_TRACE_USR4(("SoundHandler bSetAudioPilotIntensity() entered."));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  tU8 u8AudioPilotIntensity = m_u8AudioPilotIntensity;
  midw_mascffi_tclMsgAudioPilotIntensitySet inmsg;

  if(roVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("bSetAudioPilotIntensity() level=0x%x", inmsg.Audio_Pilot_Intensity.enType));

    bPropertyChanged = (m_u8AudioPilotIntensity != (tU8)inmsg.Audio_Pilot_Intensity.enType);

    if((inmsg.Audio_Pilot_Intensity.enType < midw_fi_tcl_e8_AudioPilotIntensity::FI_EN_LOW)
      ||(inmsg.Audio_Pilot_Intensity.enType > midw_fi_tcl_e8_AudioPilotIntensity::FI_EN_HIGH))
    {
        u16ErrorCode = MIDW_MASCFFI_C_U16_ERROR_PARAMETEROUTOFRANGE;
        return FALSE;
    }
    else
    {
        u8AudioPilotIntensity = (tU8)inmsg.Audio_Pilot_Intensity.enType;
    }

  }

  //deliver to ext amp
  MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_AUDIO_PILOT_INTENSITY, (tS16)u8AudioPilotIntensity);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

  return TRUE;
#else
  (void)roVisitorMsg;
  (void)u16ErrorCode;
  bPropertyChanged = FALSE;
  return TRUE;
#endif

}


tBool SoundHandler::bSendBassStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{

    midw_mascffi_tclMsgBassStatus oBassStatus;
    tBool bRetVal = false;

    oBassStatus.Bass = m_s8Bass;
    // ToDo Hardcoded or keep it in a member from MethodStart
    oBassStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oBassStatus.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    fi_tclVisitorMessage oCCaMsg(oBassStatus);
    // Always destroy the FI data object before leaving its creation scope
    oBassStatus.vDestroy();

    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendMidRangeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */) const
{
    midw_mascffi_tclMsgMidRangeStatus oMidRangeStatus;
    tBool bRetVal = false;

    oMidRangeStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oMidRangeStatus.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    oMidRangeStatus.MidRange = m_s8MidRange;

    fi_tclVisitorMessage oCCaMsg(oMidRangeStatus);

    oMidRangeStatus.vDestroy();

    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendTrebleStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgTrebleStatus oTrebleStatus;
    tBool bRetVal = false;

    oTrebleStatus.Treble = m_s8Treble;
    // ToDo Hardcoded or keep it in a member from MethodStart
    oTrebleStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oTrebleStatus.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    fi_tclVisitorMessage oCCaMsg(oTrebleStatus);
    // Always destroy the FI data object before leaving its creation scope
    oTrebleStatus.vDestroy();

    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendBalanceStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)
{
  if (m_s8Balance != m_s8PrevBal)
  {
    m_s8PrevBal = m_s8Balance;

  (tVoid)poInMsg;

    midw_mascffi_tclMsgBalanceStatus oBalanceStatus;
    tBool bRetVal = false;

    oBalanceStatus.Balance = m_s8Balance;
    // ToDo Hardcoded or keep it in a member from MethodStart
    oBalanceStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oBalanceStatus.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    fi_tclVisitorMessage oCCaMsg(oBalanceStatus);
    // Always destroy the FI data object before leaving its creation scope
    oBalanceStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
  }
  ETG_TRACE_USR4(("Property:Balance value not changed"));
  return false;
}

tBool SoundHandler::bSendFaderStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)
{
  if (m_s8Fader != m_s8PrevFad)
  {
    m_s8PrevFad = m_s8Fader;

    (tVoid)poInMsg;

    midw_mascffi_tclMsgFaderStatus oFaderStatus;
    tBool bRetVal = false;

    oFaderStatus.Fader = m_s8Fader;
    // ToDo Hardcoded or keep it in a member from MethodStart
    oFaderStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oFaderStatus.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    fi_tclVisitorMessage oCCaMsg(oFaderStatus);
    // Always destroy the FI data object before leaving its creation scope
    oFaderStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
  }
  ETG_TRACE_USR4(("Property:Fader value not changed"));
  return false;
}

tBool SoundHandler::bSendGalaStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const
{
    (tVoid)poInMsg;

    midw_mascffi_tclMsgGalaStatus oGalaStatus;
    tBool bRetVal = false;

    oGalaStatus.GalaLevel.enType = (midw_fi_tcl_e8_GalaLevel::tenType)m_u8Gala;
    // ToDo Hardcoded or keep it in a member from MethodStart
    oGalaStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    fi_tclVisitorMessage oCCaMsg(oGalaStatus);
    // Always destroy the FI data object before leaving its creation scope
    oGalaStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendLoudnessStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */) const
{
    midw_mascffi_tclMsgLoudnessStatus oLoudnessStatus;

    oLoudnessStatus.Loudness = m_u8Loudness;
    oLoudnessStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oLoudnessStatus.Channel.enType =  midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

    fi_tclVisitorMessage oCCaMsg(oLoudnessStatus);

    oLoudnessStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}


tBool SoundHandler::bSendEquPresetStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgEqualiserPresetStatus oEquPresetStatus;

    oEquPresetStatus.EquPreset.enType = (midw_fi_tcl_e8_EquPresets::tenType)m_u8EquPreset;
    oEquPresetStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    fi_tclVisitorMessage oCCaMsg(oEquPresetStatus);

    oEquPresetStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

tBool SoundHandler::bSendAuxInLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgAuxInLevelStatus oAuxInLevelStatus;
    tBool bRetVal = false;

    oAuxInLevelStatus.AuxInLevel.enType = (midw_fi_tcl_e8_AuxInLevel::tenType)m_u8AuxIn;
    // ToDo Hardcoded or keep it in a member from MethodStart

    fi_tclVisitorMessage oCCaMsg(oAuxInLevelStatus);
    // Always destroy the FI data object before leaving its creation scope
    oAuxInLevelStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendBeepLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgBeepLevelStatus oBeepLevelStatus;
    tBool bRetVal = false;

    oBeepLevelStatus.BeepLevel.enType = (midw_fi_tcl_e8_BeepLevel::tenType)m_u8BeepLevel;
    // ToDo Hardcoded or keep it in a member from MethodStart

    fi_tclVisitorMessage oCCaMsg(oBeepLevelStatus);
    // Always destroy the FI data object before leaving its creation scope
    oBeepLevelStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

tBool SoundHandler::bSendDynamicCompressionStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgDynamicCompressionStatus oDynamicCompressionStatus;

    oDynamicCompressionStatus.DynCompression.enType = (midw_fi_tcl_e8_DynCompression::tenType)m_u8DynCompression;
    oDynamicCompressionStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    fi_tclVisitorMessage oCCaMsg(oDynamicCompressionStatus);

    oDynamicCompressionStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::bSendMeMSoundStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/

tBool SoundHandler::bSendMeMSoundStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgMemSoundStatus oMemSoundStatus;

    oMemSoundStatus.Sound.enType = midw_fi_tcl_e8_Sound::FI_EN_AUDIO_SOUND_VOLUME;
    oMemSoundStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oMemSoundStatus.MemStatus.enType =midw_fi_tcl_e8_MemStatus::FI_EN_AUDIO_MEMSTATUS_SUCCESS;

    fi_tclVisitorMessage oCCaMsg(oMemSoundStatus);

    oMemSoundStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::bSendOptimizationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/

tBool SoundHandler::bSendOptimizationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgOptimizationStatus oOptimizationStatus;

    oOptimizationStatus.Optimization.enType = (midw_fi_tcl_e8_Optimization::tenType)m_u8Optimization;
    oOptimizationStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    fi_tclVisitorMessage oCCaMsg(oOptimizationStatus);

    oOptimizationStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandler::bSendPDCAttenuationLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/
tBool SoundHandler::bSendPDCAttenuationLevelStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgPDCAttenuationLevelStatus oPDCAttenuationLevelStatus;

    oPDCAttenuationLevelStatus.PDCAttenuationLevel = 0;

    fi_tclVisitorMessage oCCaMsg(oPDCAttenuationLevelStatus);

    oPDCAttenuationLevelStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

/*******************************************************************************
 *
 * FUNCTION: SoundHandlerStatus::bSendPDCAttenuationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/
tBool SoundHandler::bSendPDCAttenuationStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgPDCAttenuationStatus oPDCAttenuationStatus;

    oPDCAttenuationStatus.PDCAttenuation.enType = midw_fi_tcl_e8_PDCAttenuation::FI_EN_AUDIO_PDC_COMMAND_STOP;

    fi_tclVisitorMessage oCCaMsg(oPDCAttenuationStatus);

    oPDCAttenuationStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}
/*******************************************************************************
 *
 * FUNCTION:SoundHandler::bSendRearMuteStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData*  poInMsg)
 *
 *******************************************************************************/
tBool SoundHandler::bSendRearMuteStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    ETG_TRACE_USR4(("bSendRearMuteStatus entered"));
    midw_mascffi_tclMsgRear_MuteStatus oRearMuteStatus;
    oRearMuteStatus.Rear_Mute.enType = (midw_fi_tcl_e8_Rear_Mute::tenType)m_u8RearMute;
    fi_tclVisitorMessage oCCaMsg(oRearMuteStatus);
    oRearMuteStatus.vDestroy();
    return oCCaMsg.bHandOver(&roOutMsg);

}
/*******************************************************************************
 *
 * FUNCTION:SoundHandler::bSendGeometryMode(amt_tclServiceData& roOutMsg, amt_tclServiceData*  poInMsg)
 *
 *******************************************************************************/
tBool SoundHandler::bSendGeometryMode(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    ETG_TRACE_USR4(("bSendGeometryMode entered"));
    midw_mascffi_tclMsgGeometry_ModeStatus oGeoModeStatus;
    oGeoModeStatus.Geometry_Mode.enType = (midw_fi_tcl_e8_Geometry_Mode::tenType)m_u8GeometryMode;
    fi_tclVisitorMessage oCCaMsg(oGeoModeStatus);
    oGeoModeStatus.vDestroy();
    return oCCaMsg.bHandOver(&roOutMsg);

}

tBool SoundHandler::bSendRoomEffectStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    midw_mascffi_tclMsgRoomEffectStatus oRoomEffectStatus;

    oRoomEffectStatus.RoomEffect.enType = (midw_fi_tcl_e8_RoomEffect::tenType)m_u8RoomEffect;
    oRoomEffectStatus.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    fi_tclVisitorMessage oCCaMsg(oRoomEffectStatus);

    oRoomEffectStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}


tBool SoundHandler::bSendFMEnhancerStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    midw_mascffi_tclMsgFMEnhancerModeStatus oFMEnhancerStatus;
    oFMEnhancerStatus.FMEnhancer = m_bFMEnhancer;

    fi_tclVisitorMessage oCCaMsg(oFMEnhancerStatus);

    oFMEnhancerStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
#else
    (void)roOutMsg;
    return TRUE;
#endif
}

tBool SoundHandler::bSendAutomaticGainControlStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    midw_mascffi_tclMsgAutomaticGainControlStatus oAGCModeStatus;
    oAGCModeStatus.AutomaticGainControl = m_bAGCMode;

    fi_tclVisitorMessage oCCaMsg(oAGCModeStatus);

    oAGCModeStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
#else
    (void)roOutMsg;
    return TRUE;
#endif
}
/********************************************************************************
 * bSendDiagDefSetPhaseStatus().
 *******************************************************************************/
tBool SoundHandler::bSendDiagDefSetPhaseStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
    ETG_TRACE_USR4(("bSendDiagDefSetPhaseStatus entered"));
    midw_mascffi_tclMsgDiagDefSetPhaseStatus oDiagDefSetStatus;
    oDiagDefSetStatus.DefSetPhase.enType = (midw_fi_tcl_e8_AudDiagDefSetPhase::tenType)m_DiagDefsetPhase;

    fi_tclVisitorMessage oCCaMsg(oDiagDefSetStatus);

    oDiagDefSetStatus.vDestroy();

    return oCCaMsg.bHandOver(&roOutMsg);
}

tBool SoundHandler::bSendAudioPilotModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  midw_mascffi_tclMsgAudioPilotModeStatus oAudPilotModeStatus;
  oAudPilotModeStatus.AudPilotMode = m_bAudioPilotMode;

    fi_tclVisitorMessage oCCaMsg(oAudPilotModeStatus);

    oAudPilotModeStatus.vDestroy();

   return oCCaMsg.bHandOver(&roOutMsg);
   #else
   (void)roOutMsg;
   return TRUE;
   #endif
}

tBool SoundHandler::bSendAudioPilotIntensityStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */)const
{
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  midw_mascffi_tclMsgAudioPilotIntensityStatus oAudPilotIntensityStatus;
  oAudPilotIntensityStatus.Audio_Pilot_Intensity.enType = (midw_fi_tcl_e8_AudioPilotIntensity::tenType)m_u8AudioPilotIntensity;

    fi_tclVisitorMessage oCCaMsg(oAudPilotIntensityStatus);

    oAudPilotIntensityStatus.vDestroy();

   return oCCaMsg.bHandOver(&roOutMsg);
   #else
   (void)roOutMsg;
   return TRUE;
   #endif
}

/********************************************************************************
 * vOnApplicationClose().
 *******************************************************************************/
tVoid SoundHandler::vOnApplicationClose()
{

    ETG_TRACE_USR4(("vOnApplicationClose() entered."));

    return;
}


/********************************************************************************
 * vTraceRx(tPCUChar pcu8Data)
 *******************************************************************************/
tVoid SoundHandler::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
    tU8 u8InstId;
    tU16 u16FktId;
    tU8 u8OpType;
    tU16 u16MsgLen;
    tU8 *pu8MsgData;

    ETG_TRACE_USR4(("vTraceRx() entered."));

    if(pcu8Data == NULL) return;

    if (size > 2)
    {
        switch ( pcu8Data[1] )
        {
        case TRC::SendAdrData:
            ETG_TRACE_USR4(("Received SetAdrData"));

            u8InstId     = pcu8Data[2];
            u16FktId   = pcu8Data[3];
            u8OpType   = pcu8Data[5];
            u16MsgLen   = pcu8Data[6];
            pu8MsgData= const_cast<tU8 *>(&pcu8Data[8]);
            ETG_TRACE_USR4(("vTraceRx() u8InstId = 0x%x",(tU16)u8InstId));
            ETG_TRACE_USR4(("vTraceRx() u16FktId = 0x%x",(tU16)u16FktId));
            ETG_TRACE_USR4(("vTraceRx() u8OpType = 0x%x",(tU16)u8OpType));
            ETG_TRACE_USR4(("vTraceRx() u16MsgLen= 0x%x",(tU16)u16MsgLen));
            ETG_TRACE_USR4(("pu8MsgData=0x%02x",ETG_LIST_LEN(u16MsgLen), ETG_LIST_PTR_T8(pu8MsgData)));
            break;
        case TRC::AmpAvailability:
            vHandleTraceAmpAvailabilityInput(pcu8Data);
            break;
        default:
            ETG_TRACE_USR4(("default"));
            break;
        }
    }

    return;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void SoundHandler::vAddObserver()
{

    ETG_TRACE_USR3(("SoundHandler::vAddObserver"));

    if(pPO != NULL)
    {
        ETG_TRACE_USR3(("SoundHandler::vAddObserver  pPO != NULL"));

        // add notifiers
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetDiagFader);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetDiagBalance);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagRemoteControl);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ArkamysModeSet);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ProfileDataChanged);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ExtAmpSettingsStatus);
        pPO->POMessages->AddObserver(this, PO_MessageConfig::IDCCAUPATempMute);
    }
    else
    {
        FATAL_M_ASSERT_ALWAYS();
    }
}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/

void SoundHandler::MessageNotification(PO_MessageConfig::enID MsgId)
{
    ETG_TRACE_USR3(("SoundHandler::MessageNotification entered. "));

    tenDiagDefSetType  enDefSetType;
    tenDiagDefSetPhase enDefSetPhase;

    switch(MsgId)
    {
    case PO_MessageConfig::ID_DiagDefSet:
    {
        // Obtaining the Diag DefSet
        const ID_DiagDefSet* pMsgDefSet = pPO->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
        ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));

        enDefSetType = pMsgDefSet->enDiagDefSetType;
        enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;
        m_DiagDefsetPhase = (tU8)enDefSetPhase;   // storing DefsetPhase Value received Diaglibhandler to send to the clients.
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
        if((enDefSetType == EN_DEFSET_CODING) && (enDefSetPhase == EN_DEFSET_SET))
            vCheckSWAvailabilility();
#endif
        if(enDefSetType == EN_DEFSET_HMI || enDefSetType == EN_USER_CHANGE || enDefSetType == EN_DEFSET_TEF)
        {
            if(enDefSetPhase == EN_DEFSET_PREPARE)
            {
                ETG_TRACE_USR4(("DefSet HMI received EN_DEFSET_PREPARE -> no action"));
                // updating clients of Defset Prepare status
                if(poAudioService != NULL && enDefSetType != EN_USER_CHANGE)
                    poAudioService->updateClients(MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE);
            }
            else if(enDefSetPhase == EN_DEFSET_SET)
            {
                ETG_TRACE_USR4(("DefSet HMI received EN_DEFSET_SET -> no action"));
            }
            else if(enDefSetPhase == EN_DEFSET_FINISH)
            {
                ETG_TRACE_USR4(("DefSet HMI received EN_DEFSET_FINISH -> vOnLoadSettings()"));
                vOnLoadSettings();
                //Bugfix 526405
                if(m_bIsExtAmpConnected)
                   vOnLoadExtAmpSettingsList();

                // updating clients of Defset finished status
                if(poAudioService != NULL && enDefSetType != EN_USER_CHANGE)
                    poAudioService->updateClients(MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE);
            }
        }
    }
        break;

    case PO_MessageConfig::ID_SetDiagFader:
    {
        if(SoundHandler::RemoteControlFlag == true)
        {
            const ID_SetDiagFader* pMsgAudSetting = pPO->POMessages->QueryMessage<ID_SetDiagFader>(MsgId);
            ETG_TRACE_USR4(("ID_SetDiagFader received fader Value = %x", pMsgAudSetting->sFaderValue));
            m_s8Fader = pMsgAudSetting->sFaderValue;
            //deliver to vd_adr
            MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_FADER, (tS16)m_s8Fader);

            if(InternalCommunicationAdapter::getInstance() != NULL && InternalCommunicationAdapter::getInstance()->POMessages != NULL)
                InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

            if(poAudioService)
                poAudioService->updateClients(MIDW_MASCFFI_C_U16_FADER);
        }
    }
        break;
    case PO_MessageConfig::ID_SetDiagBalance:
    {
        if(SoundHandler::RemoteControlFlag == true)
        {
            const ID_SetDiagBalance* pMsgAudSetting = pPO->POMessages->QueryMessage<ID_SetDiagBalance>(MsgId);
            if(pMsgAudSetting != NULL)
            {
                ETG_TRACE_USR4(("ID_SetDiagBalance received Balance Value = %x", pMsgAudSetting->sBalanceValue));
                m_s8Balance = pMsgAudSetting->sBalanceValue;
            }
            //deliver to vd_adr
            MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_BALANCE, (tS16)m_s8Balance);

            if(InternalCommunicationAdapter::getInstance() != NULL && InternalCommunicationAdapter::getInstance()->POMessages != NULL)
                InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

            if(poAudioService)
                poAudioService->updateClients(MIDW_MASCFFI_C_U16_BALANCE);
        }
    }
        break;

    case PO_MessageConfig::ID_DiagRemoteControl:
    {
        const ID_DiagRemoteControl* pMsgRemoteControl = pPO->POMessages->QueryMessage<ID_DiagRemoteControl>(MsgId);
        ETG_TRACE_USR4(("DefSet received Type = %x", pMsgRemoteControl->enDiagRemoteControlPhase));
        if(pMsgRemoteControl->enDiagRemoteControlPhase == EN_REMOTECONTROL_UNFREEZE)
        {
            SoundHandler::RemoteControlFlag =false;
            vLoadBalanceFaderSettings();
        }
        else if(pMsgRemoteControl->enDiagRemoteControlPhase == EN_REMOTECONTROL_SET)
            SoundHandler::RemoteControlFlag = true;
    }
        break;

    case PO_MessageConfig::ID_ArkamysModeSet:
    {
        const ID_ArkamysModeSet* pMsgArkamysMode = pPO->POMessages->QueryMessage<ID_ArkamysModeSet>(MsgId);
        ETG_TRACE_USR4(("Arkamys Mode Set received = %x", pMsgArkamysMode->arkamysMode));

        if(pMsgArkamysMode->arkamysMode == EN_ARKAMYS_PREMIUM1)
            vOnLoadSettings(MIDW_MASCFFI_C_U16_ROOMEFFECT);
    else if (pMsgArkamysMode->arkamysMode == EN_ARKAMYS_AUDITORIUM)
    {
      m_bAGCAvailability = true;
      vOnLoadSettings(MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL);
    }

    }
        break;

    case PO_MessageConfig::ID_ProfileDataChanged:
    {
        const MSG_ProfileDataChanged* pMsgProfileData = pPO->POMessages->QueryMessage<MSG_ProfileDataChanged>(MsgId);
        if(pMsgProfileData)
        {
            if(MSG_ProfileDataChanged::DATA_CHANGE_PROFILE_CHANGED == pMsgProfileData->m_enDataChangedType)
            {
                vOnLoadUserSettings();
                //Bugfix 526405
                if(m_bIsExtAmpConnected)
                   vOnLoadExtAmpSettingsList();
            }
        }
    }
        break;

      case PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus:
      {
        const ID_BOSE_Amplifier_ConnectionStatus* pExtAmpConnState = pPO->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
        m_bIsExtAmpConnected = (tBool)pExtAmpConnState->connectionstate;
        if(m_bIsExtAmpConnected)
        {
          //send sound settings list
          vOnLoadExtAmpSettingsList();
        }
        break;
      }
      case PO_MessageConfig::ID_ExtAmpSettingsStatus:
      {
        if(m_bIsExtAmpConnected)//handle status message only if ext amplifier is connected
        {
          const ID_ExtAmpSettingsStatus* pExtAmpConnState = pPO->POMessages->QueryMessage<ID_ExtAmpSettingsStatus>(MsgId);
          vStoreAndUpdateExtAmpSettings(pExtAmpConnState->u8SettingType, pExtAmpConnState->s8Value);
        }
        break;
      }
      case PO_MessageConfig::IDCCAUPATempMute:
        {
        const IDCCAUPATempMute* pUPATempMuteState = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<IDCCAUPATempMute>(MsgId);
        m_bUpaMuteState = pUPATempMuteState->m_UPATempMute;
        break;
      }
    default:
        ETG_TRACE_USR3(("SoundHandler::MessageNotification unknown Message %x",MsgId));
        break;
    }
}

tVoid SoundHandler::vLoadBalanceFaderSettings()
{
    if(pAudUsrDpIf && poAudioService && (InternalCommunicationAdapter::getInstance()->POMessages != NULL))
    {
        tS32 s32Res=0;

        if(vCheckPropertyAvailablility(m_s8Fader,m_bFaderAvailability))
        {
            s32Res = pAudUsrDpIf->s32GetFader(m_s8Fader);
            ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Fader=%d Result=%d",(tS16)m_s8Fader,s32Res));
        }

        if(vCheckPropertyAvailablility(m_s8Balance,m_bBalanceAvailability))
        {
            s32Res = pAudUsrDpIf->s32GetBalance(m_s8Balance);
            ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Balance=%d Result=%d",(tS16)m_s8Balance,s32Res));
        }

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
        s32Res = pAudUsrDpIf->s32GetGeometryMode(m_u8GeometryMode);
        ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Geometry MODE=%d, Result=%d",(tS16)m_u8GeometryMode,s32Res));

        if(midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_CHILD_SLEEP == m_u8GeometryMode)
        {
            if(vCheckPropertyAvailablility(m_s8Fader,m_bFaderAvailability))
                m_s8Fader = FaderMax_Value; //set fader to front
            m_s8Balance = 0; // balance is set to middle i.e,0
            ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Balance=%d, Fader=%d due to GEOMETRY_MODE_CHILD_SLEEP",(tS16)m_s8Balance,(tS16)m_s8Fader));
        }
        else if(midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_ALL_CAR == m_u8GeometryMode)
        {
            m_s8Fader = 0; //set fader to middle i.e,0
            m_s8Balance = 0;  // balance is set to middle i.e,0
            ETG_TRACE_USR4(("SoundHandler vLoadBalanceFaderSettings() Balance=%d, Fader=%d due to GEOMETRY_MODE_ALL_CAR",(tS16)m_s8Balance,(tS16)m_s8Fader));
        }
#endif

        MSG_Settings oSettingsBalance(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_BALANCE, (tS16)m_s8Balance);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsBalance);

        MSG_Settings oSettingsFader(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_FADER, (tS16)m_s8Fader);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsFader);

        poAudioService->updateClients(MIDW_MASCFFI_C_U16_FADER);
        poAudioService->updateClients(MIDW_MASCFFI_C_U16_BALANCE);
    }
}

tVoid SoundHandler::vStoreAndSendBassPOMsg(tS8 s8Bass)
{
   if(pAudUsrDpIf)
   {
      if(vCheckPropertyAvailablility(s8Bass,m_bBassAvailability) && (!m_bIsExtAmpConnected))//if ext amplifier is connected do not store into DP
      {
         //store persistent
       m_s8Bass = s8Bass;
         tS32 s32Res = pAudUsrDpIf->s32SetBass(m_s8Bass);
         ETG_TRACE_USR4((" s32Res: %d", s32Res));
      }

      ETG_TRACE_USR4(("ADR Bass value = %x",s8Bass));

      //deliver to vd_adr
      MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_BASS, (tS16)s8Bass);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);
   }
}

tVoid SoundHandler::vStoreAndSendTreblePOMsg(tS8 s8Treble)
{
   if(pAudUsrDpIf)
   {
      if(vCheckPropertyAvailablility(s8Treble,m_bTrebleAvailability) && (!m_bIsExtAmpConnected))//if ext amplifier is connected do not store into DP
      {
         m_s8Treble = s8Treble;
        //store persistent
         tS32 s32Res = pAudUsrDpIf->s32SetTreble(m_s8Treble);
         ETG_TRACE_USR4(("Persistent Memory storage Result for TReble = %x",s32Res));//to solve compiler error
      }
      //deliver to vd_adr
      MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_TREBLE, (tS16)s8Treble);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);
   }
}

tBool SoundHandler::bStoreAndSendBalancePOMsg(tS8 s8Balance)
{
if (pAudUsrDpIf)
  {
    if (vCheckPropertyAvailablility(s8Balance, m_bBalanceAvailability) && (!m_bIsExtAmpConnected))//if ext amplifier is connected do not store into DP
    {
      //store persistent

      tS32 s32Res = pAudUsrDpIf->s32SetBalance(s8Balance);
      ETG_TRACE_USR4(("Persistent Memory storage Result for Balance = %x", s32Res));//to solve compiler error
    }
    ETG_TRACE_USR4(("Geometry mode is = %x", m_u8GeometryMode));
    if (m_u8GeometryMode == midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_MANUAL)
    {
      ETG_TRACE_USR4(("Delivering PO MSg"));
      m_s8Balance = s8Balance;
      MSG_Settings oSettingsBalance(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_BALANCE, (tS16)m_s8Balance);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsBalance);
    }
  }

   return TRUE;
}

tBool SoundHandler::bStoreAndSendFaderPOMsg(tS8 s8Fader)
{
  if (pAudUsrDpIf)
  {
    if (vCheckPropertyAvailablility(s8Fader, m_bFaderAvailability) && (!m_bIsExtAmpConnected))//if ext amplifier is connected do not store into DP
    {

      tS32 s32Res = pAudUsrDpIf->s32SetFader(s8Fader);
      ETG_TRACE_USR4(("Persistent Memory storage Result for FAder = %x", s32Res));//to solve compiler error
    }
    ETG_TRACE_USR4(("Geometry mode is = %x", m_u8GeometryMode));
    if (m_u8GeometryMode == midw_fi_tcl_e8_Geometry_Mode::FI_EN_AUDIO_GEOMETRY_MODE_MANUAL)
    {
      ETG_TRACE_USR4(("Delivering PO MSg"));
      m_s8Fader = s8Fader;
      MSG_Settings oSettingsFader(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_FADER, (tS16)m_s8Fader);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettingsFader);
    }
  }

  return TRUE;
}

tVoid SoundHandler::vStoreAndSendMidRangePOMsg(tS8 s8MidRange)
{
   if(pAudUsrDpIf)
   {
      //store persistent
      if(vCheckPropertyAvailablility(s8MidRange,m_bMidRangeAvailability) && (!m_bIsExtAmpConnected))//if ext amplifier is connected do not store into DP
      {
         m_s8MidRange = s8MidRange;
       tS32 s32Res = pAudUsrDpIf->s32SetMidRange(m_s8MidRange);
         ETG_TRACE_USR4(("Persistent Memory storage Result for MidRange = %x",s32Res));
      }

      //deliver to vd_adr
      MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_MID, (tS16)s8MidRange);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);
   }
}

tVoid SoundHandler::vStoreBeepLevel(tU8)
{
    if(pAudUsrDpIf)
    {
        //store persistent
        tS32 s32Res = pAudUsrDpIf->s32SetBeepLevel(m_u8BeepLevel);
        ETG_TRACE_USR4(("Persistent Memory storage Result for BeepLevel = %x",s32Res));//to solve compiler error
    }
}

tVoid SoundHandler::vStoreAndSendEquPresetPOMsg(tU8)
{
    if(pAudUsrDpIf)
    {
        //store persistent
        tS32 s32Res = pAudUsrDpIf->s32SetEquPreset(m_u8EquPreset);

        ETG_TRACE_USR4(("Persistent Memory storage Result for EquPreset = %x",s32Res));

        //deliver to vd_adr
        MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_EQUPRESET, (tS16)m_u8EquPreset);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);
    }
}

tVoid SoundHandler::vStoreAndSendOptimizationPOMsg(tU8)
{
    if(pAudUsrDpIf)
    {
        //store persistent
        tS32 s32Res = pAudUsrDpIf->s32SetOptimization(m_u8Optimization);

        ETG_TRACE_USR4(("Persistent Memory storage Result for Optimization = %x",s32Res));

        //deliver to vd_adr
        MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_OPTIMIZATION, (tS16)m_u8Optimization);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);
    }
}

tBool SoundHandler::vCheckPropertyAvailablility(tS8& sPtyValue,tBool sPtyAvail)
{
    if(!sPtyAvail)
    {
        sPtyValue = 0;
        return FALSE;
    }
    return TRUE;
}

tVoid SoundHandler::vStoreAndUpdateExtAmpSettings(tU8 u8Type, tS8 s8Steps)
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poAudioService);
  ETG_TRACE_USR4(("vStoreAndUpdateExtAmpSettings status entered for type = %x with steps : %x",u8Type, s8Steps));
  switch(u8Type)
  {
  case EN_AUDIO_SETTINGS_BASS:
  {
    m_s8Bass = s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetBass(m_s8Bass);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Bass = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_BASS);
    break;
  }

  case EN_AUDIO_SETTINGS_MID:
  {
    m_s8MidRange = s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetMidRange(m_s8MidRange);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Mid Range = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_MIDRANGE);
    break;
  }
  case EN_AUDIO_SETTINGS_TREBLE:
  {
    m_s8Treble = s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetTreble(m_s8Treble);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Treble = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_TREBLE);
    break;
  }
  case EN_AUDIO_SETTINGS_BALANCE:
  {
    m_s8Balance = s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetBalance(m_s8Balance);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Balance = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_BALANCE);
    break;
  }
  case EN_AUDIO_SETTINGS_FADER:
  {
    m_s8Fader = s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetFader(m_s8Fader);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Fader = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_FADER);
    break;
  }
  case EN_AUDIO_SETTINGS_ROOM_EFFECT:
  {
    m_u8RoomEffect = (tU8)s8Steps;
    m_u8RoomEffect = (tU8)(m_u8RoomEffect-1); //gen4 prio3 compiler warning fix
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetRoomEffect(m_u8RoomEffect);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Room Effect = %x",s32Res));
      poAudioService->updateClients(MIDW_MASCFFI_C_U16_ROOMEFFECT);
    break;
  }
  case EN_AUDIO_SETTINGS_AUDIO_PILOT_MODE:
  {
    m_bAudioPilotMode = static_cast<tBool>(s8Steps & 0x01);
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetAudioPilotMode(m_bAudioPilotMode);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Audio Pilot Mode = %x",s32Res));
    poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUDIOPILOTMODE);
    break;
  }
  case EN_AUDIO_SETTINGS_AUDIO_PILOT_INTENSITY:
  {
    m_u8AudioPilotIntensity = (tU8)s8Steps;
    //store persistent and update to HMI
    tS32 s32Res = pAudUsrDpIf->s32SetAudioPilotIntensity(m_u8AudioPilotIntensity);
    ETG_TRACE_USR4(("Persistent Memory storage Result for Audio Pilot Intensity = %x",s32Res));
    poAudioService->updateClients(MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY);
    break;
  }
  default:
    ETG_TRACE_USR1(("Not an external amplifier sound setting"));
    break;
  }
}

tVoid SoundHandler::vOnLoadExtAmpSettingsList()
{
  ETG_TRACE_USR4(("vOnLoadExtAmpSettingsList entered"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);

  tU8 u8AmpSettingsList[8] = { 0, 0, 0, 0, 0, 0, 0, 0};
  u8AmpSettingsList[0] = m_s8Bass;
  u8AmpSettingsList[1] = m_s8MidRange;
  u8AmpSettingsList[2] = m_s8Treble;
  u8AmpSettingsList[3] = m_s8Balance;
  u8AmpSettingsList[4] = m_s8Fader;
  //5 - reserved bit
  u8AmpSettingsList[5] = 0;

  tU8 u8UPAMuteOrder = (tU8)m_bUpaMuteState;//to be set to mute - off by default
  u8UPAMuteOrder = (tU8)(u8UPAMuteOrder <<3); //gen4 prio3 compiler warning fix
  u8AmpSettingsList[6] |= u8UPAMuteOrder;

  tU8 u8UPASoundState = 0x01;
  pAudUsrDpIf->s32GetSRSoundState(u8UPASoundState);
  u8UPASoundState = (tU8)(u8UPASoundState <<4); //gen4 prio3 compiler warning fix
  u8AmpSettingsList[6] |= u8UPASoundState;

  tU8 AudPilotIntensity = m_u8AudioPilotIntensity;
  AudPilotIntensity = (tU8)(AudPilotIntensity <<5);  //gen4 prio3 compiler warning fix
  u8AmpSettingsList[6] |= AudPilotIntensity;

  tBool AudPilotMode = m_bAudioPilotMode;
  AudPilotMode = (tBool) (AudPilotMode <<7);  //gen4 prio3 compiler warning fix
  u8AmpSettingsList[6] |= AudPilotMode;//one bit audio-pilot off/on

  tU8 u8UPASoundType = 0x01;
  pAudUsrDpIf->s32GetUPASoundtype(u8UPASoundType);
  u8AmpSettingsList[7] = u8UPASoundType;

  tU8 RoomEffect = (tU8)(m_u8RoomEffect + 1);  //gen4 prio3 compiler warning fix
  RoomEffect = (tU8)(RoomEffect <<4);      //gen4 prio3 compiler warning fix
  u8AmpSettingsList[7] |= RoomEffect;

  ETG_TRACE_USR4(("vOnLoadExtAmpSettingsList RawData: %x ",ETG_LIST_LEN(8), ETG_LIST_PTR_T8(u8AmpSettingsList)));

  ID_ExtAmpSettingsList oExtAmpSettingList;
  oExtAmpSettingList.u8SettingValues = u8AmpSettingsList;
  oExtAmpSettingList.u16Length = sizeof(u8AmpSettingsList);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oExtAmpSettingList);

}
