/**
 * @file ArkamysTuningHandlerRNAIVI2.h
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSTUNINGHANDLERRNAIVI2_H_
#define ARKAMYSTUNINGHANDLERRNAIVI2_H_


#include "ITuningDataClient.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "InternalComponentCommunication/Messages/mute/IDNotifyMute.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
#include "mute/stream/StreamMute_IF.h"
#include "mute/stream/StreamMute.h"
//#include "mute/stream/StreamMuteNotify_IF.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_NotifyVolume.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysMode.h"
//#include "util/Macro.h"

#define CMD_ID_INDEX (0)
#define PROC_ID_INDEX (1)
#define LIB_ID_INDEX (2)

#define TUNING_DATA_SERVICE_RESPONSE_HEADER_SIZE_IVI (7)
#define TUNING_MSG_FOOTER_VALUE (0xEE)
#define TUNING_BOSCH_LIB_ERROR_CODE (0xFFFF)
#define TUNING_DATA_OFFSET_IVI2 (4)
#define CONFIG_DATA_FUNC_LEN (5)
#define LENGTH_OFFSET (8)
#define ARKAMYS_SAT_SET_ID (1)
#define ARKAMYS_SAT_GET_ID (2)
/*
#define SWAP_32(_a) \
   (((_a       & 0xFF) << 24) | \
    ((_a >>  8 & 0xFF) << 16) | \
    ((_a >> 16 & 0xFF) <<  8) | \
    ((_a >> 24 & 0xFF)      ))
*/
class ArkamysTuningHandlerRNAIVI2 : public ITuningDataClient, public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   static ArkamysTuningHandlerRNAIVI2* getInstance();
   tVoid DataRx(tU32 size, tVoid* pData, tU8 txHandle);
   tVoid PublicParamMessageRx(tU8 u8PublicParam, tU8 u8data);
   virtual ~ArkamysTuningHandlerRNAIVI2();
   tVoid vAdrOkCallback();
   tVoid SbrMessageRx(tU8 u8OpType, tU8* u8data, tU16 u16length);
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

private:

   enum tenAdrErrorCode {
      ADR_ERR_WRONG_LENGTH          = 0x05,
      ADR_ERR_PARAM_OUT_OF_RANGE    = 0x06
   };

   enum tenTuningCommandID {
     TUNING_OpenCmd = 0x01,
     TUNING_CloseCmd = 0x02,
     TUNING_WriteCmd = 0x03,
     TUNING_ReadCmd = 0x04,
     TUNING_AckCmd = 0x10
   };

   enum tenTuningProcID {
     Tuning_Proc_Public = 0x00,
     Tuning_Proc_ARM = 0x01
   };

   enum tenTuningProcLibID {
     Tuning_Lib_Volume = 0x00,
     Tuning_Lib_Mute = 0x01
   };

   ArkamysTuningHandlerRNAIVI2();

   /**********variables**********/
   tU32 m_u32Size;
   tU8 *m_pU8Data;
   tU8 m_txHandle;
   tBool m_bHandleValid;
   tBool m_bCommExists; // used to check the communication has started
   tU8   m_u8MuteRegId;

   tBool m_bARMSetReq;
   tBool m_bARMGetReq;
   /**************flags to public parameters***********************/
   tBool m_bVolGetReq;
   tBool m_bMuteGetReq;
   tBool m_bMuteSetReq;

   /******functions******/
   tVoid vSendResponseToClient(tU32 u32FileLength);
   tVoid vSendAckToClient(tU8 u8CommandID);
   tVoid vSendErrToClient(tS16 s16ErrorCode);
   tVoid vSendData(); // entry function for sending data to ARM and public parameters
   tVoid vSendARMData();//ARM parameters
   tVoid vSendPublicParamData(); //public parameters

   tVoid vSendVolume();
   tVoid vSendMute();

   tVoid Mute(tU8 muteReqId);
   tVoid Demute(tU8 muteReqId);


   /************setter functions****************/
   tVoid vSetVolume();
   tVoid vSetMuteDemute();
   tVoid vSetARMData();

   /************getter functions****************/
   tVoid vGetVolume();
   tVoid vGetMuteDemute();
   tVoid vGetARMData();

};

#endif /* ARKAMYSTUNINGHANDLERRNAIVI_H_ */
