/*******************************************************************************
 * FILE:          aud_lpmsg_data_stream.h
 * SW-COMPONENT:  fc_audiomanager application
 * PROJECT:
 * DESCRIPTION:   LOOP Back message trc channel input style
 * AUTHOR:
 * COPYRIGHT:    (c) 2016 Robert Bosch Car Multimedia GmbH, Hildesheim
 *******************************************************************************/

#ifndef AUD_TCL_LOOPBACKMSG_TRC_CHANNEL_H_IF_INCLUDE_
#define AUD_TCL_LOOPBACKMSG_TRC_CHANNEL_H_IF_INCLUDE_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "fc_audiomanager_trace.h"
#include "../aud_tcl_loopback_IF.h"
/**
* Class that loops back a stream of bytes and sends it back to the caller using vTraceRx Functions
*/
class aud_lpmsg_ttfis_data_stream : public aud_tcl_loopback_IF
{
private:
  aud_lpmsg_ttfis_data_stream();
  aud_lpmsg_ttfis_data_stream(const aud_lpmsg_ttfis_data_stream&);

  tU32    m_u32Size;//Hold size locally
  tU8*    m_pcu8Data;//Pointer
  fc_audiomanager_tclTraceChannel* m_poTrace;

public:
  aud_lpmsg_ttfis_data_stream(tU32 u32Size, tPCUChar pcu8Data, fc_audiomanager_tclTraceChannel* _poTrace);
  ~aud_lpmsg_ttfis_data_stream();
  virtual void vExecute();
};

#endif /** AUD_TCL_LOOPBACKMSG_TRC_CHANNEL_H_IF_INCLUDE_ */


