/*******************************************************************************
 *
 * FILE:          aud_lpmsg_ttfis_data_stream.cpp
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Loop back message which is sent back through the ttfis data stream approach (vTraceRx Function)
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "aud_lpmsg_ttfis_data_stream.h"
#include <string.h>

/**
* Constructor
*/
aud_lpmsg_ttfis_data_stream::aud_lpmsg_ttfis_data_stream(tU32 u32Size, tPCUChar pcu8Data,fc_audiomanager_tclTraceChannel* _poTrace)
:m_u32Size(u32Size),
m_pcu8Data(NULL),
m_poTrace(_poTrace)
{
  if(m_u32Size && pcu8Data && m_poTrace)
  {
    m_pcu8Data = new tU8[u32Size];
    if(m_pcu8Data)
    {
      memcpy(m_pcu8Data,pcu8Data,u32Size);
    }
    else
    {
      //Error here... out of memory
    }
  }
}
/**
* Destructor
*/
aud_lpmsg_ttfis_data_stream::~aud_lpmsg_ttfis_data_stream()
{
  if(m_pcu8Data)
  {
    delete[] m_pcu8Data;
    m_pcu8Data = NULL;
  }
  m_poTrace = NULL;
}

/**
* Dispatch function
*/
void aud_lpmsg_ttfis_data_stream::vExecute()
{
  if(m_poTrace)
  {
    //Invoke trace rx function
    m_poTrace->vTrace_Rx(m_u32Size,m_pcu8Data);
  }
}

