/*******************************************************************************
* FILE:          aud_tcl_loopback_mgr.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager loop back manager
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Microphone diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 13.04.16  | Ranjit Katuri           | Inital version
*******************************************************************************/

#ifndef AUD_TCL_LOOPBACK_MGR_H_INCLUDE_
#define AUD_TCL_LOOPBACK_MGR_H_INCLUDE_

//#define SYSTEM_S_IMPORT_INTERFACE_QUEUE
//#include <stl_pif.h>


#include <queue>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define LOOP_BACK_DISPATCH_BATCH_SIZE    ((tU32)30)

#include <pthread.h>
class aud_tcl_loopback_IF;
class fc_audiomanager_tclApp;

class aud_tcl_loopback_mgr
{
private:
  //Explicit privates
  aud_tcl_loopback_mgr();
  aud_tcl_loopback_mgr(const aud_tcl_loopback_mgr&);
  /**
  * MEMBER VARIABLES
  */
  fc_audiomanager_tclApp*        m_poMain;
  std::queue<aud_tcl_loopback_IF*>  m_lb_queue;//Queue to hold the loopback requests
  pthread_mutex_t            m_lb_queue_lock;//Mutex to guard queue
public:
  aud_tcl_loopback_mgr(fc_audiomanager_tclApp* );
  virtual ~aud_tcl_loopback_mgr();
  /**
  * This function is has to be triggered by different threads to loopback data
  * The below function is multi thread safe
  */
  bool   bSendDataforLoopBack(aud_tcl_loopback_IF* );
  /**
  * Function triggered after change of thread context
  */
  virtual void vDispatch();
};

#endif

