/*
 * DiagAudMode.h
 *
 *  Created on: Feb 11, 2013
 *      Author: sea6kor
 */

#ifndef DIAGAUDMODE_H_
#define DIAGAUDMODE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../ExternItf/CCA/FI_Message/FI_Includes.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../util/Macro.h"
#include "../InternalComponentCommunication/Messages/VolumeOffset/IDVolumeOffsetAux.h"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagLinearMode.h"
#include "../InternalComponentCommunication/Messages/Diag/IDCCAStartAudDiagMode.h"
#include "../InternalComponentCommunication/Messages/Maintenance/IDMaintenanceMode.h"
#include "../InternalComponentCommunication/Messages/Source/IDSetSource.h"
#include "../InternalComponentCommunication/Messages/Volume/ID_OnVolumeLimiter.h"

#include "../fc_audiomanager_trace.h"
#include "../fc_audiomanager_main.h"
#include "midw_fi_if.h"



class DiagAudMode:public IF_MessageObserver<PO_MessageConfig::enID>
{
private:
     midw_fi_tcl_e8_DiagAudMode   LinSet_DiagAud ;
     midw_fi_tcl_e8_GenericDiagAudMode LinSet_OnVolLtrMode;
     midw_fi_tcl_e8_GenericDiagAudMode LinSet_MuteRampMode;
     midw_fi_tcl_e8_GenericDiagAudMode LinSet_VolumeRampMode;
     midw_fi_tcl_e8_GenericDiagAudMode LinSet_ClippingMode;
     midw_fi_tcl_e8_GenericDiagAudMode LinSet_PresetMode;
        //Preset Mode not handled
     tenDiagLinearModePhase LinSet_DiagLinModePhase;
     tenStream Stream;
     tenAuxInLevel AuxLevel_Linear;
     tenAuxInLevel AuxLevel_Org;
     fc_audiomanager_tclService_Audio_Function* poAudioService;

public:
     InternalCommunicationAdapter* pPO; // Pointer for post office access
     DiagAudMode(fc_audiomanager_tclService_Audio_Function* poService);
     virtual ~DiagAudMode()
     {
       InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
       pPO = NULL;
       DiagAudMode::poAudioService = NULL;
     }

     virtual void MessageNotification(PO_MessageConfig::enID MsgId);
     void SetAudModeToLinear()const;
     void ResetAudModeToNonLinear()const;
     void addobserver();
     tBool bSendDiagAudModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const;


};






#endif /* DIAGAUDMODE_H_ */
