/*
 * DiagAudMode.cpp
 *
 *  Created on: Feb 11, 2013
 *      Author: sea6kor
 */


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/DiagAudMode.cpp.trc.h"
#endif
#include "../fc_audiomanager_service_Audio_Function.h"
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#include "DiagAudMode.h"

union ModeMask_Union
{
    tU16 ModeMask;
  struct ModeMask_Bits
        {
              tU8 Mute : 1 ;
              tU8 UserFilter : 1;
              tU8 CarFilter : 1;
              tU8 SourceSpecificFilter : 1;
              tU8 Clipping : 1;
              tU8 VolumeRamp : 1;
              tU8 UserOffsets :1;
              tU8 SourceOffsets :1;
              tU8 SDVCOffsets :1;
         }ModeMaskBits_Obj;

}ModeMaskUnion_Obj;


/*******************************************************************************
 *
 * FUNCTION: PropertyStatus::bSendDiagAudModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)

 *******************************************************************************/
tBool DiagAudMode::bSendDiagAudModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)const
 {
   (tVoid)poInMsg;
   (tVoid)roOutMsg;

   midw_mascffi_tclMsgDiagAudModeStatus oDiagAudModeStatus;
   tBool bRetVal = false;

   oDiagAudModeStatus.DiagAudMode = LinSet_DiagAud;
   oDiagAudModeStatus.OnVolLimiterMode = LinSet_OnVolLtrMode;
   oDiagAudModeStatus.MuteRampMode = LinSet_MuteRampMode;
   oDiagAudModeStatus.VolumeRampMode =  LinSet_VolumeRampMode;
   oDiagAudModeStatus.clippingMode = LinSet_ClippingMode;
   oDiagAudModeStatus.PresetMode = LinSet_PresetMode;

  fi_tclVisitorMessage oCCaMsg(oDiagAudModeStatus);

   oDiagAudModeStatus.vDestroy();
   bRetVal = oCCaMsg.bHandOver(&roOutMsg);
   return bRetVal;
 }



DiagAudMode::DiagAudMode(fc_audiomanager_tclService_Audio_Function* poService):IF_MessageObserver<PO_MessageConfig::enID>("DiagAudMode")
{

  LinSet_DiagAud.enType  = (midw_fi_tcl_e8_DiagAudMode::FI_EN_AUDIO_DIAG_AUD_MODE_NOT_DEF);
  DiagAudMode::poAudioService = poService;
  AuxLevel_Linear = EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL1;
  AuxLevel_Org = EN_AUDIO_VOLOFFSET_AUXINLEVEL_LEVEL1;

  pPO = InternalCommunicationAdapter::getInstance();
  addobserver();
//  Initialization
  Stream=EN_AUDIO_SOURCE_STREAM_DEFAULT; //coverity warning fix
  LinSet_DiagLinModePhase=EN_LINEARMODE_DEFAULT;
}

void DiagAudMode::addobserver()
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_AudDiagMode);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagLinearMode);
  pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetSource);

  ETG_TRACE_USR4(("DiagAudMode is added as observer for the PO Messages ID_CCAStart_AudDiagMode and ID_DiagLinearMode ")) ;
}


void DiagAudMode::SetAudModeToLinear()const
{
   ETG_TRACE_USR4(("SetAudModeToLinear called"));

   //Setting the bits for linear mode

   ModeMaskUnion_Obj.ModeMaskBits_Obj.Mute                 = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.UserFilter           = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.CarFilter            = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SourceSpecificFilter = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.Clipping             = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.VolumeRamp           = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.UserOffsets          = 1;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SourceOffsets        = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SDVCOffsets           = 1;

}

void DiagAudMode::ResetAudModeToNonLinear()const
{
  ETG_TRACE_USR4(("ResetAudModeToNonLinear called"));

   ModeMaskUnion_Obj.ModeMaskBits_Obj.Mute                 = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.UserFilter           = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.CarFilter            = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SourceSpecificFilter = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.Clipping             = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.VolumeRamp           = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.UserOffsets          = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SourceOffsets        = 0;
   ModeMaskUnion_Obj.ModeMaskBits_Obj.SDVCOffsets           = 0;
}

void DiagAudMode::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("Message Notification function for  DiagAudMode entered")) ;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (poAudioService);//SOlves lint warnings

  switch(MsgId)
  {
     case (PO_MessageConfig::ID_CCAStart_AudDiagMode):
      {
          const ID_CCAStart_AudDiagMode*   pMsg_DiagMode = pPO->POMessages->QueryMessage<ID_CCAStart_AudDiagMode>(MsgId);
        LinSet_DiagAud.enType = pMsg_DiagMode->DiagAud;
        LinSet_OnVolLtrMode.enType = pMsg_DiagMode->OnVolLimiter;
        LinSet_MuteRampMode.enType = pMsg_DiagMode->MuteRamp ;
        LinSet_VolumeRampMode.enType = pMsg_DiagMode->VolRamp ;
        LinSet_ClippingMode.enType = pMsg_DiagMode->Clipping;
        LinSet_PresetMode.enType = pMsg_DiagMode->Preset;

        if(LinSet_OnVolLtrMode.enType == (midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF))
        {
          ETG_TRACE_USR4(("PO message ID_OnVolLimiter sent")) ;
             ID_OnVolLimiter oOnVolLimiter(LinSet_OnVolLtrMode);
          InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oOnVolLimiter);
        }
        break;
      }

     case (PO_MessageConfig::ID_DiagLinearMode):
        {
            const ID_DiagLinearMode*   pMsg_LinModePhase = pPO->POMessages->QueryMessage<ID_DiagLinearMode>(MsgId);
            LinSet_DiagLinModePhase = pMsg_LinModePhase->enDiagLinearModePhase;
              break;
        }
     case (PO_MessageConfig::ID_SetSource):
        {
            const MSG_SetSource*   pMsg_Stream = pPO->POMessages->QueryMessage<MSG_SetSource>(MsgId);
            Stream = pMsg_Stream->enStream;
              break;
        }

     default:
       ETG_TRACE_USR4(("Default case"));
     }

    if((LinSet_DiagAud.enType == (midw_fi_tcl_e8_DiagAudMode::FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_ON))||(LinSet_DiagLinModePhase == EN_LINEARMODE_SET))
  {
      ETG_TRACE_USR4(("PO message MSG_VolumeOffsetAux sent")) ;

       MSG_VolumeOffsetAux oVolOffsetAux_Linear(AuxLevel_Linear);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oVolOffsetAux_Linear);

     SetAudModeToLinear();

  }

  else if((LinSet_DiagAud.enType == (midw_fi_tcl_e8_DiagAudMode::FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_OFF))||(LinSet_DiagLinModePhase == EN_LINEARMODE_UNFREEZE))
  {

      ResetAudModeToNonLinear();

      //Setting back the previous Aux level
        tU8 AuxVal;
    dp_tclAudioManagerDPAuxInLevel oAuxInLevel;
    tS32 s32Res = oAuxInLevel.s32GetData(AuxVal);
    AuxLevel_Org = tenAuxInLevel(AuxVal);
    ETG_TRACE_USR4(("enAuxInLevel = %x",AuxLevel_Org ));
    ETG_TRACE_USR4(("REsult = %x",s32Res ));

      MSG_VolumeOffsetAux oVolOffsetAux_NonLinear(AuxLevel_Org);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oVolOffsetAux_NonLinear);

      if(MsgId == PO_MessageConfig::ID_CCAStart_AudDiagMode)
      {
        if(LinSet_MuteRampMode.enType == midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF )
             ModeMaskUnion_Obj.ModeMaskBits_Obj.Mute                 = 1;


        if(LinSet_VolumeRampMode.enType == midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF )
          ModeMaskUnion_Obj.ModeMaskBits_Obj.VolumeRamp           = 1;


        if(LinSet_ClippingMode.enType == midw_fi_tcl_e8_GenericDiagAudMode::FI_EN_FEATURE_OFF)
           ModeMaskUnion_Obj.ModeMaskBits_Obj.Clipping             = 1;

      }
  }

    ETG_TRACE_USR4(("ModeMask Value to be sent to SinkManager = %x", ModeMaskUnion_Obj.ModeMask ));
    MSG_MaintenanceMode oMaintananceMode(Stream ,ModeMaskUnion_Obj.ModeMask );
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMaintananceMode);

    if(this->poAudioService->updateClients(MIDW_MASCFFI_C_U16_DIAGAUDMODE) != AIL_EN_N_NO_ERROR){
       ETG_TRACE_ERR(("ERROR: eUpdateClients():-> Updating the clients for DiagAudModeStatus failed"));
    }
    else {
       ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients for DiagAudModeStatus =%x OK",ModeMaskUnion_Obj.ModeMask));
    }

}



