/*
 * IDNotification.h
 *
 *  Created on: 11.03.2013
 *      Author: hag2hi
 */

#ifndef IDNOTIFICATION_H_
#define IDNOTIFICATION_H_
#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_Notification
 *
 *******************************************************************************/

class ID_Notification: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_Notification(tU8 ubControl, tU8 ubFunctionID)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: ubControl, ubFunctionID
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_Notification(tU8 ubControlType, tU16 uwFunctionID) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_Notification), ControlType(ubControlType), FunctionID(uwFunctionID)
   {
   }

   tU8 ControlType;
   tU16 FunctionID;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_Notification* clone() const
   {
      return new ID_Notification(*this);
   }
};




#endif /* IDNOTIFICATION_H_ */
