/*************************************************************************
 *File          :  IDSetMute.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDSETMUTE_H_
#define IDSETMUTE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../DataTypes/TypeDefines/MuteAction.h"

/*******************************************************************************
 *
 * CLASS:ID_SetMute
 *
 *******************************************************************************/

class ID_SetMute: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_SetMute(tenStream enStream, tenMuteAction enMuteAction, tU16 u16RampLin, tU16 u16RampdB)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream,enMuteAction,u16RampLin,u16RampdB
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_SetMute(tenStream enstream, tenMuteAction enmuteaction, tU16 u16rampLin, tU16 u16rampdB, tU16 u16sink) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetMute), enStream(enstream), enMuteAction(enmuteaction), u16RampLin(u16rampLin), u16RampdB(u16rampdB), u16Sink(u16sink)
   {
   }
   ;


   tenStream enStream;
   tenMuteAction enMuteAction;
   tU16 u16RampLin;
   tU16 u16RampdB;
   tU16 u16Sink;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_SetMute *clone() const
   {
      return new ID_SetMute(*this);
   }
};

#endif /* IDCCASTARTMUTE_H_ */
